/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IFolder;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ITabFolderPartLifeCycleEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;

public class SashContainerFolderEventsProvider {
    private List<ITabFolderPartLifeCycleEventsListener> listeners = new ArrayList<ITabFolderPartLifeCycleEventsListener>();
    protected List<IFolder> folders;
    protected List<TabFolderPart> tabFolderParts;

    public List<IFolder> getFolders() {
        return this.tabFolderParts;
    }

    public void addListener(ITabFolderPartLifeCycleEventsListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(ITabFolderPartLifeCycleEventsListener listener) {
        this.listeners.remove(listener);
    }

    public void fireFolderCreatedEvent(TabFolderPart folder) {
        for (ITabFolderPartLifeCycleEventsListener listener : this.listeners) {
            listener.folderCreated(folder);
        }
    }

    public void fireFolderDisposedEvent(TabFolderPart folder) {
        for (ITabFolderPartLifeCycleEventsListener listener : this.listeners) {
            listener.folderDisposed(folder);
        }
    }
}

