/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberConversions {
    private NumberConversions() {
    }

    public static Object convertNumber(Object value, Class<?> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            return value;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == targetClass || !(value instanceof Number)) {
            return value;
        }
        Number numVal = (Number)value;
        if (targetClass == BigInteger.class) {
            return new BigInteger(String.valueOf(numVal.longValue()));
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return new Long(numVal.longValue());
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            return new Integer(numVal.intValue());
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            return new Short(numVal.shortValue());
        }
        if (targetClass == Byte.class || targetClass == Byte.TYPE) {
            return new Byte(numVal.byteValue());
        }
        if (targetClass == BigDecimal.class) {
            return new BigDecimal(String.valueOf(numVal.doubleValue()));
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return new Double(numVal.doubleValue());
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return new Float(numVal.floatValue());
        }
        return value;
    }

    public static <T extends Number> T strictConvertNumber(Object value, Class<T> targetClass) {
        Object converted = NumberConversions.convertNumber(value, targetClass);
        return (T)(targetClass.isInstance(converted) ? (Number)((Number)targetClass.cast(converted)) : (Number)null);
    }
}

