/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;

public abstract class AbstractIndex {
    private final CopyOnWriteArrayList<Computation<?>> computations = new CopyOnWriteArrayList();

    protected AbstractIndex() {
    }

    final <T> Computation<T> addComputation(Computation<T> computation) {
        this.computations.addIfAbsent(computation);
        return computation;
    }

    protected final void resetComputations() {
        this.computations.forEach((Consumer<Computation<?>>)((Consumer<Computation>)Computation::reset));
    }

    protected final <T> CompletableFuture<T> asyncGet(Computation<T> computation) {
        return computation.get();
    }

    protected final <T, U> CompletableFuture<U> asyncTransform(Computation<T> computation, Function<? super T, ? extends U> transformation) {
        return computation.get().thenApply(transformation);
    }

    protected final <T> T get(Computation<T> computation) {
        T result = null;
        try {
            CompletableFuture<T> futureResult = this.asyncGet(computation);
            result = futureResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying model index.", (Throwable)e);
            throw new OperationCanceledException();
        }
        return result;
    }

    protected final <T> T get(Computation<T> computation, T defaultValue) {
        T result;
        try {
            CompletableFuture<T> futureResult = this.asyncGet(computation);
            result = futureResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying model index.", (Throwable)e);
            result = defaultValue;
        }
        return result;
    }

    protected final <T, U> U transform(Computation<T> computation, Function<? super T, ? extends U> transformation) {
        U result = null;
        try {
            CompletableFuture<U> futureResult = this.asyncTransform(computation, transformation);
            result = futureResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying model index.", (Throwable)e);
            throw new OperationCanceledException();
        }
        return result;
    }

    protected final <T, U> U transform(Computation<T> computation, T defaultValue, Function<? super T, ? extends U> transformation) {
        U result;
        try {
            CompletableFuture<U> futureResult = this.asyncTransform(computation, transformation);
            result = futureResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying model index.", (Throwable)e);
            result = transformation.apply(defaultValue);
        }
        return result;
    }

    protected final <T, U, V> CompletableFuture<V> asyncCombine(Computation<T> computation1, Computation<U> computation2, BiFunction<? super T, ? super U, ? extends V> combination) {
        return computation1.get().thenCombine(computation2.get(), combination);
    }

    protected final <T, U, V> V combine(Computation<T> computation1, Computation<U> computation2, BiFunction<? super T, ? super U, ? extends V> combination) {
        V result;
        try {
            CompletableFuture<V> futureResult = this.asyncCombine(computation1, computation2, combination);
            result = futureResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying model index.", (Throwable)e);
            throw new OperationCanceledException();
        }
        return result;
    }

    protected final <T, U, V> V combine(Computation<T> computation1, T defaultValue1, Computation<U> computation2, U defaultValue2, BiFunction<? super T, ? super U, ? extends V> combination) {
        V result;
        try {
            CompletableFuture<V> futureResult = this.asyncCombine(computation1, computation2, combination);
            result = futureResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying model index.", (Throwable)e);
            result = combination.apply(defaultValue1, defaultValue2);
        }
        return result;
    }

    protected final class Computation<T> {
        private final AtomicReference<CompletableFuture<T>> computation = new AtomicReference();
        private final Supplier<T> computer;

        public Computation(Supplier<T> computer) {
            this.computer = computer;
            AbstractIndex.this.addComputation(this);
        }

        CompletableFuture<T> get() {
            CompletableFuture newResult = new CompletableFuture();
            CompletableFuture<T> result = this.computation.compareAndExchange(null, newResult);
            if (result == null) {
                result = newResult;
                result.complete(this.computer.get());
            }
            return result;
        }

        void reset() {
            Optional.ofNullable(this.computation.getAndSet(null)).ifPresent(future -> {
                boolean bl = future.cancel(false);
            });
        }
    }
}

