/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.Theme;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.WorkspaceThemes;
import org.eclipse.papyrus.infra.properties.ui.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFContentProvider;
import org.eclipse.papyrus.infra.ui.util.PapyrusImageUtils;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSThemeEditionDialog
extends Dialog {
    private static final String ICON_SELECTION_DIALOG_TITLE = "Icon selection";
    private static final String WORKSPACE_MENU_LABEL = "Workspace";
    private static final String FILESYSTEM_MENU_LABEL = "File System";
    private static final int WORKSPACE_MENU_ID = 23;
    private static final int FILESYSTEM_MENU_ID = 22;
    private static final int EDIT_BUTTON_ID = 19;
    private static final int DOWN_BUTTON_ID = 18;
    private static final int UP_BUTTON_ID = 17;
    private static final int DELETE_BUTTON_ID = 15;
    private static final int ADD_BUTTON_ID = 14;
    private static final int BROWSE_BUTTON_ID = 16;
    private static int[] actionIdList = new int[]{18, 17, 15, 14, 16, 19};
    private static final String ADD_DIALOG_TITLE = "Style sheets selection";
    private static final Image EDIT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Edit_12x12.gif").createImage();
    private static final Image DELETE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Delete_12x12.gif").createImage();
    private static final Image ADD_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Add_12x12.gif").createImage();
    private static final Image UP_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Up_12x12.gif").createImage();
    private static final Image DOWN_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Down_12x12.gif").createImage();
    private static final String STYLE_SHEETS_LABEL = "Style sheets";
    private static final String BROWSE_BUTTON_LABEL = "Browse...";
    private static final String THEME_ICON_LABEL = "Icon";
    private static final String THEME_NAME_LABEL = "Label";
    private static final String THEME_COMBO_LABEL = "Theme";
    private static final String DIALOG_TITLE = "CSS Theme Edition";
    private List<String> filterExtensions = Arrays.asList("*.gif;*.png;*.jpeg", "*.gif", "*.png", "*.jpeg");
    private List<String> filterNames = Arrays.asList("All images", "GIF Icon", "PNG Icon", "JPEG Icon");
    private Text themeLabelField = null;
    private Text iconPathfield = null;
    private WorkspaceThemes workspaceThemes = null;
    private List<StyleSheet> selectedStyleSheetsList = null;
    private TreeViewer themeStyleSheetsViewer = null;
    private EcorePropertyEditorFactory editorFactory = new EcorePropertyEditorFactory(StylesheetsPackage.eINSTANCE.getTheme_Stylesheets());
    private Theme currentTheme = null;
    private LabelProvider labelProvider = null;
    private Menu browseMenu = null;

    public CSSThemeEditionDialog(Shell parentShell, WorkspaceThemes themes, IStructuredSelection parentSelection) {
        super(parentShell);
        this.workspaceThemes = themes;
        this.initialiseFilterLabels(this.filterNames, this.filterExtensions);
        this.initialiseWithSelection(parentSelection);
    }

    private void initialiseFilterLabels(List<String> filterNames, List<String> filterExtensions) {
        int size = Math.min(filterNames.size(), filterExtensions.size());
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = String.valueOf(filterNames.get(i)) + " (" + filterExtensions.get(i) + ")";
            ++i;
        }
        this.filterNames = Arrays.asList(filters);
    }

    private void initialiseWithSelection(IStructuredSelection selection) {
        Assert.isNotNull((Object)selection);
        this.selectedStyleSheetsList = new ArrayList<StyleSheet>();
        Iterator selectionIterator = selection.iterator();
        StylesheetsFactory styleSheetsFactory = StylesheetsFactory.eINSTANCE;
        while (selectionIterator.hasNext()) {
            Object object = selectionIterator.next();
            if (!(object instanceof IFile)) continue;
            StyleSheetReference reference = styleSheetsFactory.createStyleSheetReference();
            reference.setPath(((IFile)object).getFullPath().toString());
            this.selectedStyleSheetsList.add((StyleSheet)reference);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
        newShell.setImage(PapyrusImageUtils.getDefaultIcon());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        this.createEditedThemeComposite(container);
        this.createThemeLabelPart(container);
        this.createThemeIconPart(container);
        this.createTreeActionButtons(container);
        this.createThemeStyleSheetsPart(container);
        this.refreshDialogContent(null);
        return container;
    }

    private void createEditedThemeComposite(Composite parent) {
        Label themeLabel = new Label(parent, 0);
        themeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        themeLabel.setText(THEME_COMBO_LABEL);
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CSSThemeEditionDialog.this.refreshDialogContent(event.getSelection());
            }
        });
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String text = super.getText(element);
                if (element instanceof Theme) {
                    text = ((Theme)element).getLabel();
                }
                return text;
            }
        });
        comboViewer.setContentProvider((IContentProvider)new EMFContentProvider((EObject)this.workspaceThemes, (EStructuralFeature)StylesheetsPackage.eINSTANCE.getWorkspaceThemes_Themes()){

            protected IStructuredContentProvider getSemanticProvider(final EObject editedEObject, EStructuralFeature feature) {
                return new AbstractStaticContentProvider(){

                    public Object[] getElements() {
                        LinkedList result = new LinkedList();
                        if (editedEObject instanceof WorkspaceThemes) {
                            result.addAll(CSSThemeEditionDialog.this.workspaceThemes.getThemes());
                        }
                        return result.toArray();
                    }
                };
            }
        });
        comboViewer.setInput((Object)this.workspaceThemes.getThemes());
        Combo combo = comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    private void createThemeLabelPart(Composite parent) {
        Label themeNameLabel = new Label(parent, 0);
        themeNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        themeNameLabel.setText(THEME_NAME_LABEL);
        this.themeLabelField = new Text(parent, 2048);
        GridData gd_text = new GridData(4, 0x1000000, true, false, 2, 1);
        this.themeLabelField.setLayoutData((Object)gd_text);
        this.themeLabelField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSSThemeEditionDialog.this.currentTheme.setLabel(CSSThemeEditionDialog.this.themeLabelField.getText());
            }
        });
    }

    private void createThemeIconPart(Composite parent) {
        Label iconLabel = new Label(parent, 0);
        iconLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        iconLabel.setText(THEME_ICON_LABEL);
        this.iconPathfield = new Text(parent, 2048);
        this.iconPathfield.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.iconPathfield.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSSThemeEditionDialog.this.currentTheme.setIcon(CSSThemeEditionDialog.this.iconPathfield.getText());
            }
        });
        Button browseButton = this.createButton(parent, 16, BROWSE_BUTTON_LABEL, false);
        this.browseMenu = new Menu((Control)browseButton);
        this.createMenuItem(this.browseMenu, FILESYSTEM_MENU_LABEL, 22);
        this.createMenuItem(this.browseMenu, WORKSPACE_MENU_LABEL, 23);
    }

    private void createMenuItem(Menu parentMenu, String label, int menuId) {
        MenuItem menuItem = new MenuItem(this.browseMenu, 0);
        menuItem.setText(label);
        menuItem.setData((Object)new Integer(menuId));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSSThemeEditionDialog.this.menuSelected((Integer)e.widget.getData());
            }
        });
    }

    private void menuSelected(int menuId) {
        switch (menuId) {
            case 23: {
                this.browseWorkspace();
                break;
            }
            case 22: {
                this.browseFileSytem();
                break;
            }
        }
    }

    private void browseFileSytem() {
        File file = this.getFile(this.iconPathfield.getText());
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(ICON_SELECTION_DIALOG_TITLE);
        dialog.setFileName(file.getAbsolutePath());
        dialog.setFilterExtensions(this.filterExtensions.toArray(new String[this.filterExtensions.size()]));
        dialog.setFilterNames(this.filterNames.toArray(new String[this.filterNames.size()]));
        String result = dialog.open();
        if (result == null) {
            return;
        }
        this.setResult(result);
    }

    private void browseWorkspace() {
        Object file;
        Object[] result;
        int code;
        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
        try {
            labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        ILabelProvider labelProvider = labelProviderService.getLabelProvider();
        IFile currentFile = this.getIFile(this.iconPathfield.getText());
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle(ICON_SELECTION_DIALOG_TITLE);
        WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
        if (!this.filterExtensions.isEmpty() && !this.filterNames.isEmpty()) {
            contentProvider.setExtensionFilters(new LinkedHashMap());
            int i = 0;
            while (i < Math.min(this.filterNames.size(), this.filterExtensions.size())) {
                contentProvider.addExtensionFilter(this.filterExtensions.get(i), this.filterNames.get(i));
                ++i;
            }
        }
        dialog.setContentProvider((ITreeContentProvider)contentProvider);
        dialog.setLabelProvider(labelProvider);
        if (currentFile != null && currentFile.exists()) {
            dialog.setInitialSelections((Object[])new IFile[]{currentFile});
        }
        if ((code = dialog.open()) == 0 && (result = dialog.getResult()).length > 0 && (file = result[0]) instanceof IFile) {
            this.setResult((IFile)file);
        }
    }

    protected void setResult(IFile file) {
        this.iconPathfield.setText(file.getFullPath().toString());
    }

    protected void setResult(File file) {
        this.iconPathfield.setText(file.getAbsolutePath());
    }

    protected void setResult(String path) {
        this.iconPathfield.setText(path);
    }

    protected IFile getIFile(String path) {
        return FileUtil.getIFile((String)path);
    }

    protected File getFile(String path) {
        return FileUtil.getFile((String)path);
    }

    private void createThemeStyleSheetsPart(Composite parent) {
        this.themeStyleSheetsViewer = new TreeViewer(parent, 2048);
        this.themeStyleSheetsViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.labelProvider = new LabelProvider(){

            public String getText(Object element) {
                String text = super.getText(element);
                if (element instanceof StyleSheetReference) {
                    text = ((StyleSheetReference)element).getPath();
                } else if (element instanceof EmbeddedStyleSheet) {
                    text = ((EmbeddedStyleSheet)element).getLabel();
                }
                return text;
            }
        };
        this.themeStyleSheetsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        Tree tree = this.themeStyleSheetsViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
    }

    private void createTreeActionButtons(Composite parent) {
        Label labelViewer = new Label(parent, 0);
        labelViewer.setText(STYLE_SHEETS_LABEL);
        Composite buttonsPanel = new Composite(parent, 0);
        buttonsPanel.setLayout((Layout)new GridLayout());
        buttonsPanel.setLayoutData((Object)new GridData(131072, 4, true, false, 2, 1));
        this.createButton(buttonsPanel, 14, ADD_ICON, false);
        this.createButton(buttonsPanel, 15, DELETE_ICON, false);
        this.createButton(buttonsPanel, 17, UP_ICON, false);
        this.createButton(buttonsPanel, 18, DOWN_ICON, false);
        this.createButton(buttonsPanel, 19, EDIT_ICON, false);
    }

    protected Button createButton(Composite parent, int id, Image icon, boolean defaultButton) {
        Button button = super.createButton(parent, id, "", defaultButton);
        button.setImage(icon);
        return button;
    }

    protected void setButtonLayoutData(Button button) {
        Object data = button.getData();
        int buttonId = -1;
        if (data instanceof Integer) {
            buttonId = (Integer)data;
        }
        switch (buttonId) {
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                button.setLayoutData((Object)new GridData(4, 4, false, false));
                break;
            }
            default: {
                super.setButtonLayoutData(button);
            }
        }
    }

    private void deleteAction() {
        ISelection selection = this.themeStyleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof StyleSheet) {
                this.currentTheme.getStylesheets().remove(selectedElement);
            }
            this.themeStyleSheetsViewer.setInput((Object)this.currentTheme.getStylesheets());
            this.refreshTreeviewer(this.currentTheme);
        }
    }

    private void addAction() {
        ReferenceSelector selector = new ReferenceSelector(true);
        selector.setContentProvider((IStaticContentProvider)new EMFContentProvider((EObject)this.currentTheme, (EStructuralFeature)StylesheetsPackage.eINSTANCE.getTheme_Stylesheets()){

            protected IStructuredContentProvider getSemanticProvider(final EObject editedEObject, EStructuralFeature feature) {
                return new AbstractStaticContentProvider(){

                    public Object[] getElements() {
                        LinkedList result = new LinkedList();
                        if (editedEObject instanceof Theme) {
                            result.addAll(CSSThemeEditionDialog.this.currentTheme.getStylesheets());
                        }
                        return result.toArray();
                    }
                };
            }
        });
        selector.setLabelProvider((ILabelProvider)this.labelProvider);
        MultipleValueSelectorDialog vDialog = new MultipleValueSelectorDialog(this.getShell(), (IElementSelector)selector, ADD_DIALOG_TITLE);
        vDialog.setContextElement((Object)this.currentTheme);
        vDialog.setLabelProvider((ILabelProvider)this.labelProvider);
        vDialog.setFactory((ReferenceValueFactory)new EcorePropertyEditorFactory(StylesheetsPackage.Literals.THEME__STYLESHEETS));
        int result = vDialog.open();
        if (result == 0) {
            Object[] resultArray = vDialog.getResult();
            this.refreshStyleSheets(resultArray);
        }
    }

    private void upAction() {
        EList stylesheetsList;
        int index;
        Object selectedElement;
        ISelection selection = this.themeStyleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet && (index = (stylesheetsList = this.currentTheme.getStylesheets()).indexOf(selectedElement)) > 0) {
            stylesheetsList.move(--index, (Object)((StyleSheet)selectedElement));
            this.themeStyleSheetsViewer.setInput((Object)stylesheetsList);
        }
    }

    private void downAction() {
        EList stylesheetsList;
        int index;
        Object selectedElement;
        ISelection selection = this.themeStyleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet && (index = (stylesheetsList = this.currentTheme.getStylesheets()).indexOf(selectedElement)) < stylesheetsList.size() - 1) {
            stylesheetsList.move(++index, (Object)((StyleSheet)selectedElement));
            this.themeStyleSheetsViewer.setInput((Object)stylesheetsList);
        }
    }

    private void editAction() {
        Object selectedObject;
        ISelection selection = this.themeStyleSheetsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof StyleSheet) {
            this.editorFactory.edit(this.getContents(), selectedObject);
        }
    }

    private void refreshStyleSheets(Object[] result) {
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof StyleSheet) {
                this.currentTheme.getStylesheets().add((Object)((StyleSheet)object));
            }
            ++n2;
        }
        this.refreshTreeviewer(this.currentTheme);
    }

    private void refreshTreeviewer(Theme currentTheme) {
        if (currentTheme != null) {
            EList themeStyleSheetsList = currentTheme.getStylesheets();
            for (StyleSheet basereference : this.selectedStyleSheetsList) {
                boolean found = false;
                int i = 0;
                while (i < themeStyleSheetsList.size() && !found) {
                    found = StylesheetsComparator.instance.compare((StyleSheet)themeStyleSheetsList.get(i), basereference) == 0;
                    ++i;
                }
                if (found) continue;
                themeStyleSheetsList.add((Object)basereference);
            }
            this.themeStyleSheetsViewer.setInput((Object)themeStyleSheetsList);
        }
        this.updateButtons(currentTheme);
    }

    private void updateButtons(Theme currentTheme) {
        boolean editionEnable = currentTheme != null;
        int[] nArray = actionIdList;
        int n = actionIdList.length;
        int n2 = 0;
        while (n2 < n) {
            int buttonId = nArray[n2];
            switch (buttonId) {
                case 14: 
                case 16: {
                    this.getButton(buttonId).setEnabled(editionEnable);
                    break;
                }
                case 15: 
                case 19: {
                    this.getButton(buttonId).setEnabled(editionEnable && !currentTheme.getStylesheets().isEmpty());
                    break;
                }
                case 17: 
                case 18: {
                    this.getButton(buttonId).setEnabled(editionEnable && currentTheme.getStylesheets().size() > 1);
                }
            }
            ++n2;
        }
    }

    protected void refreshDialogContent(ISelection selection) {
        Object selectedElement;
        this.currentTheme = null;
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Theme) {
            this.currentTheme = (Theme)selectedElement;
        }
        boolean editionEnable = this.currentTheme != null;
        this.themeLabelField.setEditable(editionEnable);
        this.iconPathfield.setEditable(editionEnable);
        if (editionEnable) {
            String themeLabel = this.currentTheme.getLabel();
            if (themeLabel == null) {
                themeLabel = "";
            }
            this.themeLabelField.setText(themeLabel);
            String iconPath = this.currentTheme.getIcon();
            if (iconPath == null) {
                iconPath = "";
            }
            this.iconPathfield.setText(iconPath);
        }
        this.refreshTreeviewer(this.currentTheme);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 14: {
                this.addAction();
                break;
            }
            case 15: {
                this.deleteAction();
                break;
            }
            case 16: {
                this.browseMenu.setVisible(true);
                break;
            }
            case 17: {
                this.upAction();
                break;
            }
            case 18: {
                this.downAction();
                break;
            }
            case 19: {
                this.editAction();
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected boolean isResizable() {
        return true;
    }

    public Theme getEditedTheme() {
        return this.currentTheme;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StylesheetsComparator
    implements Comparator<StyleSheet> {
        public static final Comparator<StyleSheet> instance = new StylesheetsComparator();

        @Override
        public int compare(StyleSheet firstStyleSheet, StyleSheet secondStyleSheet) {
            boolean comparisonResult = false;
            String rightOperand = null;
            String leftOperand = null;
            if (firstStyleSheet instanceof StyleSheetReference && secondStyleSheet instanceof StyleSheetReference) {
                rightOperand = ((StyleSheetReference)firstStyleSheet).getPath();
                leftOperand = ((StyleSheetReference)secondStyleSheet).getPath();
                comparisonResult = rightOperand.equals(leftOperand);
            } else if (firstStyleSheet instanceof EmbeddedStyleSheet && secondStyleSheet instanceof EmbeddedStyleSheet) {
                rightOperand = ((EmbeddedStyleSheet)firstStyleSheet).getLabel();
                leftOperand = ((EmbeddedStyleSheet)secondStyleSheet).getLabel();
                comparisonResult = rightOperand.equals(leftOperand);
            }
            int comparisonValue = -1;
            if (comparisonResult) {
                comparisonValue = 0;
            }
            return comparisonValue;
        }
    }
}

