/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.views;

import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.jface.action.Action;

public class RedoAction
extends Action {
    private final IModelResource resource;
    private final IModelResource.Listener listener;

    public RedoAction(IModelResource resource) {
        this.resource = resource;
        this.listener = new IModelResource.Listener(){

            public void dirtyStateChanged() {
            }

            public void commandStackChanged() {
                RedoAction.this.update();
            }
        };
        resource.addListener(this.listener);
        this.update();
    }

    public void run() {
        if (this.resource.canRedo().isOK()) {
            this.resource.redo();
        }
    }

    private void update() {
        if (this.resource.canRedo().isOK()) {
            this.setText("Redo " + this.resource.getEditingDomain().getCommandStack().getRedoCommand().getLabel());
            this.setEnabled(true);
        } else {
            this.setText("Redo");
            this.setEnabled(false);
        }
    }

    public void dispose() {
        this.resource.removeListener(this.listener);
    }
}

