/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.views;

import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.jface.action.Action;

public class UndoAction
extends Action {
    private final IModelResource resource;
    private final IModelResource.Listener listener;

    public UndoAction(IModelResource resource) {
        this.resource = resource;
        this.listener = new IModelResource.Listener(){

            public void dirtyStateChanged() {
            }

            public void commandStackChanged() {
                UndoAction.this.update();
            }
        };
        resource.addListener(this.listener);
        this.update();
    }

    public void run() {
        if (this.resource.canUndo().isOK()) {
            this.resource.undo();
        }
    }

    private void update() {
        if (this.resource.canUndo().isOK()) {
            this.setText("Undo " + this.resource.getEditingDomain().getCommandStack().getUndoCommand().getLabel());
            this.setEnabled(true);
        } else {
            this.setText("Undo");
            this.setEnabled(false);
        }
    }

    public void dispose() {
        this.resource.removeListener(this.listener);
    }
}

