/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.views;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.example.databinding.project.ui.rcp.Activator;
import org.eclipse.emf.example.databinding.project.ui.rcp.NLSMessages;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.FormTextProperty;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.UpdateStrategyFactory;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.Util;
import org.eclipse.emf.example.databinding.project.ui.rcp.dialogs.PersonFilterDialog;
import org.eclipse.emf.example.databinding.project.ui.rcp.views.ProjectCommittersPart;
import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.emf.examples.databinding.project.core.model.project.Person;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectPackage;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProjectFormAreaPart {
    private DataBindingContext ctx;
    private Form form;
    private ProjectCommittersPart committerPart;
    private Image projectImage;

    public ProjectFormAreaPart(IViewSite site, Composite parent, FormToolkit toolkit, IModelResource resource, ObservablesManager manager, IObservableValue master) {
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/obj16/generic_elements.gif");
        this.projectImage = desc != null ? desc.createImage() : null;
        this.createFormArea(site, parent, toolkit, resource, manager, master);
    }

    private void createFormArea(IViewSite site, final Composite parent, FormToolkit toolkit, final IModelResource resource, ObservablesManager manager, final IObservableValue master) {
        final EditingDomain editingDomain = resource.getEditingDomain();
        this.ctx = new EMFDataBindingContext();
        Util.masterDetailFixup(this.ctx, master);
        this.addStatusSupport(manager, this.ctx);
        this.form = toolkit.createForm(parent);
        toolkit.decorateFormHeading(this.form);
        this.form.setText(" ");
        this.form.setImage(this.projectImage);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout(3, false));
        IWidgetValueProperty prop = WidgetProperties.text((int)24);
        IEMFEditValueProperty shortProp = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__SHORTNAME);
        toolkit.createLabel(body, "&Short name");
        Text t = toolkit.createText(body, "");
        t.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.ctx.bindValue((IObservableValue)prop.observeDelayed(400, (Widget)t), shortProp.observeDetail(master));
        IEMFEditValueProperty longProp = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__LONGNAME);
        toolkit.createLabel(body, "&Long name");
        t = toolkit.createText(body, "");
        t.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.ctx.bindValue((IObservableValue)prop.observeDelayed(400, (Widget)t), longProp.observeDetail(master));
        ComputedValue cVal = new ComputedValue((IEMFValueProperty)shortProp, master, (IEMFValueProperty)longProp){
            private IObservableValue shortname;
            private IObservableValue longname;
            {
                this.shortname = iEMFValueProperty.observeDetail(iObservableValue);
                this.longname = iEMFValueProperty2.observeDetail(iObservableValue);
            }

            protected Object calculate() {
                return this.shortname.getValue() + " - " + this.longname.getValue();
            }
        };
        manager.addObservable((IObservable)cVal);
        this.ctx.bindValue(FormTextProperty.create().observe((Object)this.form), (IObservableValue)cVal);
        IEMFEditValueProperty mProp = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__START);
        toolkit.createLabel(body, "Start Date");
        t = toolkit.createText(body, "");
        t.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.ctx.bindValue((IObservableValue)prop.observeDelayed(400, (Widget)t), mProp.observeDetail(master), (UpdateValueStrategy)UpdateStrategyFactory.stringToDateNotNull(NLSMessages.ProjectAdminViewPart_StartDateNotParseable, "Start date must not be null"), (UpdateValueStrategy)UpdateStrategyFactory.dateToString());
        mProp = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__END);
        toolkit.createLabel(body, "End Date");
        t = toolkit.createText(body, "");
        t.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.ctx.bindValue((IObservableValue)prop.observeDelayed(400, (Widget)t), mProp.observeDetail(master), (UpdateValueStrategy)UpdateStrategyFactory.stringToDate(NLSMessages.ProjectAdminViewPart_EndDateNotParseable), (UpdateValueStrategy)UpdateStrategyFactory.dateToString());
        mProp = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__HOMEPAGE);
        toolkit.createLabel(body, "Homepage");
        t = toolkit.createText(body, "");
        t.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.ctx.bindValue((IObservableValue)prop.observeDelayed(400, (Widget)t), mProp.observeDetail(master));
        mProp = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__DEVMAIL);
        toolkit.createLabel(body, "Dev-Mail");
        t = toolkit.createText(body, "");
        t.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.ctx.bindValue((IObservableValue)prop.observeDelayed(400, (Widget)t), mProp.observeDetail(master));
        mProp = EMFEditProperties.list((EditingDomain)editingDomain, (EStructuralFeature)ProjectPackage.Literals.PROJECT__PROJECTLEADS);
        toolkit.createLabel(body, "Project Leads").setLayoutData((Object)new GridData(128, -1, false, false));
        Table c = toolkit.createTable(body, 68354);
        final TableViewer tv = new TableViewer(c);
        tv.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Person p = (Person)element;
                return String.valueOf(p.getLastname()) + ", " + p.getFirstname();
            }
        });
        tv.setContentProvider((IContentProvider)new ObservableListContentProvider());
        tv.setInput((Object)mProp.observeDetail(master));
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        c.setLayoutData((Object)gd);
        Composite buttonContainer = toolkit.createComposite(body);
        buttonContainer.setLayoutData((Object)new GridData(-1, 1024, false, false));
        buttonContainer.setLayout((Layout)new GridLayout());
        Button b = toolkit.createButton(buttonContainer, "Add ...", 0x800000);
        gd = new GridData(-1, -1);
        gd.horizontalAlignment = 4;
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command cmd;
                PersonFilterDialog dialog = new PersonFilterDialog(parent.getShell(), resource);
                if (dialog.open() == 0 && (cmd = AddCommand.create((EditingDomain)editingDomain, (Object)master.getValue(), (Object)ProjectPackage.Literals.PROJECT__PROJECTLEADS, (Object)dialog.getFirstResult())).canExecute()) {
                    resource.executeCmd(cmd);
                }
            }
        });
        b = toolkit.createButton(buttonContainer, "Remove", 0x800000);
        gd = new GridData(-1, -1);
        gd.horizontalAlignment = 4;
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command cmd;
                IStructuredSelection s = (IStructuredSelection)tv.getSelection();
                if (!s.isEmpty() && (cmd = RemoveCommand.create((EditingDomain)editingDomain, (Object)master.getValue(), (Object)ProjectPackage.Literals.PROJECT__PROJECTLEADS, (Collection)s.toList())).canExecute()) {
                    resource.executeCmd(cmd);
                }
            }
        });
        this.addTabArea(site, body, toolkit, this.ctx, editingDomain, manager, master);
        body.setBackgroundMode(1);
    }

    private void addTabArea(IViewSite site, Composite parent, FormToolkit toolkit, DataBindingContext ctx, EditingDomain editingDomain, ObservablesManager manager, IObservableValue master) {
        CTabFolder folder = new CTabFolder(parent, 2048);
        folder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        folder.setSelectionBackground(new Color[]{toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END"), toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START")}, new int[]{25}, true);
        folder.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        folder.setSelectionForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        folder.setSimple(false);
        this.committerPart = new ProjectCommittersPart(site, folder, ctx, editingDomain, manager, master);
    }

    private void addStatusSupport(ObservablesManager mgr, final DataBindingContext ctx) {
        AggregateValidationStatus aggregateStatus = new AggregateValidationStatus((IObservableCollection)ctx.getValidationStatusProviders(), 2);
        aggregateStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ProjectFormAreaPart.this.handleStateChange((IStatus)event.diff.getNewValue(), ctx);
            }
        });
    }

    private void handleStateChange(IStatus currentStatus, DataBindingContext ctx) {
        if (this.form.isDisposed() || this.form.getHead().isDisposed()) {
            return;
        }
        if (currentStatus != null && currentStatus.getSeverity() != 0) {
            int type = this.convertType(currentStatus.getSeverity());
            ArrayList<6> list = new ArrayList<6>();
            for (ValidationStatusProvider validationStatusProvider : ctx.getValidationStatusProviders()) {
                final IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
                if (status.isOK()) continue;
                list.add(new IMessage(){

                    public Control getControl() {
                        return null;
                    }

                    public Object getData() {
                        return null;
                    }

                    public Object getKey() {
                        return null;
                    }

                    public String getPrefix() {
                        return null;
                    }

                    public String getMessage() {
                        return status.getMessage();
                    }

                    public int getMessageType() {
                        return ProjectFormAreaPart.this.convertType(status.getSeverity());
                    }
                });
            }
            this.form.setMessage("Data invalid", type, list.toArray(new IMessage[0]));
        } else {
            this.form.setMessage(null);
        }
    }

    private int convertType(int severity) {
        switch (severity) {
            case 0: {
                return 0;
            }
            case 8: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    public void dispose() {
        if (this.projectImage != null) {
            this.projectImage.dispose();
        }
        this.committerPart.dispose();
        if (this.ctx != null) {
            this.ctx.dispose();
        }
    }
}

