/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.view;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedPropertySheetPage
extends PropertySheetPage {
    protected List<Object> objectsToSelect = new ArrayList<Object>();
    protected AdapterFactoryEditingDomain editingDomain;
    protected DiagnosticDecorator diagnosticDecorator;
    protected IDialogSettings dialogSettings;
    protected List<?> input = Collections.emptyList();
    protected IPropertySourceProvider propertySourceProvider;
    protected IAction locateValueAction = new LocateValueAction();

    public ExtendedPropertySheetPage(AdapterFactoryEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public ExtendedPropertySheetPage(AdapterFactoryEditingDomain editingDomain, Decoration decoration) {
        this(editingDomain, decoration, null);
    }

    public ExtendedPropertySheetPage(AdapterFactoryEditingDomain editingDomain, Decoration decoration, IDialogSettings dialogSettings) {
        this(editingDomain);
        this.dialogSettings = dialogSettings;
        this.diagnosticDecorator = this.createDiagnosticDecorator(decoration);
    }

    protected DiagnosticDecorator createDiagnosticDecorator(Decoration decoration) {
        switch (decoration) {
            case MANUAL: {
                return new DiagnosticDecorator(this.editingDomain.getResourceSet(), this);
            }
            case LIVE: {
                return new DiagnosticDecorator((EditingDomain)this.editingDomain, this, this.dialogSettings);
            }
        }
        return null;
    }

    public void setPropertySourceProvider(IPropertySourceProvider newProvider) {
        this.propertySourceProvider = newProvider;
        super.setPropertySourceProvider(newProvider);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.diagnosticDecorator != null) {
            class DecoratingPropertySheetEntry
            extends PropertySheetEntry {
                DecoratingPropertySheetEntry() {
                }

                protected PropertySheetEntry createChildEntry() {
                    return new DecoratingPropertySheetEntry();
                }

                public Image getImage() {
                    Diagnostic featureDiagnostic;
                    Image image = super.getImage();
                    if (image == null) {
                        image = ExtendedImageRegistry.INSTANCE.getImage(ItemPropertyDescriptor.GENERIC_VALUE_IMAGE);
                    }
                    return (featureDiagnostic = this.findDiagnostic()) != null ? ExtendedPropertySheetPage.this.diagnosticDecorator.decorate(image, featureDiagnostic) : image;
                }

                protected Diagnostic findDiagnostic() {
                    IPropertyDescriptor descriptor = this.getDescriptor();
                    if (descriptor instanceof PropertyDescriptor) {
                        Object feature = ((PropertyDescriptor)descriptor).getFeature();
                        Map<Object, ? extends Diagnostic> decorations = ExtendedPropertySheetPage.this.diagnosticDecorator.getDecorations();
                        if (!decorations.isEmpty() && feature != null) {
                            for (Diagnostic diagnostic : decorations.values()) {
                                Diagnostic featureDiagnostic = this.find(diagnostic, feature);
                                if (featureDiagnostic == null) continue;
                                return featureDiagnostic;
                            }
                        }
                    }
                    return null;
                }

                protected Diagnostic find(Diagnostic diagnostic, Object feature) {
                    if (diagnostic.getData().contains(feature)) {
                        return diagnostic;
                    }
                    for (Diagnostic child : diagnostic.getChildren()) {
                        Diagnostic result = this.find(child, feature);
                        if (result == null) continue;
                        return result;
                    }
                    return null;
                }

                public String getDescription() {
                    String description = super.getDescription();
                    Diagnostic featureDiagnostic = this.findDiagnostic();
                    if (featureDiagnostic != null) {
                        return String.valueOf(description) + " - " + DiagnosticDecorator.strip(featureDiagnostic.getMessage());
                    }
                    return description;
                }
            }
            DecoratingPropertySheetEntry decoratingPropertySheetEntry = new DecoratingPropertySheetEntry();
            decoratingPropertySheetEntry.setPropertySourceProvider(this.propertySourceProvider);
            this.setRootEntry((IPropertySheetEntry)decoratingPropertySheetEntry);
        }
    }

    protected void setSelectionToViewer(List<?> selection) {
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        toolBarManager.add(this.locateValueAction);
    }

    public void handleEntrySelection(ISelection selection) {
        PropertySheetEntry entry;
        Object[] values;
        Object object;
        IStructuredSelection structuredSelection;
        super.handleEntrySelection(selection);
        this.objectsToSelect.clear();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (object = structuredSelection.getFirstElement()) instanceof PropertySheetEntry && (values = (entry = (PropertySheetEntry)object).getValues()) != null) {
            int i = 0;
            while (i < values.length) {
                Object value = values[i];
                if (value instanceof IItemPropertySource) {
                    Object realValue = ((IItemPropertySource)value).getEditableValue(null);
                    if (realValue instanceof Collection) {
                        for (Object o : (Collection)realValue) {
                            this.addObjectToSelect(o);
                        }
                    } else {
                        this.addObjectToSelect(realValue);
                    }
                }
                ++i;
            }
        }
        this.locateValueAction.setEnabled(!this.objectsToSelect.isEmpty());
    }

    protected void addObjectToSelect(Object object) {
        if (object instanceof EObject) {
            this.objectsToSelect.add(object);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.input = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.emptyList();
        super.selectionChanged(part, selection);
    }

    public List<?> getInput() {
        return this.input;
    }

    public void dispose() {
        if (this.diagnosticDecorator != null) {
            this.diagnosticDecorator.dispose();
        }
        super.dispose();
    }

    public void refreshLabels() {
        try {
            Field viewerField = PropertySheetPage.class.getDeclaredField("viewer");
            viewerField.setAccessible(true);
            Viewer viewer = (Viewer)viewerField.get((Object)this);
            viewer.refresh();
            return;
        }
        catch (Throwable throwable) {
            this.refresh();
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Decoration {
        NONE,
        MANUAL,
        LIVE;

    }

    protected class LocateValueAction
    extends Action {
        public LocateValueAction() {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_LocateValue_action"));
            this.setToolTipText(EMFEditUIPlugin.INSTANCE.getString("_UI_LocateValue_action_tool_tip"));
            this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/elcl16/LocateValue")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/dlcl16/LocateValue")));
        }

        public void run() {
            ArrayList<Object> selection = new ArrayList<Object>();
            for (Object object : ExtendedPropertySheetPage.this.objectsToSelect) {
                selection.add(ExtendedPropertySheetPage.this.editingDomain.getWrapper(object));
            }
            ExtendedPropertySheetPage.this.setSelectionToViewer(selection);
        }
    }
}

