/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AssociationStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AttributeStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.ClassStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.ElementStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.EvaluationElement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.MappingStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.util.AbstractExtendingEvaluationStatusVisitor;

public class EvaluationStatus2DepthVisitor
extends AbstractExtendingEvaluationStatusVisitor<Integer, Object> {
    public static final @NonNull EvaluationStatus2DepthVisitor INSTANCE = new EvaluationStatus2DepthVisitor(EvaluationStatus2DepthVisitor.class);

    private EvaluationStatus2DepthVisitor(@NonNull Object context) {
        super(context);
    }

    @Override
    public @NonNull Integer visiting(@NonNull EvaluationElement visitable) {
        throw new UnsupportedOperationException("Unsupported visit" + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }

    @Override
    public @NonNull Integer visitAssociationStatus(@NonNull AssociationStatus object) {
        Integer depth = object.getDepth();
        if (depth == null) {
            Integer thisDepth;
            depth = 0;
            for (ClassStatus classStatus : object.getFromClassStatuses()) {
                if (classStatus == null || (thisDepth = (Integer)this.visit(classStatus)) <= depth) continue;
                depth = thisDepth;
            }
            for (ClassStatus classStatus : object.getToClassStatuses()) {
                if (classStatus == null || (thisDepth = (Integer)this.visit(classStatus)) <= depth) continue;
                depth = thisDepth;
            }
            depth = depth + 1;
            object.setDepth(depth);
        }
        return depth;
    }

    @Override
    public @NonNull Integer visitAttributeStatus(@NonNull AttributeStatus object) {
        Integer depth = object.getDepth();
        if (depth == null) {
            ClassStatus classStatus = object.getOwningClassStatus();
            if (classStatus != null) {
                depth = (Integer)this.visit(classStatus);
                depth = depth + 1;
                object.setDepth(depth);
            } else {
                depth = -1;
            }
        }
        return depth;
    }

    @Override
    public @NonNull Integer visitClassStatus(@NonNull ClassStatus object) {
        Integer depth = object.getDepth();
        if (depth == null) {
            depth = 0;
            for (MappingStatus mappingStatus : object.getSources()) {
                Integer thisDepth;
                if (mappingStatus == null || (thisDepth = (Integer)this.visit(mappingStatus)) <= depth) continue;
                depth = thisDepth;
            }
            depth = depth + 1;
            object.setDepth(depth);
        }
        return depth;
    }

    @Override
    public @NonNull Integer visitMappingStatus(@NonNull MappingStatus object) {
        Integer depth = object.getDepth();
        if (depth == null) {
            depth = 0;
            for (ElementStatus inputStatus : object.getInputs()) {
                Integer thisDepth;
                if (inputStatus == null || (thisDepth = (Integer)this.visit(inputStatus)) <= depth) continue;
                depth = thisDepth;
            }
            depth = depth + 1;
            object.setDepth(depth);
        }
        return depth;
    }
}

