/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.e4.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBigDecimalDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBigIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultByteDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultCharacterDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDateDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultFloatDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultLongDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultShortDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.PercentageDisplayConverter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.style.DefaultDisplayModeOrdering;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IDisplayModeOrdering;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public final class NatTableCSSHelper {
    private static final IDisplayModeOrdering displayModeOrdering = new DefaultDisplayModeOrdering();

    private NatTableCSSHelper() {
    }

    public static boolean getBoolean(CSSValue value, boolean defaultValue) {
        String stringValue = value.getCssText().toLowerCase();
        Boolean result = defaultValue;
        if ("true".equals(stringValue)) {
            result = true;
        } else if ("false".equals(stringValue)) {
            result = false;
        }
        return result;
    }

    public static DisplayMode getDisplayMode(String pseudo) {
        if (pseudo != null) {
            if ("select".equals(pseudo)) {
                return DisplayMode.SELECT;
            }
            if ("edit".equals(pseudo)) {
                return DisplayMode.EDIT;
            }
            if ("hover".equals(pseudo)) {
                return DisplayMode.HOVER;
            }
            if ("select-hover".equals(pseudo)) {
                return DisplayMode.SELECT_HOVER;
            }
        }
        return DisplayMode.NORMAL;
    }

    public static CellEdgeEnum getCellEdgeEnum(String value) {
        if ("top".equalsIgnoreCase(value)) {
            return CellEdgeEnum.TOP;
        }
        if ("bottom".equalsIgnoreCase(value)) {
            return CellEdgeEnum.BOTTOM;
        }
        if ("right".equalsIgnoreCase(value)) {
            return CellEdgeEnum.RIGHT;
        }
        if ("left".equalsIgnoreCase(value)) {
            return CellEdgeEnum.LEFT;
        }
        if ("top-right".equalsIgnoreCase(value)) {
            return CellEdgeEnum.TOP_RIGHT;
        }
        if ("top-left".equalsIgnoreCase(value)) {
            return CellEdgeEnum.TOP_LEFT;
        }
        if ("bottom-right".equalsIgnoreCase(value)) {
            return CellEdgeEnum.BOTTOM_RIGHT;
        }
        if ("bottom-left".equalsIgnoreCase(value)) {
            return CellEdgeEnum.BOTTOM_LEFT;
        }
        return CellEdgeEnum.NONE;
    }

    public static IDisplayConverter getDisplayConverter(String value, boolean format, Integer minFractionDigits, Integer maxFractionDigits, String datePattern) {
        if ("boolean".equalsIgnoreCase(value)) {
            return new DefaultBooleanDisplayConverter();
        }
        if ("character".equalsIgnoreCase(value)) {
            return new DefaultCharacterDisplayConverter();
        }
        if ("date".equalsIgnoreCase(value)) {
            return new DefaultDateDisplayConverter(datePattern);
        }
        if ("default".equalsIgnoreCase(value)) {
            return new DefaultDisplayConverter();
        }
        if ("percentage".equalsIgnoreCase(value)) {
            return new PercentageDisplayConverter();
        }
        if ("byte".equalsIgnoreCase(value)) {
            return new DefaultByteDisplayConverter();
        }
        if ("short".equalsIgnoreCase(value)) {
            return new DefaultShortDisplayConverter(format);
        }
        if ("int".equalsIgnoreCase(value)) {
            return new DefaultIntegerDisplayConverter(format);
        }
        if ("long".equalsIgnoreCase(value)) {
            return new DefaultLongDisplayConverter(format);
        }
        if ("big-int".equalsIgnoreCase(value)) {
            return new DefaultBigIntegerDisplayConverter();
        }
        if ("float".equalsIgnoreCase(value)) {
            DefaultFloatDisplayConverter result = new DefaultFloatDisplayConverter(format);
            if (minFractionDigits != null) {
                result.getNumberFormat().setMinimumFractionDigits(minFractionDigits);
            }
            if (maxFractionDigits != null) {
                result.getNumberFormat().setMaximumFractionDigits(maxFractionDigits);
            }
            return result;
        }
        if ("double".equalsIgnoreCase(value)) {
            DefaultDoubleDisplayConverter result = new DefaultDoubleDisplayConverter(format);
            if (minFractionDigits != null) {
                result.getNumberFormat().setMinimumFractionDigits(minFractionDigits);
            }
            if (maxFractionDigits != null) {
                result.getNumberFormat().setMaximumFractionDigits(maxFractionDigits);
            }
            return result;
        }
        if ("big-decimal".equalsIgnoreCase(value)) {
            DefaultBigDecimalDisplayConverter result = new DefaultBigDecimalDisplayConverter();
            if (minFractionDigits != null) {
                result.getNumberFormat().setMinimumFractionDigits(minFractionDigits);
            }
            if (maxFractionDigits != null) {
                result.getNumberFormat().setMaximumFractionDigits(maxFractionDigits);
            }
            return result;
        }
        return new DefaultDateDisplayConverter();
    }

    public static String getDisplayConverterString(IDisplayConverter converter) {
        if (converter instanceof DefaultBooleanDisplayConverter) {
            return "boolean";
        }
        if (converter instanceof DefaultCharacterDisplayConverter) {
            return "character";
        }
        if (converter instanceof DefaultDateDisplayConverter) {
            return "date";
        }
        if (converter instanceof PercentageDisplayConverter) {
            return "percentage";
        }
        if (converter instanceof DefaultByteDisplayConverter) {
            return "byte";
        }
        if (converter instanceof DefaultShortDisplayConverter) {
            return "short";
        }
        if (converter instanceof DefaultIntegerDisplayConverter) {
            return "int";
        }
        if (converter instanceof DefaultLongDisplayConverter) {
            return "long";
        }
        if (converter instanceof DefaultBigIntegerDisplayConverter) {
            return "big-int";
        }
        if (converter instanceof DefaultFloatDisplayConverter) {
            return "float";
        }
        if (converter instanceof DefaultDoubleDisplayConverter) {
            return "double";
        }
        if (converter instanceof DefaultBigDecimalDisplayConverter) {
            return "big-decimal";
        }
        return "default";
    }

    public static boolean isConverterString(String value) {
        return "boolean".equalsIgnoreCase(value) || "character".equalsIgnoreCase(value) || "date".equalsIgnoreCase(value) || "default".equalsIgnoreCase(value) || "percentage".equalsIgnoreCase(value) || "byte".equalsIgnoreCase(value) || "short".equalsIgnoreCase(value) || "int".equalsIgnoreCase(value) || "long".equalsIgnoreCase(value) || "big-int".equalsIgnoreCase(value) || "float".equalsIgnoreCase(value) || "double".equalsIgnoreCase(value) || "big-decimal".equalsIgnoreCase(value);
    }

    public static <T> T getNatTableStyle(NatTable natTable, ConfigAttribute<T> styleConfig, DisplayMode displayMode, String ... configLabels) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        CellStyleProxy style = new CellStyleProxy(configRegistry, displayMode, Arrays.asList(configLabels));
        return (T)style.getAttributeValue(styleConfig, CellStyleAttributes.FONT.equals(styleConfig));
    }

    public static <T> void applyNatTableStyle(NatTable natTable, ConfigAttribute<T> styleConfig, T value, DisplayMode displayMode, String configLabel) {
        NatTableCSSHelper.applyNatTableStyle(natTable, (ConfigAttribute<IStyle>)CellConfigAttributes.CELL_STYLE, styleConfig, value, displayMode, configLabel);
    }

    public static <T> void applyNatTableStyle(NatTable natTable, ConfigAttribute<IStyle> styleAttribute, ConfigAttribute<T> styleConfig, T value, DisplayMode displayMode, String configLabel) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        IStyle style = (IStyle)configRegistry.getSpecificConfigAttribute(styleAttribute, displayMode, configLabel);
        if (style == null) {
            style = new Style();
            if (configLabel != null) {
                configRegistry.registerConfigAttribute(styleAttribute, (Object)style, displayMode, configLabel);
            } else {
                configRegistry.registerConfigAttribute(styleAttribute, (Object)style, displayMode);
            }
        }
        style.setAttributeValue(styleConfig, value);
    }

    public static CSS2FontProperties getFontProperties(CSSElementContext context, String contextKey, NatTable natTable, DisplayMode displayMode, String label) {
        CSS2FontProperties fontProperties = (CSS2FontProperties)NatTableCSSHelper.getContextValue(context, displayMode, contextKey);
        if (fontProperties == null) {
            Font font = (Font)NatTableCSSHelper.getNatTableStyle(natTable, CellStyleAttributes.FONT, displayMode, label);
            if (font == null) {
                font = GUIHelper.DEFAULT_FONT;
            }
            fontProperties = CSSSWTFontHelper.getCSS2FontProperties((Font)font);
            NatTableCSSHelper.storeContextValue(context, displayMode, contextKey, fontProperties);
        }
        return fontProperties;
    }

    public static void setFontProperties(CSSValueList valueList, CSS2FontProperties font) {
        int length = valueList.getLength();
        int i = 0;
        while (i < length) {
            String fontProperty;
            CSSValue value2 = valueList.item(i);
            if (value2.getCssValueType() == 1 && (fontProperty = CSS2FontHelper.getCSSFontPropertyName((CSSPrimitiveValue)((CSSPrimitiveValue)value2))) != null) {
                if ("font-family".equalsIgnoreCase(fontProperty)) {
                    font.setFamily((CSSPrimitiveValue)value2);
                } else if ("font-size".equalsIgnoreCase(fontProperty)) {
                    font.setSize((CSSPrimitiveValue)value2);
                } else if ("font-style".equalsIgnoreCase(fontProperty)) {
                    font.setStyle((CSSPrimitiveValue)value2);
                } else if ("font-weight".equalsIgnoreCase(fontProperty)) {
                    font.setWeight((CSSPrimitiveValue)value2);
                }
            }
            ++i;
        }
    }

    public static BorderStyle getBorderStyle(CSSElementContext context, DisplayMode displayMode) {
        BorderStyle borderStyle = (BorderStyle)NatTableCSSHelper.getContextValue(context, displayMode, "border-config");
        if (borderStyle == null) {
            borderStyle = new BorderStyle();
            NatTableCSSHelper.storeContextValue(context, displayMode, "border-config", borderStyle);
        }
        return borderStyle;
    }

    public static void storeBorderStyle(CSSValueList valueList, BorderStyle borderStyle, CSSEngine engine, Display display) throws Exception {
        int length = valueList.getLength();
        int i = 0;
        while (i < length) {
            CSSValue value2 = valueList.item(i);
            if (value2.getCssValueType() == 1) {
                CSSPrimitiveValue primitiveValue = (CSSPrimitiveValue)value2;
                short type = primitiveValue.getPrimitiveType();
                switch (type) {
                    case 21: {
                        if (CSS2ColorHelper.isColorName((String)primitiveValue.getStringValue())) {
                            borderStyle.setColor((Color)engine.convert(value2, Color.class, (Object)display));
                            break;
                        }
                        if (NatTableCSSHelper.isLineStyle(primitiveValue.getStringValue().toUpperCase())) {
                            borderStyle.setLineStyle(BorderStyle.LineStyleEnum.valueOf((String)primitiveValue.getStringValue().toUpperCase()));
                            break;
                        }
                        borderStyle.setBorderMode(BorderStyle.BorderModeEnum.valueOf((String)primitiveValue.getStringValue().toUpperCase()));
                        break;
                    }
                    case 25: {
                        borderStyle.setColor((Color)engine.convert(value2, Color.class, (Object)display));
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 9: {
                        borderStyle.setThickness((int)((CSSPrimitiveValue)value2).getFloatValue((short)9));
                    }
                }
            }
            ++i;
        }
    }

    private static boolean isLineStyle(String style) {
        try {
            BorderStyle.LineStyleEnum.valueOf((String)style);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static void storePadding(String paddingKey, CSSValue value, CSSElementContext context, DisplayMode displayMode) {
        CSSPrimitiveValue primitiveValue;
        short type;
        if (value.getCssValueType() == 1 && ((type = (primitiveValue = (CSSPrimitiveValue)value).getPrimitiveType()) == 9 || type == 1 || type == 5)) {
            int padding = (int)primitiveValue.getFloatValue((short)9);
            NatTableCSSHelper.getPainterProperties(context, displayMode).put(paddingKey, padding);
        }
    }

    public static boolean resolvePainter(CSSElementContext context, CSSElementContext natTableContext, DisplayMode displayMode) {
        Object cv = NatTableCSSHelper.getContextValueInherited(context, natTableContext, displayMode, "painter-resolution");
        return cv != null ? (Boolean)cv : Boolean.TRUE;
    }

    public static List<String> getDecoratorPainter(CSSElementContext context, DisplayMode displayMode) {
        ArrayList decorator = (ArrayList)NatTableCSSHelper.getContextValue(context, displayMode, "decorator-painter");
        if (decorator == null) {
            decorator = new ArrayList();
            NatTableCSSHelper.storeContextValue(context, displayMode, "decorator-painter", decorator);
        }
        return decorator;
    }

    public static Map<String, Object> getPainterProperties(CSSElementContext context, DisplayMode displayMode) {
        HashMap painterProperties = (HashMap)NatTableCSSHelper.getContextValue(context, displayMode, "content-painter-config");
        if (painterProperties == null) {
            painterProperties = new HashMap();
            NatTableCSSHelper.storeContextValue(context, displayMode, "content-painter-config", painterProperties);
        }
        return painterProperties;
    }

    public static Map<String, Object> getPainterPropertiesInherited(CSSElementContext context, CSSElementContext natTableContext, DisplayMode targetDisplayMode) {
        int i;
        HashMap<String, Object> painterProperties = new HashMap<String, Object>();
        List displayModes = displayModeOrdering.getDisplayModeOrdering(targetDisplayMode);
        DisplayMode displayMode = null;
        if (natTableContext != null) {
            i = displayModes.size() - 1;
            while (i >= 0) {
                displayMode = (DisplayMode)displayModes.get(i);
                painterProperties.putAll(NatTableCSSHelper.getPainterProperties(natTableContext, displayMode));
                --i;
            }
        }
        i = displayModes.size() - 1;
        while (i >= 0) {
            displayMode = (DisplayMode)displayModes.get(i);
            painterProperties.putAll(NatTableCSSHelper.getPainterProperties(context, displayMode));
            --i;
        }
        return painterProperties;
    }

    public static List<String> resolvePainterRepresentation(CSSValue value) {
        ArrayList<String> painterValues = new ArrayList<String>();
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            int i = 0;
            while (i < length) {
                CSSValue value2 = valueList.item(i);
                if (value2.getCssValueType() == 1) {
                    painterValues.add(value2.getCssText().toLowerCase());
                }
                ++i;
            }
        } else if (value.getCssValueType() == 1) {
            painterValues.add(value.getCssText().toLowerCase());
        }
        return painterValues;
    }

    public static void storeContextValue(CSSElementContext context, DisplayMode displayMode, Object key, Object value) {
        HashMap subContext = context.getData((Object)displayMode);
        if (subContext == null) {
            subContext = new HashMap();
            context.setData((Object)displayMode, subContext);
        }
        Map displayModeContext = subContext;
        displayModeContext.put(key, value);
    }

    public static Object getContextValue(CSSElementContext context, DisplayMode displayMode, Object key) {
        Object subContext = context.getData((Object)displayMode);
        if (subContext != null) {
            Map displayModeContext = (Map)subContext;
            return displayModeContext.get(key);
        }
        return context.getData(key);
    }

    public static Object getContextValueInherited(CSSElementContext context, CSSElementContext natTableContext, DisplayMode targetDisplayMode, Object key) {
        Object cv = null;
        for (DisplayMode displayMode : displayModeOrdering.getDisplayModeOrdering(targetDisplayMode)) {
            cv = NatTableCSSHelper.getContextValue(context, displayMode, key);
            if (cv != null) break;
        }
        if (cv == null && natTableContext != null) {
            cv = NatTableCSSHelper.getContextValueInherited(natTableContext, null, targetDisplayMode, key);
        }
        return cv;
    }
}

