/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import java.util.ArrayList;
import java.util.Collection;

public class FilterRowComboUpdateEvent {
    private ArrayList<UpdateContent> updates = new ArrayList();

    public FilterRowComboUpdateEvent(int columnIndex, Collection<?> addedItems, Collection<?> removedItems) {
        this.updates.add(new UpdateContent(columnIndex, addedItems, removedItems));
    }

    public void addUpdate(int columnIndex, Collection<?> addedItems, Collection<?> removedItems) {
        this.updates.add(new UpdateContent(columnIndex, addedItems, removedItems));
    }

    public int getColumnIndex() {
        return this.updates.get(0).columnIndex;
    }

    public Collection<?> getAddedItems() {
        return this.updates.get(0).addedItems;
    }

    public Collection<?> getRemovedItems() {
        return this.updates.get(0).removedItems;
    }

    public int getColumnIndex(int update) {
        return this.updates.get(update).columnIndex;
    }

    public Collection<?> getAddedItems(int update) {
        return this.updates.get(update).addedItems;
    }

    public Collection<?> getRemovedItems(int update) {
        return this.updates.get(update).removedItems;
    }

    public int updateContentSize() {
        return this.updates.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FilterRowComboUpdateEvent [").append(System.lineSeparator());
        for (UpdateContent content : this.updates) {
            builder.append("\tcolumnIndex=").append(content.columnIndex).append(", addedItems=").append(content.addedItems).append(", removedItems=").append(content.removedItems).append(System.lineSeparator());
        }
        builder.append("]");
        return builder.toString();
    }

    class UpdateContent {
        private final int columnIndex;
        private final Collection<?> addedItems;
        private final Collection<?> removedItems;

        UpdateContent(int columnIndex, Collection<?> addedItems, Collection<?> removedItems) {
            this.columnIndex = columnIndex;
            this.addedItems = addedItems;
            this.removedItems = removedItems;
        }
    }
}

