/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleLoader;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisions;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.framework.util.ThreadInfoReport;
import org.eclipse.osgi.internal.container.EquinoxReentrantLock;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.service.resolver.ResolutionException;

public abstract class Module
implements BundleReference,
BundleStartLevel,
Comparable<Module> {
    public static final EnumSet<State> ACTIVE_SET = EnumSet.of(State.STARTING, State.LAZY_STARTING, State.ACTIVE, State.STOPPING);
    public static final EnumSet<State> RESOLVED_SET = EnumSet.of(State.RESOLVED, State.STARTING, State.LAZY_STARTING, State.ACTIVE, State.STOPPING);
    private final Long id;
    private final String location;
    private final ModuleRevisions revisions;
    final EquinoxReentrantLock stateChangeLock = new EquinoxReentrantLock();
    private final EnumSet<ModuleContainerAdaptor.ModuleEvent> stateTransitionEvents = EnumSet.noneOf(ModuleContainerAdaptor.ModuleEvent.class);
    private final EnumSet<Settings> settings;
    final AtomicInteger inStart = new AtomicInteger(0);
    private volatile State state = State.INSTALLED;
    private volatile int startlevel;
    private volatile long lastModified;
    private static final EnumSet<ModuleContainerAdaptor.ModuleEvent> VALID_RESOLVED_TRANSITION = EnumSet.of(ModuleContainerAdaptor.ModuleEvent.STARTED);
    private static final EnumSet<ModuleContainerAdaptor.ModuleEvent> VALID_STOPPED_TRANSITION = EnumSet.of(ModuleContainerAdaptor.ModuleEvent.UPDATED, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$osgi$container$ModuleContainerAdaptor$ModuleEvent;

    public Module(Long id, String location, ModuleContainer container, EnumSet<Settings> settings, int startlevel) {
        this.id = id;
        this.location = location;
        this.revisions = new ModuleRevisions(this, container);
        this.settings = settings == null ? EnumSet.noneOf(Settings.class) : EnumSet.copyOf(settings);
        this.startlevel = startlevel;
    }

    public final Long getId() {
        return this.id;
    }

    public final String getLocation() {
        return this.location;
    }

    public final ModuleRevisions getRevisions() {
        return this.revisions;
    }

    public final ModuleContainer getContainer() {
        return this.revisions.getContainer();
    }

    public final ModuleRevision getCurrentRevision() {
        return this.revisions.getCurrentRevision();
    }

    public final State getState() {
        return this.state;
    }

    final void setState(State state) {
        this.state = state;
    }

    @Override
    public final int getStartLevel() {
        this.checkValid();
        return this.startlevel;
    }

    @Override
    public final void setStartLevel(int startLevel) {
        this.revisions.getContainer().setStartLevel(this, startLevel);
    }

    @Override
    public final boolean isPersistentlyStarted() {
        this.checkValid();
        return this.settings.contains((Object)Settings.AUTO_START);
    }

    @Override
    public final boolean isActivationPolicyUsed() {
        this.checkValid();
        return this.settings.contains((Object)Settings.USE_ACTIVATION_POLICY);
    }

    final void storeStartLevel(int newStartLevel) {
        this.startlevel = newStartLevel;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    final void setlastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected final void lockStateChange(ModuleContainerAdaptor.ModuleEvent transitionEvent) throws BundleException {
        previousInterruption = Thread.interrupted();
        invalid = false;
        try {
            block12: {
                block13: {
                    acquired = this.stateChangeLock.tryLock(this.revisions.getContainer().getModuleLockTimeout(), TimeUnit.SECONDS);
                    currentTransition = Collections.emptySet();
                    if (!acquired) break block12;
                    isValidTransition = true;
                    switch (Module.$SWITCH_TABLE$org$eclipse$osgi$container$ModuleContainerAdaptor$ModuleEvent()[transitionEvent.ordinal()]) {
                        case 4: 
                        case 8: 
                        case 9: 
                        case 10: {
                            isValidTransition = this.stateTransitionEvents.isEmpty();
                            break;
                        }
                        case 3: {
                            isValidTransition = Module.VALID_RESOLVED_TRANSITION.containsAll(this.stateTransitionEvents);
                            break;
                        }
                        case 6: {
                            isValidTransition = Module.VALID_STOPPED_TRANSITION.containsAll(this.stateTransitionEvents);
                            break;
                        }
                        default: {
                            isValidTransition = false;
                        }
                    }
                    if (isValidTransition) break block13;
                    currentTransition = EnumSet.copyOf(this.stateTransitionEvents);
                    invalid = true;
                    this.stateChangeLock.unlock();
                    ** GOTO lbl32
                }
                this.stateTransitionEvents.add(transitionEvent);
                return;
            }
            try {
                currentTransition = EnumSet.copyOf(this.stateTransitionEvents);
lbl32:
                // 2 sources

                cause /* !! */  = invalid != false ? new IllegalStateException(NLS.bind(Msg.Module_LockStateError, (Object)transitionEvent, currentTransition)) : new TimeoutException(NLS.bind(Msg.Module_LockTimeout, this.revisions.getContainer().getModuleLockTimeout())).initCause(new ThreadInfoReport(this.stateChangeLock.toString()));
                exceptonInfo = String.valueOf(this.toString()) + ' ' + (Object)transitionEvent + ' ' + currentTransition;
                throw new BundleException(String.valueOf(Msg.Module_LockError) + exceptonInfo, 7, cause /* !! */ );
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BundleException(String.valueOf(Msg.Module_LockError) + this.toString() + " " + (Object)transitionEvent, 7, e);
            }
        }
        finally {
            if (previousInterruption) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected final void unlockStateChange(ModuleContainerAdaptor.ModuleEvent transitionEvent) {
        if (this.stateChangeLock.getHoldCount() == 0 || !this.stateTransitionEvents.contains((Object)transitionEvent)) {
            throw new IllegalMonitorStateException("Current thread does not hold the state change lock for: " + (Object)((Object)transitionEvent));
        }
        this.stateTransitionEvents.remove((Object)transitionEvent);
        this.stateChangeLock.unlock();
    }

    public final boolean holdsTransitionEventLock(ModuleContainerAdaptor.ModuleEvent transitionEvent) {
        return this.stateChangeLock.getHoldCount() > 0 && this.stateTransitionEvents.contains((Object)transitionEvent);
    }

    public final Thread getStateChangeOwner() {
        return this.stateChangeLock.getOwner();
    }

    public void start(StartOptions ... options) throws BundleException {
        ModuleContainerAdaptor.ModuleEvent event;
        ModuleContainer container = this.getContainer();
        long startTime = 0L;
        if (container.DEBUG_BUNDLE_START_TIME) {
            startTime = System.nanoTime();
        }
        container.checkAdminPermission(this.getBundle(), "execute");
        if (options == null) {
            options = new StartOptions[]{};
        }
        if (StartOptions.LAZY_TRIGGER.isContained(options)) {
            this.setTrigger();
            if (this.stateChangeLock.getHoldCount() > 0 && this.stateTransitionEvents.contains((Object)ModuleContainerAdaptor.ModuleEvent.STARTED)) {
                return;
            }
        }
        BundleException startError = null;
        boolean lockedStarted = false;
        this.inStart.incrementAndGet();
        try {
            this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
            lockedStarted = true;
            this.checkValid();
            if (StartOptions.TRANSIENT_IF_AUTO_START.isContained(options) && !this.settings.contains((Object)Settings.AUTO_START)) {
                return;
            }
            this.checkFragment();
            this.persistStartOptions(options);
            if (this.getStartLevel() > container.getStartLevel()) {
                if (StartOptions.TRANSIENT.isContained(options)) {
                    throw new BundleException(Msg.Module_Transient_StartError, 10);
                }
                return;
            }
            if (State.ACTIVE.equals((Object)this.getState())) {
                return;
            }
            if (this.getState().equals((Object)State.INSTALLED)) {
                ResolutionReport report;
                this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
                lockedStarted = false;
                try {
                    report = container.resolve(Collections.singletonList(this), true);
                }
                finally {
                    this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
                    lockedStarted = true;
                }
                this.checkValid();
                ResolutionException e = report.getResolutionException();
                if (e != null && e.getCause() instanceof BundleException) {
                    throw (BundleException)e.getCause();
                }
                if (State.ACTIVE.equals((Object)this.getState())) {
                    return;
                }
                if (this.getState().equals((Object)State.INSTALLED)) {
                    String reportMessage = report.getResolutionReportMessage(this.getCurrentRevision());
                    throw new BundleException(String.valueOf(Msg.Module_ResolveError) + reportMessage, 4);
                }
            }
            try {
                event = this.doStart(options);
            }
            catch (BundleException e) {
                this.setState(State.RESOLVED);
                startError = e;
                event = ModuleContainerAdaptor.ModuleEvent.STOPPED;
            }
        }
        finally {
            if (lockedStarted) {
                this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
            }
            this.inStart.decrementAndGet();
        }
        if (event != null) {
            if (!EnumSet.of(ModuleContainerAdaptor.ModuleEvent.STARTED, ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION, ModuleContainerAdaptor.ModuleEvent.STOPPED).contains((Object)event)) {
                throw new IllegalStateException("Wrong event type: " + (Object)((Object)event));
            }
            this.publishEvent(event);
            if (container.DEBUG_BUNDLE_START_TIME) {
                Debug.println(String.valueOf(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)) + " ms for total start time event " + (Object)((Object)event) + " - " + this);
            }
        }
        if (startError != null) {
            throw startError;
        }
    }

    final void publishEvent(ModuleContainerAdaptor.ModuleEvent type) {
        this.revisions.getContainer().getAdaptor().publishModuleEvent(type, this, this);
    }

    public void stop(StopOptions ... options) throws BundleException {
        ModuleContainerAdaptor.ModuleEvent event;
        this.revisions.getContainer().checkAdminPermission(this.getBundle(), "execute");
        if (options == null) {
            options = new StopOptions[]{};
        }
        BundleException stopError = null;
        this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STOPPED);
        try {
            this.checkValid();
            this.checkFragment();
            this.persistStopOptions(options);
            if (!ACTIVE_SET.contains((Object)this.getState())) {
                return;
            }
            try {
                event = this.doStop();
            }
            catch (BundleException e) {
                stopError = e;
                event = ModuleContainerAdaptor.ModuleEvent.STOPPED;
            }
        }
        finally {
            this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STOPPED);
        }
        if (event != null) {
            if (!ModuleContainerAdaptor.ModuleEvent.STOPPED.equals((Object)event)) {
                throw new IllegalStateException("Wrong event type: " + (Object)((Object)event));
            }
            this.publishEvent(event);
        }
        if (stopError != null) {
            throw stopError;
        }
    }

    private void checkFragment() throws BundleException {
        ModuleRevision current = this.getCurrentRevision();
        if ((current.getTypes() & 1) != 0) {
            throw new BundleException(Msg.Module_Fragment_InvalidOperation, 2);
        }
    }

    @Override
    public final int compareTo(Module o) {
        int slcomp = this.startlevel - o.startlevel;
        if (slcomp != 0) {
            return slcomp;
        }
        long idcomp = this.getId() - o.getId();
        return idcomp < 0L ? -1 : (idcomp > 0L ? 1 : 0);
    }

    final void checkValid() {
        if (this.getState().equals((Object)State.UNINSTALLED)) {
            throw new IllegalStateException(Msg.Module_UninstalledError);
        }
    }

    private ModuleContainerAdaptor.ModuleEvent doStart(StartOptions ... options) throws BundleException {
        boolean isLazyTrigger = StartOptions.LAZY_TRIGGER.isContained(options);
        if (isLazyTrigger) {
            if (!State.LAZY_STARTING.equals((Object)this.getState())) {
                this.setState(State.LAZY_STARTING);
                this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
                try {
                    this.publishEvent(ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION);
                }
                finally {
                    this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
                }
                if (State.ACTIVE.equals((Object)this.getState())) {
                    return null;
                }
            }
            if (this.getContainer().DEBUG_MONITOR_LAZY) {
                Debug.printStackTrace(new Exception("Module is being lazy activated: " + this));
            }
        } else if (this.isLazyActivate(options) && !this.isTriggerSet()) {
            if (State.LAZY_STARTING.equals((Object)this.getState())) {
                return null;
            }
            this.setState(State.LAZY_STARTING);
            return ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION;
        }
        if (!State.STARTING.equals((Object)this.getState())) {
            this.setState(State.STARTING);
            this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STARTING);
        }
        try {
            this.startWorker();
            this.setState(State.ACTIVE);
            return ModuleContainerAdaptor.ModuleEvent.STARTED;
        }
        catch (Throwable t) {
            this.setState(State.STOPPING);
            this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STOPPING);
            if (t instanceof BundleException) {
                throw (BundleException)t;
            }
            throw new BundleException(Msg.Module_StartError, 5, t);
        }
    }

    private void setTrigger() {
        ModuleLoader loader = this.getCurrentLoader();
        if (loader != null) {
            loader.getAndSetTrigger();
        }
    }

    private boolean isTriggerSet() {
        ModuleLoader loader = this.getCurrentLoader();
        return loader == null ? false : loader.isTriggerSet();
    }

    private ModuleLoader getCurrentLoader() {
        ModuleRevision current = this.getCurrentRevision();
        if (current == null) {
            return null;
        }
        ModuleWiring wiring = current.getWiring();
        if (wiring == null) {
            return null;
        }
        try {
            return wiring.getModuleLoader();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    protected void startWorker() throws BundleException {
    }

    private ModuleContainerAdaptor.ModuleEvent doStop() throws BundleException {
        this.setState(State.STOPPING);
        this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STOPPING);
        try {
            this.stopWorker();
            ModuleContainerAdaptor.ModuleEvent moduleEvent = ModuleContainerAdaptor.ModuleEvent.STOPPED;
            return moduleEvent;
        }
        catch (Throwable t) {
            if (t instanceof BundleException) {
                throw (BundleException)t;
            }
            throw new BundleException(Msg.Module_StopError, 5, t);
        }
        finally {
            this.setState(State.RESOLVED);
        }
    }

    protected void stopWorker() throws BundleException {
    }

    public String toString() {
        return this.getCurrentRevision() + " [id=" + this.id + "]";
    }

    private void persistStartOptions(StartOptions ... options) {
        if (StartOptions.TRANSIENT.isContained(options) || StartOptions.TRANSIENT_RESUME.isContained(options) || StartOptions.LAZY_TRIGGER.isContained(options)) {
            return;
        }
        if (StartOptions.USE_ACTIVATION_POLICY.isContained(options)) {
            this.settings.add(Settings.USE_ACTIVATION_POLICY);
        } else {
            this.settings.remove((Object)Settings.USE_ACTIVATION_POLICY);
        }
        this.settings.add(Settings.AUTO_START);
        this.revisions.getContainer().moduleDatabase.persistSettings(this.settings, this);
    }

    private void persistStopOptions(StopOptions ... options) {
        if (StopOptions.TRANSIENT.isContained(options)) {
            return;
        }
        this.settings.remove((Object)Settings.USE_ACTIVATION_POLICY);
        this.settings.remove((Object)Settings.AUTO_START);
        this.revisions.getContainer().moduleDatabase.persistSettings(this.settings, this);
    }

    public void setParallelActivation(boolean parallelActivation) {
        if (parallelActivation) {
            this.settings.add(Settings.PARALLEL_ACTIVATION);
        } else {
            this.settings.remove((Object)Settings.PARALLEL_ACTIVATION);
        }
        this.revisions.getContainer().moduleDatabase.persistSettings(this.settings, this);
    }

    public boolean isParallelActivated() {
        return this.settings.contains((Object)Settings.PARALLEL_ACTIVATION);
    }

    protected abstract void cleanup(ModuleRevision var1);

    final boolean isLazyActivate(StartOptions ... options) {
        if (StartOptions.TRANSIENT.isContained(options) ? !StartOptions.USE_ACTIVATION_POLICY.isContained(options) : !this.settings.contains((Object)Settings.USE_ACTIVATION_POLICY)) {
            return false;
        }
        return this.hasLazyActivatePolicy();
    }

    final boolean hasLazyActivatePolicy() {
        ModuleRevision current = this.getCurrentRevision();
        return current == null ? false : current.hasLazyActivatePolicy();
    }

    final boolean inStart() {
        return this.inStart.get() > 0;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$osgi$container$ModuleContainerAdaptor$ModuleEvent() {
        if ($SWITCH_TABLE$org$eclipse$osgi$container$ModuleContainerAdaptor$ModuleEvent != null) {
            return $SWITCH_TABLE$org$eclipse$osgi$container$ModuleContainerAdaptor$ModuleEvent;
        }
        int[] nArray = new int[ModuleContainerAdaptor.ModuleEvent.values().length];
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.INSTALLED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.RESOLVED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.STARTED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.STARTING.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.STOPPED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.STOPPING.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.UNINSTALLED.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.UNRESOLVED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModuleContainerAdaptor.ModuleEvent.UPDATED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$osgi$container$ModuleContainerAdaptor$ModuleEvent = nArray;
        return nArray;
    }

    public static enum Settings {
        AUTO_START,
        USE_ACTIVATION_POLICY,
        PARALLEL_ACTIVATION;

    }

    public static enum StartOptions {
        TRANSIENT,
        USE_ACTIVATION_POLICY,
        TRANSIENT_RESUME,
        TRANSIENT_IF_AUTO_START,
        LAZY_TRIGGER;


        public boolean isContained(StartOptions ... options) {
            StartOptions[] startOptionsArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                StartOptions option = startOptionsArray[n2];
                if (this.equals((Object)option)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static enum State {
        INSTALLED,
        RESOLVED,
        LAZY_STARTING,
        STARTING,
        ACTIVE,
        STOPPING,
        UNINSTALLED;

    }

    public static enum StopOptions {
        TRANSIENT;


        public boolean isContained(StopOptions ... options) {
            StopOptions[] stopOptionsArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                StopOptions option = stopOptionsArray[n2];
                if (this.equals((Object)option)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

