/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.json.AcquiredExaminationCertificate;
import org.eclipse.passage.lic.internal.json.Json;

public final class CertificateDeserializer
extends StdDeserializer<ExaminationCertificate> {
    private static final long serialVersionUID = 4764283882751022188L;

    CertificateDeserializer(Class<ExaminationCertificate> vc) {
        super(vc);
    }

    public ExaminationCertificate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode root = (JsonNode)p.getCodec().readTree(p);
        ArrayNode permissions = (ArrayNode)root.get("permissions");
        ArrayNode restrictions = (ArrayNode)root.get("restrictions");
        ArrayNode requirements = (ArrayNode)root.get("requirements");
        return new AcquiredExaminationCertificate(this.satisfied(this.collection(requirements, new Json.LicensingRequirement()), this.collection(permissions, new Json.LicensingPermission())), this.collection(restrictions, new Json.LicensingRestriction()), new Json.Date().apply(root.get("stamp")));
    }

    private <T, U extends Json<T>> List<T> collection(ArrayNode serialized, U deserializer) {
        return StreamSupport.stream(serialized.spliterator(), false).map(deserializer).collect(Collectors.toList());
    }

    private Map<Requirement, Permission> satisfied(List<Requirement> keys, List<Permission> values) {
        return IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(keys::get, values::get));
    }
}

