/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.bc;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import java.util.function.Supplier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.DigestExpectation;
import org.eclipse.passage.lic.internal.api.io.EncryptionAlgorithm;
import org.eclipse.passage.lic.internal.api.io.EncryptionKeySize;
import org.eclipse.passage.lic.internal.api.io.StreamCodec;
import org.eclipse.passage.lic.internal.bc.BcDecodedStream;
import org.eclipse.passage.lic.internal.bc.BcEncodedStream;
import org.eclipse.passage.lic.internal.bc.BcKeyPair;
import org.eclipse.passage.lic.internal.bc.BcResidentSecretKey;

public final class BcStreamCodec
implements StreamCodec {
    private final Supplier<LicensedProduct> product;
    private final EncryptionAlgorithm algorithm;
    private final EncryptionKeySize keySize;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public BcStreamCodec(Supplier<LicensedProduct> product, EncryptionAlgorithm algorithm, EncryptionKeySize keySize) {
        this.product = product;
        this.algorithm = algorithm;
        this.keySize = keySize;
    }

    public BcStreamCodec(Supplier<LicensedProduct> product) {
        this(product, (EncryptionAlgorithm)new EncryptionAlgorithm.Default(), (EncryptionKeySize)new EncryptionKeySize.Default());
    }

    public LicensedProduct id() {
        return this.product.get();
    }

    public EncryptionAlgorithm algorithm() {
        return this.algorithm;
    }

    public EncryptionKeySize keySize() {
        return this.keySize;
    }

    public void createKeyPair(Path publicKey, Path privateKey, String username, String password) throws LicensingException {
        Objects.requireNonNull(publicKey, "BcStreamCodec::createKeyPair::publicKey");
        Objects.requireNonNull(privateKey, "BcStreamCodec::createKeyPair::privateKey");
        Objects.requireNonNull(username, "BcStreamCodec::createKeyPair::username");
        Objects.requireNonNull(password, "BcStreamCodec::createKeyPair::password");
        new BcKeyPair(new BcKeyPair.Targets(publicKey, privateKey), new BcKeyPair.EncryptionParameters(this.algorithm, this.keySize)).generate(username, password);
    }

    public void encode(InputStream input, OutputStream output, InputStream key, String username, String password) throws LicensingException {
        Objects.requireNonNull(input, "BcStreamCodec::encode::input");
        Objects.requireNonNull(output, "BcStreamCodec::encode::output");
        Objects.requireNonNull(key, "BcStreamCodec::encode::key");
        Objects.requireNonNull(username, "BcStreamCodec::encode::username");
        Objects.requireNonNull(password, "BcStreamCodec::encode::password");
        new BcEncodedStream(this.product.get(), input, output).produce(new BcResidentSecretKey(key, username).get(), password);
    }

    public void decode(InputStream input, OutputStream output, InputStream key, DigestExpectation digest) throws LicensingException {
        Objects.requireNonNull(input, "BcStreamCodec::decode::input");
        Objects.requireNonNull(output, "BcStreamCodec::decode::output");
        Objects.requireNonNull(key, "BcStreamCodec::decode::key");
        Objects.requireNonNull(digest, "BcStreamCodec::decode::digest");
        new BcDecodedStream(this.product.get(), input, output).produce(key, digest);
    }
}

