/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.rcptt.tesla.internal.ui.player.IScreenCapturer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SWTScreenCapturer
implements IScreenCapturer {
    private Image getImage(Control control) {
        Display display = control.getDisplay();
        Shell shell = control.getShell();
        GC gc = new GC((Drawable)shell);
        try {
            Rectangle bounds = shell.getBounds();
            Image image = new Image((Device)display, bounds.width, bounds.height);
            shell.print(gc);
            if (shell != control) {
                gc.setForeground(display.getSystemColor(3));
                Rectangle arect = display.map((Control)control.getParent(), (Control)shell, control.getBounds());
                gc.drawRectangle(arect.x, arect.y, arect.width, arect.height);
            }
            gc.copyArea(image, 0, 0);
            Image image2 = image;
            return image2;
        }
        finally {
            gc.dispose();
        }
    }

    public byte[] makeScreenShotData(Control control, boolean scale_640_480) {
        Image image = this.getImage(control);
        if (scale_640_480) {
            int width = image.getBounds().width;
            int height = image.getBounds().height;
            double ra = Math.max((double)width / 640.0, (double)height / 480.0);
            int rx = (int)((double)width / ra);
            int ry = (int)((double)height / ra);
            Image newImage = new Image((Device)control.getDisplay(), rx, ry);
            try {
                GC gc = new GC((Drawable)newImage);
                try {
                    gc.setAntialias(1);
                    gc.setInterpolation(2);
                    gc.drawImage(image, 0, 0, width, height, 0, 0, rx, ry);
                }
                finally {
                    gc.dispose();
                }
            }
            finally {
                image.dispose();
            }
            image = newImage;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageLoader imageLoader = new ImageLoader();
        try {
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save((OutputStream)bout, 5);
        }
        finally {
            image.dispose();
        }
        return bout.toByteArray();
    }
}

