/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class OptionalImportPackageResolution
extends AbstractManifestMarkerResolution {
    public OptionalImportPackageResolution(int type, String packageName, IMarker marker) {
        super(type, marker);
    }

    @Override
    protected void createChange(BundleModel model) {
        ImportPackageObject pkg;
        String packageName = this.marker.getAttribute("packageName", null);
        Bundle bundle = (Bundle)model.getBundle();
        ImportPackageHeader header = (ImportPackageHeader)bundle.getManifestHeader("Import-Package");
        if (header != null && (pkg = header.getPackage(packageName)) != null) {
            pkg.setOptional(true);
        }
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)PDEUIMessages.OptionalImportPkgResolution_description, (Object)this.marker.getAttribute("packageName", null));
    }

    public String getLabel() {
        return NLS.bind((String)PDEUIMessages.OptionalImportPkgResolution_label, (Object)this.marker.getAttribute("packageName", null));
    }
}

