/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.product.AbstractProductContentSection;
import org.eclipse.pde.internal.ui.editor.product.FeatureSection;
import org.eclipse.pde.internal.ui.editor.product.PluginSection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MixedSection
extends AbstractProductContentSection<MixedSection> {
    private static final List<String> BUTTON_LABELS;
    private static final List<Consumer<MixedSection>> BUTTON_HANDLERS;
    private static final int BTN_ADD_PLUGIN;
    private static final int BTN_ADD_FEATURE;
    private static final int BTN_REMOVE;
    private static final int BTN_REMOVE_ALL;
    private static final int BTN_PROPS;
    private static final int BTN_ROOT;
    private static final int BTN_UP;
    private static final int BTN_DWN;

    static {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList handlers = new ArrayList();
        BTN_ADD_PLUGIN = MixedSection.addButton(PDEUIMessages.Product_MixedSection_AddPlugins, PluginSection::handleAdd, labels, handlers);
        BTN_ADD_FEATURE = MixedSection.addButton(PDEUIMessages.Product_MixedSection_AddFeatures, FeatureSection::handleAdd, labels, handlers);
        BTN_REMOVE = MixedSection.addButton(PDEUIMessages.PluginSection_remove, AbstractProductContentSection::handleRemove, labels, handlers);
        BTN_REMOVE_ALL = MixedSection.addButton(PDEUIMessages.Product_PluginSection_removeAll, MixedSection::handleRemoveAll, labels, handlers);
        BTN_PROPS = MixedSection.addButton(PDEUIMessages.Product_FeatureSection_properties, MixedSection::handleProperties, labels, handlers);
        BTN_ROOT = MixedSection.addButton(PDEUIMessages.FeatureSection_toggleRoot, FeatureSection::handleRootToggle, labels, handlers);
        BTN_UP = MixedSection.addButton(PDEUIMessages.Product_FeatureSection_up, MixedSection::handleUp, labels, handlers);
        BTN_DWN = MixedSection.addButton(PDEUIMessages.Product_FeatureSection_down, MixedSection::handleDown, labels, handlers);
        BUTTON_LABELS = List.copyOf(labels);
        BUTTON_HANDLERS = List.copyOf(handlers);
    }

    public MixedSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, BUTTON_LABELS, BUTTON_HANDLERS, e -> e instanceof IProductFeature || e instanceof IProductPlugin);
    }

    @Override
    void populateSection(Section section, Composite container, FormToolkit toolkit) {
        this.createAutoIncludeRequirementsButton(container, PDEUIMessages.Product_FeatureSection_autoIncludeRequirements);
        this.configureTable(p -> Stream.of(p.getFeatures(), p.getPlugins()).flatMap(Arrays::stream).toArray(Object[]::new), new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IProductFeature) {
                    return 1;
                }
                if (element instanceof IProductPlugin) {
                    return 2;
                }
                throw new IllegalArgumentException();
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                return e1 instanceof IProductFeature && e2 instanceof IProductFeature ? 0 : super.compare(viewer, e1, e2);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTableViewer(), (int)2);
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){
            PDELabelProvider pdeLabelProvider = PDEPlugin.getDefault().getLabelProvider();

            public String getText(Object e) {
                return this.pdeLabelProvider.getText(e);
            }

            public Image getImage(Object e) {
                return this.pdeLabelProvider.getImage(e);
            }

            public String getToolTipText(Object element) {
                if (element instanceof IProductPlugin) {
                    IProductPlugin plugin = (IProductPlugin)element;
                    return NLS.bind((String)PDEUIMessages.Product_MixedSection_Tooltip_Plugins, (Object)plugin.getId());
                }
                if (element instanceof IProductFeature) {
                    IProductFeature feature = (IProductFeature)element;
                    return NLS.bind((String)PDEUIMessages.Product_MixedSection_Tooltip_Features, (Object)feature.getId());
                }
                return null;
            }
        });
        this.enableTableButtons(BTN_ADD_PLUGIN, BTN_ADD_FEATURE, BTN_PROPS, BTN_ROOT, BTN_UP, BTN_DWN);
        section.setText(PDEUIMessages.Product_MixedSection_title);
        section.setDescription(PDEUIMessages.Product_MixedSection_desc);
    }

    @Override
    List<Action> getToolbarActions() {
        Action newPluginAction = MixedSection.createPushAction(PDEUIMessages.Product_PluginSection_newPlugin, PDEPluginImages.DESC_NEWPPRJ_TOOL, () -> PluginSection.handleNewPlugin(this));
        Action newFragmentAction = MixedSection.createPushAction(PDEUIMessages.Product_PluginSection_newFragment, PDEPluginImages.DESC_NEWFRAGPRJ_TOOL, () -> PluginSection.handleNewFragment(this));
        Action newFeatureAction = MixedSection.createPushAction(PDEUIMessages.Product_FeatureSection_newFeature, PDEPluginImages.DESC_NEWFTRPRJ_TOOL, () -> FeatureSection.handleNewFeature(this));
        return List.of(newPluginAction, newFragmentAction, newFeatureAction);
    }

    private void handleProperties() {
        FeatureSection.handleProperties(this);
        PluginSection.handleProperties(this);
    }

    @Override
    void removeElements(IProduct product, List<Object> elements) {
        IProductFeature[] features = MixedSection.filterToArray(elements.stream(), IProductFeature.class);
        IProductPlugin[] plugins = MixedSection.filterToArray(elements.stream(), IProductPlugin.class);
        product.removeFeatures(features);
        product.removePlugins(plugins);
    }

    @Override
    void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removeFeatures(product.getFeatures());
        product.removePlugins(product.getPlugins());
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IProduct product = this.getProduct();
        IProductFeature[] features = MixedSection.filterToArray(Stream.of(objects), IProductFeature.class);
        IProductPlugin[] plugins = MixedSection.filterToArray(Stream.of(objects), IProductPlugin.class);
        product.addFeatures(features);
        product.addPlugins(plugins);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    void updateButtons(boolean updateRemove, boolean updateRemoveAll) {
        this.updateRemoveButtons(updateRemove != false ? MixedSection.BTN_REMOVE : -1, updateRemoveAll != false ? MixedSection.BTN_REMOVE_ALL : -1);
        tablePart = this.getTablePart();
        table = tablePart.getTableViewer().getTable();
        selection = this.getTableSelection().toList();
        canMove = this.isEditable() != false && selection.size() == 1 && selection.get(0) instanceof IProductFeature != false && this.getProduct().getFeatures().length > 1;
        tablePart.setButtonEnabled(MixedSection.BTN_PROPS, this.isEditable() != false && selection.size() == 1 && selection.get(0) instanceof String == false);
        if (!this.isEditable() || selection.isEmpty()) ** GOTO lbl-1000
        if (selection.stream().allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(IProductFeature.class))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        tablePart.setButtonEnabled(MixedSection.BTN_ROOT, v0);
        tablePart.setButtonEnabled(MixedSection.BTN_UP, canMove != false && MixedSection.canMoveUp(table, table.getSelectionIndex()) != false);
        tablePart.setButtonEnabled(MixedSection.BTN_DWN, canMove != false && MixedSection.canMoveDown(table, table.getSelectionIndex()) != false);
    }

    private void handleUp() {
        int index;
        Table table = this.getTable();
        if (MixedSection.canMoveUp(table, index = table.getSelectionIndex())) {
            FeatureSection.swap(index, index - 1, table, this.getProduct());
        }
    }

    private static boolean canMoveUp(Table table, int index) {
        return index > 0 && table.getItem(index).getData() instanceof IProductFeature;
    }

    private void handleDown() {
        int index;
        Table table = this.getTable();
        if (MixedSection.canMoveDown(table, index = table.getSelectionIndex())) {
            FeatureSection.swap(index, index + 1, table, this.getProduct());
        }
    }

    private static boolean canMoveDown(Table table, int index) {
        return index + 1 < table.getItemCount() && table.getItem(index + 1).getData() instanceof IProductFeature;
    }
}

