/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import aQute.bnd.build.model.EE;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bndtools.templating.Resource;
import org.bndtools.templating.ResourceMap;
import org.bndtools.templating.Template;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.bnd.ui.wizards.ProjectTemplateParam;
import org.eclipse.pde.bnd.ui.wizards.TemplateParamsWizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;

public class TemplatePluginContentWizard
extends Wizard
implements IPluginContentWizard {
    private static final String DEFAULT_BND_INSTRUCTION = "bnd.bnd";
    private final Template template;
    private IFieldData data;
    private TemplateParamsWizardPage paramsWizardPage;

    public TemplatePluginContentWizard(Template template) {
        this.template = template;
    }

    @Override
    public void init(IFieldData data) {
        this.data = data;
    }

    @Override
    public IPluginReference[] getDependencies(String schemaVersion) {
        return new IPluginReference[0];
    }

    @Override
    public String[] getNewFiles() {
        return new String[0];
    }

    @Override
    public boolean performFinish(IProject project, IPluginModelBase model, IProgressMonitor monitor) {
        String ee;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
        params.put(ProjectTemplateParam.PROJECT_NAME.getString(), List.of(this.data.getName()));
        params.put(ProjectTemplateParam.BASE_PACKAGE_NAME.getString(), List.of(this.data.getId()));
        String packageDir = this.data.getId().replace('.', '/');
        params.put(ProjectTemplateParam.BASE_PACKAGE_DIR.getString(), List.of(packageDir));
        params.put(ProjectTemplateParam.VERSION.getString(), List.of(this.data.getVersion()));
        params.put(ProjectTemplateParam.SRC_DIR.getString(), List.of(this.data.getSourceFolderName()));
        params.put(ProjectTemplateParam.BIN_DIR.getString(), List.of(this.data.getOutputFolderName()));
        if (this.data instanceof AbstractFieldData && (ee = ((AbstractFieldData)this.data).getExecutionEnvironment()) != null) {
            EE parsedEE = EE.parse((String)ee);
            params.put(ProjectTemplateParam.JAVA_LEVEL.getString(), List.of(Integer.valueOf(parsedEE.getRelease())));
        }
        this.getTemplatePage().getValues().forEach((key, override) -> {
            List<String> list = params.put((String)key, (List<Object>)List.of(override));
        });
        try {
            ResourceMap resourceMap = this.template.generateOutputs(params, (IProgressMonitor)progress.split(50));
            progress.setWorkRemaining(resourceMap.size());
            for (Map.Entry outputEntry : resourceMap.entries()) {
                String path = (String)outputEntry.getKey();
                Resource resource = (Resource)outputEntry.getValue();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                switch (resource.getType()) {
                    case Folder: {
                        if (path.isEmpty()) break;
                        IFolder folder = project.getFolder(path);
                        TemplatePluginContentWizard.mkdirs((IContainer)folder, (IProgressMonitor)progress.split(1));
                        break;
                    }
                    case File: {
                        if (DEFAULT_BND_INSTRUCTION.equals(path)) {
                            TemplatePluginContentWizard.makeFile(project.getFile("pde.bnd"), resource, (IProgressMonitor)progress.split(1));
                            break;
                        }
                        TemplatePluginContentWizard.makeFile(project.getFile(path), resource, (IProgressMonitor)progress.split(1));
                    }
                }
            }
        }
        catch (Exception e) {
            ILog.get().error("Generating template failed!", (Throwable)e);
            return false;
        }
        return true;
    }

    private static void makeFile(IFile file, Resource resource, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        TemplatePluginContentWizard.mkdirs(file.getParent(), (IProgressMonitor)subMonitor.split(1));
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = resource.getContent();){
            if (file.exists()) {
                file.setContents(in, true, true, (IProgressMonitor)subMonitor.split(1));
            } else {
                file.create(in, true, (IProgressMonitor)subMonitor.split(1));
            }
            file.setCharset(resource.getTextEncoding(), null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void mkdirs(IContainer container, IProgressMonitor monitor) throws CoreException {
        if (container instanceof IFolder) {
            IFolder folder = (IFolder)container;
            TemplatePluginContentWizard.mkdirs(folder.getParent(), monitor);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
        }
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.getTemplatePage());
    }

    private TemplateParamsWizardPage getTemplatePage() {
        if (this.paramsWizardPage == null) {
            this.paramsWizardPage = new TemplateParamsWizardPage(ProjectTemplateParam.valueStrings());
            this.paramsWizardPage.setTemplate(this.template);
        }
        return this.paramsWizardPage;
    }
}

