/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.heapwalking;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.debug.ui.actions.OpenVariableConcreteTypeAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

abstract class BaseInstanceActionDelegate
extends ObjectActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow fWindow;

    BaseInstanceActionDelegate() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    protected void handleDoubleClick(IAction action, DoubleClickEvent event) {
        Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
        this.openInEditor(action, selection);
    }

    private void openInEditor(IAction action, Object selection) {
        if (selection instanceof JDIFieldVariable) {
            OpenVariableConcreteTypeAction openAction = new OpenVariableConcreteTypeAction();
            openAction.setActivePart(action, this.getPart());
            try {
                openAction.openElement(action, selection);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        } else if (selection instanceof IJavaVariable) {
            try {
                OpenVariableConcreteTypeAction openAction = new OpenVariableConcreteTypeAction();
                openAction.setActivePart(action, this.getPart());
                openAction.openElement(action, selection);
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
    }

    @Override
    protected IWorkbenchPart getPart() {
        IWorkbenchPart part = super.getPart();
        if (part != null) {
            return part;
        }
        if (this.fWindow != null) {
            return this.fWindow.getActivePage().getActivePart();
        }
        return null;
    }
}

