/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching.aut;

import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.ui.launching.aut.AUTComposite;
import org.eclipse.rcptt.ui.launching.aut.BasicAUTComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AUTSelectionDialog
extends Dialog
implements BasicAUTComposite.ILaunchListener {
    private static final String SETTINGS_KEY = "AUTSelectionDialog";
    private BasicAUTComposite autComposite;
    private AutLaunch result;

    public AUTSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AUTSelectionDialog_Title);
        newShell.setImage(Images.getImage("icons/q7.gif"));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection(SETTINGS_KEY);
        if (section == null) {
            section = root.addNewSection(SETTINGS_KEY);
        }
        return section;
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.autComposite = this.createAUTComposite();
        this.autComposite.create(composite, true);
        this.autComposite.addListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AUTSelectionDialog.this.updateEnablement(AUTSelectionDialog.this.autComposite.isSelectionOK());
            }
        });
        this.autComposite.setInitialSelection();
        this.autComposite.setLaunchListener(this);
        this.updateEnablement(this.autComposite.isSelectionOK());
        return composite;
    }

    protected BasicAUTComposite createAUTComposite() {
        return new AUTComposite();
    }

    protected void configure() {
        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)this.getShell(), (IStructuredSelection)new StructuredSelection(), (String)"org.eclipse.debug.ui.launchGroup.run", null);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void okPressed() {
        if (this.autComposite.doOk()) {
            this.result = this.autComposite.getLaunch();
            super.okPressed();
        }
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        if (this.autComposite == null) {
            this.updateEnablement(false);
        } else {
            this.updateEnablement(this.autComposite.isSelectionOK());
        }
        return result;
    }

    private void updateEnablement(boolean state) {
        if (this.buttonBar != null) {
            Button button = this.getButton(0);
            button.setEnabled(state);
        }
    }

    public AutLaunch getResult() {
        return this.result;
    }

    protected Point getInitialSize() {
        Point calculatedSize = super.getInitialSize();
        Rectangle bounds = this.getShell().getDisplay().getBounds();
        int minHeight = bounds.height / 2 - bounds.height / 10 - 50;
        if (calculatedSize.x < 450) {
            calculatedSize.x = 450;
        }
        if (calculatedSize.y < minHeight) {
            calculatedSize.y = minHeight;
        }
        return calculatedSize;
    }

    @Override
    public void launched(AutLaunch launch) {
        this.result = launch;
        super.okPressed();
    }
}

