/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class LaunchingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.pde.ui.LaunchingPreferencePage";
    private Button fAutoManage;
    private Button fAddSwtNonDisposalReporting;
    private Text fRuntimeWorkspaceLocation;
    private Button fRuntimeWorkspaceLocationRadio;
    private Button fRuntimeWorkspacesContainerRadio;
    private Text fJUnitWorkspaceLocation;
    private Button fJUnitWorkspaceLocationRadio;
    private Button fJUnitWorkspacesContainerRadio;
    private Combo fJunitLaunchWithCombo;
    private Button fJunitAutoIncludeRequirementsButton;
    private Button fJunitIncludeOptionalButton;
    private Button fJunitAddWorkspaceButton;
    private Button fJunitAutoValidate;

    public LaunchingPreferencePage() {
        this.setPreferenceStore(PDEPlugin.getDefault().getPreferenceStore());
        this.setDescription(PDEUIMessages.LaunchingPreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        ((GridLayout)composite.getLayout()).verticalSpacing = 15;
        ((GridLayout)composite.getLayout()).marginTop = 15;
        Composite optionComp = SWTFactory.createComposite(composite, 1, 1, 768, 0, 0);
        this.fAutoManage = new Button(optionComp, 32);
        this.fAutoManage.setText(PDEUIMessages.MainPreferencePage_updateStale);
        this.fAutoManage.setSelection(launchingStore.getBoolean("Preferences.Launching.automanageDependencies"));
        this.fAddSwtNonDisposalReporting = new Button(optionComp, 32);
        this.fAddSwtNonDisposalReporting.setText(PDEUIMessages.MainPreferencePage_AddSwtNonDisposedToVMArguments);
        this.fAddSwtNonDisposalReporting.setToolTipText(PDEUIMessages.MainPreferencePage_AddSwtNonDisposedToVMArgumentsToolTop);
        this.fAddSwtNonDisposalReporting.setSelection(launchingStore.getBoolean("Preferences.Launching.addSwtNonDisposalReporting"));
        new DefaultRuntimeWorkspaceBlock().createControl(composite);
        this.fRuntimeWorkspaceLocation.setText(launchingStore.getString("Preferences.Launching.runtimeWorkspaceLocation"));
        boolean runtimeLocationIsContainer = launchingStore.getBoolean("Preferences.Launching.runtimeWorkspaceLocationIsContainer");
        this.fRuntimeWorkspaceLocationRadio.setSelection(!runtimeLocationIsContainer);
        this.fRuntimeWorkspacesContainerRadio.setSelection(runtimeLocationIsContainer);
        new DefaultJUnitWorkspaceBlock().createControl(composite);
        this.fJUnitWorkspaceLocation.setText(launchingStore.getString("Preferences.Launching.junitWorkspaceLocation"));
        boolean jUnitLocationIsContainer = launchingStore.getBoolean("Preferences.Launching.junitWorkspaceLocationIsContainer");
        this.fJUnitWorkspaceLocationRadio.setSelection(!jUnitLocationIsContainer);
        this.fJUnitWorkspacesContainerRadio.setSelection(jUnitLocationIsContainer);
        this.fJunitLaunchWithCombo.select("testPluginOnly".equals(launchingStore.getString("Preferences.Launching.junitLaunchWith")) ? 0 : 1);
        this.fJunitAutoIncludeRequirementsButton.setSelection(launchingStore.getBoolean("Preferences.Launching.junitAutoInclude"));
        this.fJunitIncludeOptionalButton.setSelection(launchingStore.getBoolean("Preferences.Launching.junitIncludeOptional"));
        this.fJunitAddWorkspaceButton.setSelection(launchingStore.getBoolean("Preferences.Launching.junitAddNewWorkspacePlugins"));
        this.fJunitAutoValidate.setSelection(launchingStore.getBoolean("Preferences.Launching.junitValidateLaunch"));
        return composite;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        Dialog.applyDialogFont((Control)this.getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.main_preference_page");
    }

    public boolean performOk() {
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        launchingStore.setValueOrRemove("Preferences.Launching.automanageDependencies", this.fAutoManage.getSelection());
        launchingStore.setValueOrRemove("Preferences.Launching.runtimeWorkspaceLocation", this.fRuntimeWorkspaceLocation.getText());
        launchingStore.setValueOrRemove("Preferences.Launching.runtimeWorkspaceLocationIsContainer", this.fRuntimeWorkspacesContainerRadio.getSelection());
        launchingStore.setValueOrRemove("Preferences.Launching.junitWorkspaceLocation", this.fJUnitWorkspaceLocation.getText());
        launchingStore.setValueOrRemove("Preferences.Launching.junitWorkspaceLocationIsContainer", this.fJUnitWorkspacesContainerRadio.getSelection());
        launchingStore.setValueOrRemove("Preferences.Launching.junitLaunchWith", this.fJunitLaunchWithCombo.getSelectionIndex() == 0 ? "testPluginOnly" : "allWorkspacePlugins");
        launchingStore.setValueOrRemove("Preferences.Launching.junitAddNewWorkspacePlugins", this.fJunitAddWorkspaceButton.getSelection());
        launchingStore.setValueOrRemove("Preferences.Launching.junitAutoInclude", this.fJunitAutoIncludeRequirementsButton.getSelection());
        launchingStore.setValueOrRemove("Preferences.Launching.junitIncludeOptional", this.fJunitIncludeOptionalButton.getSelection());
        launchingStore.setValueOrRemove("Preferences.Launching.junitValidateLaunch", this.fJunitAutoValidate.getSelection());
        launchingStore.setValueOrRemove("Preferences.Launching.addSwtNonDisposalReporting", this.fAddSwtNonDisposalReporting.getSelection());
        try {
            launchingStore.flush();
        }
        catch (BackingStoreException e) {
            PDEPlugin.log(e);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        this.fAutoManage.setSelection(launchingStore.getDefaultBoolean("Preferences.Launching.automanageDependencies"));
        this.fAddSwtNonDisposalReporting.setSelection(launchingStore.getDefaultBoolean("Preferences.Launching.addSwtNonDisposalReporting"));
        boolean runtimeLocationIsContainer = launchingStore.getDefaultBoolean("Preferences.Launching.runtimeWorkspaceLocationIsContainer");
        this.fRuntimeWorkspaceLocationRadio.setSelection(!runtimeLocationIsContainer);
        this.fRuntimeWorkspacesContainerRadio.setSelection(runtimeLocationIsContainer);
        this.fRuntimeWorkspaceLocation.setText(launchingStore.getDefaultString("Preferences.Launching.runtimeWorkspaceLocation"));
        boolean jUnitLocationIsContainer = launchingStore.getDefaultBoolean("Preferences.Launching.junitWorkspaceLocationIsContainer");
        this.fJUnitWorkspaceLocationRadio.setSelection(!jUnitLocationIsContainer);
        this.fJUnitWorkspacesContainerRadio.setSelection(jUnitLocationIsContainer);
        this.fJUnitWorkspaceLocation.setText(launchingStore.getDefaultString("Preferences.Launching.junitWorkspaceLocation"));
        this.fJunitLaunchWithCombo.select("testPluginOnly".equals(launchingStore.getDefaultString("Preferences.Launching.junitLaunchWith")) ? 0 : 1);
        this.fJunitAutoIncludeRequirementsButton.setSelection(launchingStore.getDefaultBoolean("Preferences.Launching.junitAutoInclude"));
        this.fJunitIncludeOptionalButton.setSelection(launchingStore.getDefaultBoolean("Preferences.Launching.junitIncludeOptional"));
        this.fJunitAddWorkspaceButton.setSelection(launchingStore.getDefaultBoolean("Preferences.Launching.junitAddNewWorkspacePlugins"));
        this.fJunitAutoValidate.setSelection(launchingStore.getDefaultBoolean("Preferences.Launching.junitValidateLaunch"));
    }

    public void init(IWorkbench workbench) {
    }

    private final class DefaultJUnitWorkspaceBlock
    extends BaseBlock {
        DefaultJUnitWorkspaceBlock() {
            super(null);
        }

        public void createControl(Composite parent) {
            Group group = SWTFactory.createGroup(parent, PDEUIMessages.MainPreferencePage_junitWorkspaceGroup, 2, 1, 768);
            SWTFactory.createLabel((Composite)group, PDEUIMessages.PluginsTab_launchWith, 1);
            LaunchingPreferencePage.this.fJunitLaunchWithCombo = SWTFactory.createCombo((Composite)group, 2056, 1, 32, new String[]{PDEUIMessages.MainPreferencePage_optionTestPlugin, PDEUIMessages.PluginsTab_allPlugins});
            SWTFactory.createLabel((Composite)group, "", 1);
            Composite options = SWTFactory.createComposite((Composite)group, 1, 1, 768, 0, 0);
            LaunchingPreferencePage.this.fJunitAutoIncludeRequirementsButton = SWTFactory.createCheckButton(options, PDEUIMessages.AdvancedLauncherTab_autoIncludeRequirements_plugins, null, true, 1);
            LaunchingPreferencePage.this.fJunitIncludeOptionalButton = SWTFactory.createCheckButton(options, PDEUIMessages.AdvancedLauncherTab_includeOptional_plugins, null, true, 1);
            LaunchingPreferencePage.this.fJunitAddWorkspaceButton = SWTFactory.createCheckButton(options, PDEUIMessages.AdvancedLauncherTab_addNew_plugins, null, false, 1);
            LaunchingPreferencePage.this.fJunitAutoValidate = SWTFactory.createCheckButton(options, PDEUIMessages.PluginsTabToolBar_auto_validate_plugins, null, true, 1);
            Composite radios = SWTFactory.createComposite((Composite)group, 2, 2, 768, 0, 0);
            LaunchingPreferencePage.this.fJUnitWorkspaceLocationRadio = new Button(radios, 16);
            LaunchingPreferencePage.this.fJUnitWorkspaceLocationRadio.setText(PDEUIMessages.MainPreferencePage_junitWorkspace_asLocation);
            LaunchingPreferencePage.this.fJUnitWorkspaceLocationRadio.setLayoutData((Object)new GridData(32));
            LaunchingPreferencePage.this.fJUnitWorkspaceLocationRadio.setSelection(true);
            LaunchingPreferencePage.this.fJUnitWorkspacesContainerRadio = new Button(radios, 16);
            LaunchingPreferencePage.this.fJUnitWorkspacesContainerRadio.setText(PDEUIMessages.MainPreferencePage_junitWorkspace_asContainer);
            LaunchingPreferencePage.this.fJUnitWorkspacesContainerRadio.setLayoutData((Object)new GridData(32));
            this.createText((Composite)group, PDEUIMessages.WorkspaceDataBlock_location, 0);
            ((GridData)this.fLocationText.getLayoutData()).widthHint = 200;
            LaunchingPreferencePage.this.fJUnitWorkspaceLocation = this.fLocationText;
            Composite buttons = SWTFactory.createComposite((Composite)group, 3, 2, 640, 0, 0);
            this.createButtons(buttons, new String[]{PDEUIMessages.MainPreferencePage_junitWorkspace_workspace, PDEUIMessages.MainPreferencePage_junitWorkspace_fileSystem, PDEUIMessages.MainPreferencePage_junitWorkspace_variables});
        }

        @Override
        protected String getName() {
            return PDEUIMessages.DefaultJUnitWorkspaceBlock_name;
        }

        @Override
        protected boolean isFile() {
            return false;
        }
    }

    private final class DefaultRuntimeWorkspaceBlock
    extends BaseBlock {
        DefaultRuntimeWorkspaceBlock() {
            super(null);
        }

        public void createControl(Composite parent) {
            Group group = SWTFactory.createGroup(parent, PDEUIMessages.MainPreferencePage_runtimeWorkspaceGroup, 2, 1, 768);
            Composite radios = SWTFactory.createComposite((Composite)group, 2, 2, 768, 0, 0);
            LaunchingPreferencePage.this.fRuntimeWorkspaceLocationRadio = new Button(radios, 16);
            LaunchingPreferencePage.this.fRuntimeWorkspaceLocationRadio.setText(PDEUIMessages.MainPreferencePage_runtimeWorkspace_asLocation);
            LaunchingPreferencePage.this.fRuntimeWorkspaceLocationRadio.setLayoutData((Object)new GridData(32));
            LaunchingPreferencePage.this.fRuntimeWorkspaceLocationRadio.setSelection(true);
            LaunchingPreferencePage.this.fRuntimeWorkspacesContainerRadio = new Button(radios, 16);
            LaunchingPreferencePage.this.fRuntimeWorkspacesContainerRadio.setText(PDEUIMessages.MainPreferencePage_runtimeWorkspace_asContainer);
            LaunchingPreferencePage.this.fRuntimeWorkspacesContainerRadio.setLayoutData((Object)new GridData(32));
            this.createText((Composite)group, PDEUIMessages.WorkspaceDataBlock_location, 0);
            ((GridData)this.fLocationText.getLayoutData()).widthHint = 200;
            LaunchingPreferencePage.this.fRuntimeWorkspaceLocation = this.fLocationText;
            Composite buttons = SWTFactory.createComposite((Composite)group, 3, 2, 640, 0, 0);
            this.createButtons(buttons, new String[]{PDEUIMessages.MainPreferencePage_runtimeWorkspace_workspace, PDEUIMessages.MainPreferencePage_runtimeWorkspace_fileSystem, PDEUIMessages.MainPreferencePage_runtimeWorkspace_variables});
        }

        @Override
        protected String getName() {
            return PDEUIMessages.WorkspaceDataBlock_name;
        }

        @Override
        protected boolean isFile() {
            return false;
        }
    }
}

