/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.tasks;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.service.resource.SupportingResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.pde.bnd.ui.model.resolution.RequirementWrapper;
import org.eclipse.pde.bnd.ui.tasks.CapReqLoader;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public abstract class BndBuilderCapReqLoader
implements CapReqLoader {
    protected final File file;
    private Map<String, List<Capability>> loadCapabilities;
    private Map<String, List<RequirementWrapper>> loadRequirements;

    public BndBuilderCapReqLoader(File file) {
        this.file = file;
    }

    @Override
    public String getShortLabel() {
        return this.file.getName();
    }

    @Override
    public String getLongLabel() {
        return this.file.getName() + " - " + this.file.getParentFile().getAbsolutePath();
    }

    protected abstract Builder getBuilder() throws Exception;

    private void load() throws Exception {
        if (this.loadCapabilities != null && this.loadRequirements != null) {
            return;
        }
        Builder builder = this.getBuilder();
        if (builder == null) {
            this.loadCapabilities = Collections.emptyMap();
            this.loadRequirements = Collections.emptyMap();
            return;
        }
        Jar jar = builder.getJar();
        if (jar == null) {
            this.loadCapabilities = Collections.emptyMap();
            this.loadRequirements = Collections.emptyMap();
            return;
        }
        ResourceBuilder rb = new ResourceBuilder();
        rb.addJar(jar);
        SupportingResource sr = rb.build();
        ArrayList capabilities = new ArrayList();
        ArrayList requirements = new ArrayList();
        for (Resource resource : sr.all()) {
            capabilities.addAll(resource.getCapabilities(null));
            requirements.addAll(resource.getRequirements(null));
        }
        this.loadRequirements = requirements.stream().collect(Collectors.groupingBy(Requirement::getNamespace, Collectors.mapping(this::toRequirementWrapper, Collectors.toList())));
        this.loadCapabilities = capabilities.stream().collect(Collectors.groupingBy(Capability::getNamespace, Collectors.toList()));
    }

    @Override
    public Map<String, List<Capability>> loadCapabilities() throws Exception {
        this.load();
        return this.loadCapabilities;
    }

    @Override
    public Map<String, List<RequirementWrapper>> loadRequirements() throws Exception {
        this.load();
        return this.loadRequirements;
    }

    private RequirementWrapper toRequirementWrapper(Requirement req) {
        RequirementWrapper rw = new RequirementWrapper(req);
        if (req.getNamespace().equals("osgi.wiring.package")) {
            String pkgName = (String)req.getAttributes().get("osgi.wiring.package");
            try {
                rw.requirers = this.findImportingClasses(pkgName);
            }
            catch (Exception e) {
                throw Exceptions.duck((Throwable)e);
            }
        }
        return rw;
    }

    private List<Clazz> findImportingClasses(String pkgName) throws Exception {
        LinkedList<Clazz> classes = new LinkedList<Clazz>();
        Collection importers = this.getBuilder().getClasses(new String[]{"", "IMPORTING", pkgName});
        for (Clazz clazz : importers) {
            String pkg;
            String fqn = clazz.getFQN();
            int dot = fqn.lastIndexOf(46);
            if (dot < 0 || pkgName.equals(pkg = fqn.substring(0, dot))) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public File getFile() {
        return this.file;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BndBuilderCapReqLoader other = (BndBuilderCapReqLoader)obj;
        return Objects.equals(this.file, other.file);
    }
}

