/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.service.reporter.Report;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.bnd.BndErrorReporter;
import org.eclipse.pde.internal.core.bnd.BndProjectManager;
import org.eclipse.pde.internal.core.bnd.MakeJar;
import org.eclipse.pde.internal.core.bnd.ProjectJar;
import org.eclipse.pde.internal.core.natures.BndProject;
import org.eclipse.pde.internal.core.project.PDEProject;

public class BndBuilder
extends IncrementalProjectBuilder {
    private static final String CLASS_EXTENSION = ".class";
    private static final boolean USE_JOB = false;
    private static final Predicate<IResource> CLASS_FILTER = resource -> {
        if (resource instanceof IFile) {
            return resource.getName().endsWith(CLASS_EXTENSION);
        }
        return true;
    };
    private final Map<IProject, Job> buildJobMap = new ConcurrentHashMap<IProject, Job>();
    public static final String BUILDER_ID = "org.eclipse.pde.BndBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (BndProject.isBndProject(project) && (BndBuilder.requireBuild(project) || BndBuilder.hasRelevantDelta(this.getDelta(project)))) {
            BndBuilder.buildProjectJar(project, monitor);
        }
        return new IProject[]{project};
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IFile file = this.getProject().getFile("pde.bnd");
        if (file.exists()) {
            file.deleteMarkers("org.eclipse.pde.core.problem", true, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void buildProjectJar(IProject project, IProgressMonitor monitor) {
        try {
            block21: {
                Optional<Project> bndProject = BndProjectManager.getBndProject(project);
                if (bndProject.isEmpty()) {
                    return;
                }
                if (monitor.isCanceled()) {
                    return;
                }
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    final Project bnd = bndProject.get();
                    try {
                        try (ProjectBuilder builder = new ProjectBuilder(bnd){

                            public void addClasspath(Jar jar) {
                                try {
                                    if (Objects.equals(jar.getSource(), bnd.getOutput())) {
                                        jar.close();
                                        return;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                super.addClasspath(jar);
                            }
                        };){
                            builder.addBasicPlugin((Object)new MakeJar());
                            builder.setBase(bnd.getBase());
                            ProjectJar jar = new ProjectJar(project, CLASS_FILTER);
                            builder.setJar((Jar)jar);
                            builder.build();
                            new BndErrorReporter(project, (Report)bnd, project.getFile("pde.bnd")).validateContent(monitor);
                            List subBuilders = builder.getSubBuilders();
                            block9: for (Builder subBuilder : subBuilders) {
                                int n;
                                IFile[] iFileArray;
                                File outputFile;
                                if (subBuilder == builder || (outputFile = subBuilder.getOutputFile(null)) == null) continue;
                                Jar subJar = subBuilder.build();
                                subJar.write(outputFile);
                                IFile[] iFileArray2 = project.getWorkspace().getRoot().findFilesForLocationURI(outputFile.toURI());
                                int n2 = iFileArray2.length;
                                int n3 = 0;
                                while (true) {
                                    if (n3 >= n2) {
                                        File propertiesFile = subBuilder.getPropertiesFile();
                                        if (propertiesFile == null) continue block9;
                                        iFileArray = project.getWorkspace().getRoot().findFilesForLocationURI(propertiesFile.toURI());
                                        n = iFileArray.length;
                                        n2 = 0;
                                        break;
                                    }
                                    IFile file = iFileArray2[n3];
                                    file.refreshLocal(0, monitor);
                                    ++n3;
                                }
                                while (n2 < n) {
                                    IFile file = iFileArray[n2];
                                    new BndErrorReporter(project, (Report)subBuilder, file).validateContent(monitor);
                                    ++n2;
                                }
                            }
                        }
                        if (bnd == null) break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (bnd == null) throw throwable;
                        bnd.close();
                        throw throwable;
                    }
                    bnd.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (!monitor.isCanceled()) return;
            return;
        }
        catch (Exception e) {
            PDECore.log(e);
        }
    }

    private static boolean requireBuild(IProject project) {
        return !PDEProject.getManifest(project).exists();
    }

    private static boolean hasRelevantDelta(IResourceDelta delta) throws CoreException {
        if (delta != null) {
            final AtomicBoolean result = new AtomicBoolean();
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IFile file;
                    String name;
                    IResource resource = delta.getResource();
                    if (resource instanceof IFile && ((name = (file = (IFile)resource).getName()).endsWith(BndBuilder.CLASS_EXTENSION) || file.getName().equals("pde.bnd") || name.equals("MANIFEST.MF"))) {
                        result.set(true);
                        return false;
                    }
                    return true;
                }
            });
            return result.get();
        }
        return true;
    }

    private static final class BndBuild
    implements ICoreRunnable {
        private final IProject project;
        private final Job oldJob;

        public BndBuild(IProject project, Job oldJob) {
            this.project = project;
            this.oldJob = oldJob;
        }

        public void run(IProgressMonitor monitor) {
            if (this.oldJob != null) {
                this.oldJob.cancel();
                try {
                    this.oldJob.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            BndBuilder.buildProjectJar(this.project, monitor);
        }
    }
}

