/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CorrectPackageDeclarationFixCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFixCore;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUpCore;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsBaseSubProcessor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public abstract class ReorgCorrectionsBaseSubProcessor<T> {
    protected ReorgCorrectionsBaseSubProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    public void addWrongTypeNameProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        T prop1;
        void simpleCovered;
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        IJavaProject javaProject = cu.getJavaProject();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        String previewEnabled = javaProject.getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true);
        CompilationUnit root = context.getASTRoot();
        ASTNode coveredNode = problem.getCoveredNode(root);
        if (!(coveredNode instanceof SimpleName)) {
            return;
        }
        SimpleName simpleName = (SimpleName)coveredNode;
        ASTNode parentType = coveredNode.getParent();
        if (!(parentType instanceof AbstractTypeDeclaration)) {
            return;
        }
        String currTypeName = simpleCovered.getIdentifier();
        String newTypeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        boolean hasOtherPublicTypeBefore = false;
        boolean found = false;
        List types = root.types();
        for (AbstractTypeDeclaration curr : types) {
            if (parentType != curr) {
                if (newTypeName.equals(curr.getName().getIdentifier())) {
                    return;
                }
                if (found || !Modifier.isPublic((int)curr.getModifiers())) continue;
                hasOtherPublicTypeBefore = true;
                continue;
            }
            found = true;
        }
        if (!JavaConventions.validateJavaTypeName((String)newTypeName, (String)sourceLevel, (String)compliance, (String)previewEnabled).matches(4) && (prop1 = this.createCorrectMainTypeNameProposal(cu, context, currTypeName, newTypeName, 5)) != null) {
            proposals.add(prop1);
        }
        if (!hasOtherPublicTypeBefore) {
            String newCUName = JavaModelUtil.getRenamedCUName(cu, currTypeName);
            ICompilationUnit newCU = ((IPackageFragment)cu.getParent()).getCompilationUnit(newCUName);
            if (!(newCU.exists() || isLinked || JavaConventions.validateCompilationUnitName((String)newCUName, (String)sourceLevel, (String)compliance).matches(4))) {
                RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName);
                String label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renamecu_description, BasicElementLabels.getResourceName(newCUName));
                T p2 = this.createRenameCUProposal(label, change, 6);
                if (p2 != null) {
                    proposals.add(p2);
                }
            }
        }
    }

    public void addWrongPackageDeclNameProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        IPackageDeclaration[] packDecls;
        T p1;
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        int relevance = cu.getPackageDeclarations().length == 0 ? 7 : 6;
        CorrectPackageDeclarationFixCore fix = CorrectPackageDeclarationFixCore.create(context.getASTRoot(), problem);
        if (fix != null && (p1 = this.createCorrectPackageDeclarationProposal(fix, context, relevance)) != null) {
            proposals.add(p1);
        }
        String newPackName = (packDecls = cu.getPackageDeclarations()).length > 0 ? packDecls[0].getElementName() : "";
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu);
        IPackageFragment newPack = root.getPackageFragment(newPackName);
        ICompilationUnit newCU = newPack.getCompilationUnit(cu.getElementName());
        if (!newCU.exists() && !isLinked) {
            String label;
            if (newPack.isDefaultPackage()) {
                label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_default_description, BasicElementLabels.getFileName((ITypeRoot)cu));
            } else {
                String packageLabel = JavaElementLabelsCore.getElementLabel((IJavaElement)newPack, 0x200009L);
                label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_description, new Object[]{BasicElementLabels.getFileName((ITypeRoot)cu), packageLabel});
            }
            CompositeChange composite = new CompositeChange(label);
            composite.add((Change)new CreatePackageChange(newPack));
            composite.add((Change)new MoveCompilationUnitChange(cu, newPack));
            T p12 = this.createMoveToNewPackageProposal(label, composite, 6);
            if (p12 != null) {
                proposals.add(p12);
            }
        }
    }

    public void addRemoveImportStatementProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ICompilationUnit cu;
        String name;
        T proposal;
        UnusedCodeFixCore fix = UnusedCodeFixCore.createRemoveUnusedImportFix(context.getASTRoot(), problem);
        if (fix != null) {
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.remove_unused_imports", "true");
            T proposal2 = this.createRemoveUnusedImportProposal(fix, new UnusedCodeCleanUpCore(options), 6, context);
            if (proposal2 != null) {
                proposals.add(proposal2);
            }
        }
        if ((proposal = this.createOrganizeImportsProposal(name = CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description, null, cu = context.getCompilationUnit(), 5)) != null) {
            proposals.add(proposal);
        }
    }

    public void addProjectSetupFixProposals(IInvocationContext context, IProblemLocation problem, String missingType, Collection<T> proposals) {
        T prop = this.createProjectSetupFixProposal(context, problem, missingType, proposals);
        if (prop != null) {
            proposals.add(prop);
        }
    }

    public void addNeedHigherComplianceProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals, String requiredVersion) {
        this.addNeedHigherComplianceProposals(context, problem, proposals, false, requiredVersion);
    }

    public void addNeedHigherComplianceProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        String[] args = problem.getProblemArguments();
        if (args != null && args.length == 2) {
            this.addNeedHigherComplianceProposals(context, problem, proposals, false, args[1]);
        }
    }

    protected void addNeedHigherComplianceProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals, boolean enablePreviews, String requiredVersion) {
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        String label1 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_change_project_compliance_description, requiredVersion);
        if (enablePreviews) {
            label1 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_combine_two_quickfixes, new String[]{label1, CorrectionMessages.PreviewFeaturesSubProcessor_enable_preview_features});
            proposals.add(this.createChangeToRequiredCompilerComplianceProposal(label1, project, false, requiredVersion, enablePreviews, 6));
        } else {
            proposals.add(this.createChangeToRequiredCompilerComplianceProposal(label1, project, false, requiredVersion, 6));
        }
        if (project.getOption("org.eclipse.jdt.core.compiler.compliance", false) == null) {
            T p1;
            String label2 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_change_workspace_compliance_description, requiredVersion);
            if (enablePreviews) {
                label2 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_combine_two_quickfixes, new String[]{label2, CorrectionMessages.PreviewFeaturesSubProcessor_enable_preview_features_workspace});
            }
            if ((p1 = this.createChangeToRequiredCompilerComplianceProposal(label2, project, true, requiredVersion, enablePreviews, 7)) != null) {
                proposals.add(p1);
            }
        }
    }

    public void addIncorrectBuildPathProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        String label;
        IProject project = context.getCompilationUnit().getJavaProject().getProject();
        T proposal = this.createOpenBuildPathCorrectionProposal(project, label = CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_label, 5, null);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    public void addAccessRulesProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        String label;
        IProject project;
        T proposal;
        ITypeBinding referencedElement = null;
        ASTNode node = problem.getCoveredNode(context.getASTRoot());
        if (node instanceof Type) {
            Type type = (Type)node;
            referencedElement = type.resolveBinding();
        } else if (node instanceof Name) {
            Name name = (Name)node;
            referencedElement = name.resolveBinding();
        }
        if (referencedElement != null && ReorgCorrectionsBaseSubProcessor.canModifyAccessRules((IBinding)referencedElement) && (proposal = this.createOpenBuildPathCorrectionProposal(project = context.getCompilationUnit().getJavaProject().getProject(), label = CorrectionMessages.ReorgCorrectionsSubProcessor_accessrules_description, 5, (IBinding)referencedElement)) != null) {
            proposals.add(proposal);
        }
    }

    public boolean addImportNotFoundProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        Object name;
        ICompilationUnit cu = context.getCompilationUnit();
        UnresolvedElementsBaseSubProcessor<T> unresolvedElements = this.getUnresolvedElementsSubProcessor();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return false;
        }
        ImportDeclaration importDeclaration = (ImportDeclaration)ASTNodes.getParent(selectedNode, 26);
        if (importDeclaration == null) {
            return false;
        }
        if (!importDeclaration.isOnDemand()) {
            name = importDeclaration.getName();
            if (importDeclaration.isStatic() && name.isQualifiedName()) {
                name = ((QualifiedName)name).getQualifier();
            }
            unresolvedElements.collectRequiresModuleProposals(cu, (Name)name, 5, proposals, false);
            unresolvedElements.collectNewTypeProposals(cu, (Name)name, 30, 5, proposals);
        } else {
            name = importDeclaration.getName();
            unresolvedElements.collectRequiresModuleProposals(cu, (Name)name, 5, proposals, true);
        }
        name = ASTNodes.asString((ASTNode)importDeclaration.getName());
        if (importDeclaration.isOnDemand()) {
            name = JavaModelUtil.concatenateName((String)name, "*");
        }
        this.addProjectSetupFixProposals(context, problem, (String)name, proposals);
        return true;
    }

    private static boolean canModifyAccessRules(IBinding binding) {
        IClasspathEntry classpathEntry;
        IPackageFragmentRoot root;
        block8: {
            block7: {
                IJavaElement element = binding.getJavaElement();
                if (element == null) {
                    return false;
                }
                root = JavaModelUtil.getPackageFragmentRoot(element);
                if (root == null) {
                    return false;
                }
                try {
                    classpathEntry = root.getRawClasspathEntry();
                    if (classpathEntry != null) break block7;
                    return false;
                }
                catch (JavaModelException e) {
                    return false;
                }
            }
            if (classpathEntry.getEntryKind() != 1) break block8;
            return true;
        }
        if (classpathEntry.getEntryKind() == 5) {
            ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)classpathEntry.getPath().segment(0));
            IStatus status = classpathContainerInitializer.getAccessRulesStatus(classpathEntry.getPath(), root.getJavaProject());
            return status.isOK();
        }
        return false;
    }

    public abstract UnresolvedElementsBaseSubProcessor<T> getUnresolvedElementsSubProcessor();

    public abstract T createRenameCUProposal(String var1, RenameCompilationUnitChange var2, int var3);

    public abstract T createCorrectMainTypeNameProposal(ICompilationUnit var1, IInvocationContext var2, String var3, String var4, int var5);

    protected abstract T createCorrectPackageDeclarationProposal(IProposableFix var1, IInvocationContext var2, int var3);

    protected abstract T createMoveToNewPackageProposal(String var1, CompositeChange var2, int var3);

    protected abstract T createOrganizeImportsProposal(String var1, Change var2, ICompilationUnit var3, int var4);

    protected abstract T createRemoveUnusedImportProposal(IProposableFix var1, UnusedCodeCleanUpCore var2, int var3, IInvocationContext var4);

    public abstract T createProjectSetupFixProposal(IInvocationContext var1, IProblemLocation var2, String var3, Collection<T> var4);

    protected abstract T createChangeToRequiredCompilerComplianceProposal(String var1, IJavaProject var2, boolean var3, String var4, int var5);

    protected abstract T createChangeToRequiredCompilerComplianceProposal(String var1, IJavaProject var2, boolean var3, String var4, boolean var5, int var6);

    protected abstract T createOpenBuildPathCorrectionProposal(IProject var1, String var2, int var3, IBinding var4);
}

