/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class AbstractFeatureManager {
    public static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
    public static final String[] INT_VALUES = new String[0];
    private Map<String, Option> options = new TreeMap<String, Option>();
    private Map<String, String> replaceKeys = new HashMap<String, String>();

    public Option option(String id) {
        Option op = new Option();
        this.options.put(id, op);
        return op;
    }

    public Option boolOption(String id, boolean values) {
        Option op = new Option().values(BOOLEAN_VALUES).defaultValue(Boolean.toString(values)).value(Boolean.toString(values));
        this.options.put(id, op);
        return op;
    }

    public Option intOption(String id, int defaultValue) {
        Option op = new Option().values(INT_VALUES).defaultValue(Integer.toString(defaultValue)).value(Integer.toString(defaultValue));
        this.options.put(id, op);
        return op;
    }

    public Option[] getOptions() {
        return this.options.values().toArray(new Option[this.options.size()]);
    }

    public Option getOption(String id) {
        if (this.options.containsKey(id)) {
            return this.options.get(id);
        }
        return null;
    }

    public String[] getOptionNames() {
        return this.options.keySet().toArray(new String[this.options.size()]);
    }

    public String getValue(String id) {
        Option op = this.getOption(id);
        if (op != null) {
            return op.getValue();
        }
        return null;
    }

    public int getIntValue(String id) {
        return Integer.parseInt(this.getOption(id).getValue());
    }

    public boolean isTrue(String id) {
        String value = this.getValue(id);
        if (value == null) {
            return false;
        }
        return "true".equalsIgnoreCase(value);
    }

    public void storeValues(List<String> values) {
        Set<String> set = this.options.keySet();
        for (String key : set) {
            Option option = this.options.get(key);
            if (!option.editable) continue;
            values.add(key + "=" + option.value);
        }
    }

    public void setValues(List<String> values) {
        for (String vals : values) {
            int pos = vals.indexOf(61);
            String key = this.replaceKey(vals.substring(0, pos));
            String value = vals.substring(pos + 1);
            if (!this.options.containsKey(key)) continue;
            Option option = this.options.get(key);
            option.value = value;
        }
    }

    private String replaceKey(String key) {
        if (this.replaceKeys.containsKey(key)) {
            return this.replaceKeys.get(key);
        }
        return key;
    }

    public void saveToPreferences(IEclipsePreferences prefs) {
        Set<String> set = this.options.keySet();
        for (String key : set) {
            Option option = this.options.get(key);
            if (!option.editable || option.value.equals(option.defaultValue)) {
                prefs.remove(key);
                continue;
            }
            prefs.put(key, option.value);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void loadFromPreferences(IEclipsePreferences prefs) {
        Set<String> set = this.options.keySet();
        for (String key : set) {
            key = this.replaceKey(key);
            Option option = this.options.get(key);
            if (!option.editable) continue;
            option.value = prefs.get(key, option.value);
        }
    }

    public void addReplace(String oldKey, String newKey) {
        this.replaceKeys.put(oldKey, newKey);
    }

    public static class Option {
        private String description;
        private String value = "";
        private String defaultValue = "";
        private String name;
        private String[] values;
        private String category = null;
        boolean editable = true;
        private int order = 0;
        Set<String> showIn = null;

        public boolean isEditable() {
            return this.editable;
        }

        public Option name(String name) {
            this.name = name;
            return this;
        }

        public Option order(int order) {
            this.order = order;
            return this;
        }

        public Option description(String value) {
            this.description = value;
            return this;
        }

        public Option category(String value) {
            this.category = value;
            return this;
        }

        public Option editable(boolean value) {
            this.editable = value;
            return this;
        }

        public Option value(String value) {
            this.value = value;
            return this;
        }

        public Option defaultValue(String defValue) {
            this.defaultValue = defValue;
            return this;
        }

        public Option values(String ... values) {
            this.values = values;
            return this;
        }

        public Option showIn(String ... value) {
            if (this.showIn == null) {
                this.showIn = new HashSet<String>();
            }
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.showIn.add(string);
                ++n2;
            }
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public String getValue() {
            return this.value;
        }

        public String[] getValues() {
            return this.values;
        }

        public String getName() {
            return this.name;
        }

        public String getCategory() {
            return this.category;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isShowIn(String value) {
            if (this.showIn == null) {
                return true;
            }
            return this.showIn.contains(value);
        }

        public int getOrder() {
            return this.order;
        }
    }
}

