/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import java.util.ArrayList;
import org.eclipse.rdf4j.federated.EndpointManager;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveStatement;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.optimizer.FedXOptimizer;
import org.eclipse.rdf4j.federated.optimizer.GenericInfoOptimizer;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;

public class ServiceOptimizer
extends AbstractSimpleQueryModelVisitor<OptimizationException>
implements FedXOptimizer {
    protected final QueryInfo queryInfo;

    public ServiceOptimizer(QueryInfo queryInfo) {
        super(true);
        this.queryInfo = queryInfo;
    }

    @Override
    public void optimize(TupleExpr tupleExpr) {
        try {
            tupleExpr.visit((QueryModelVisitor)this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new FedXRuntimeException(e);
        }
    }

    public void meet(Service service) {
        TupleExpr newExpr = this.optimizeService(service);
        service.replaceWith((QueryModelNode)newExpr);
    }

    protected TupleExpr optimizeService(Service service) {
        if (service.getServiceRef().hasValue()) {
            String serviceUri = service.getServiceRef().getValue().stringValue();
            GenericInfoOptimizer serviceInfo = new GenericInfoOptimizer(this.queryInfo);
            serviceInfo.optimize(service.getServiceExpr());
            Endpoint e = this.getFedXEndpoint(serviceUri);
            if (e == null) {
                return new FedXService(service, this.queryInfo);
            }
            StatementSource source = new StatementSource(e.getId(), StatementSource.StatementSourceType.REMOTE);
            ArrayList<ExclusiveStatement> stmts = new ArrayList<ExclusiveStatement>();
            for (StatementPattern st : serviceInfo.getStatements()) {
                ExclusiveStatement est = new ExclusiveStatement(st, source, this.queryInfo);
                st.replaceWith((QueryModelNode)est);
                stmts.add(est);
            }
            if (service.getArg() instanceof ExclusiveStatement) {
                return service.getArg();
            }
            if (service.getArg() instanceof NJoin) {
                NJoin j = (NJoin)service.getArg();
                boolean simple = true;
                for (TupleExpr t : j.getArgs()) {
                    if (t instanceof ExclusiveStatement) continue;
                    simple = false;
                    break;
                }
                if (simple) {
                    return new ExclusiveGroup(stmts, source, this.queryInfo);
                }
            }
        }
        return new FedXService(service, this.queryInfo);
    }

    private Endpoint getFedXEndpoint(String serviceUri) {
        EndpointManager em = this.queryInfo.getFederationContext().getEndpointManager();
        Endpoint e = em.getEndpointByUrl(serviceUri);
        if (e != null) {
            return e;
        }
        e = em.getEndpointByName(serviceUri);
        return e;
    }
}

