/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FFTEvaluator
extends RecursiveNumericEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;
    private static List<String> clabels = new ArrayList<String>();

    public FFTEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object v) throws IOException {
        double[] data = ((List)v).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
        FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] complex = fastFourierTransformer.transform(data, TransformType.FORWARD);
        double[] real = new double[complex.length];
        double[] imaginary = new double[complex.length];
        for (int i = 0; i < real.length; ++i) {
            real[i] = complex[i].getReal();
            imaginary[i] = complex[i].getImaginary();
        }
        double[][] d = new double[][]{real, imaginary};
        Matrix matrix = new Matrix(d);
        matrix.setRowLabels(clabels);
        return matrix;
    }

    static {
        clabels.add("real");
        clabels.add("imaginary");
    }
}

