/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.rdf4j.common.io.Sink;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.RDFStarEncodingStatement;

public abstract class AbstractRDFWriter
implements RDFWriter,
Sink {
    protected Map<String, String> namespaceTable = new LinkedHashMap<String, String>();
    private WriterConfig writerConfig = new WriterConfig();
    private boolean writingStarted;
    protected Consumer<Statement> statementConsumer;

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaceTable.put(prefix, uri);
    }

    @Override
    public RDFWriter setWriterConfig(WriterConfig config) {
        this.writerConfig = config;
        return this;
    }

    @Override
    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    @Override
    public FileFormat getFileFormat() {
        return this.getRDFFormat();
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        return Collections.emptyList();
    }

    @Override
    public <T> RDFWriter set(RioSetting<T> setting, T value) {
        this.getWriterConfig().set((RioSetting)setting, (Object)value);
        return this;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RDFHandlerException("Document writing has already started");
        }
        this.writingStarted = true;
        this.statementConsumer = this::consumeStatement;
        if (this.getWriterConfig().get(BasicWriterSettings.CONVERT_RDF_STAR_TO_REIFICATION).booleanValue()) {
            this.statementConsumer = this::handleStatementConvertRDFStar;
        } else if (!this.getRDFFormat().supportsRDFStar() && this.getWriterConfig().get(BasicWriterSettings.ENCODE_RDF_STAR).booleanValue()) {
            this.statementConsumer = this::handleStatementEncodeRDFStar;
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.checkWritingStarted();
        this.statementConsumer.accept(st);
    }

    protected void consumeStatement(Statement st) {
    }

    protected boolean isWritingStarted() {
        return this.writingStarted;
    }

    protected void checkWritingStarted() {
        if (!this.writingStarted) {
            throw new RDFHandlerException("Document writing has not started yet");
        }
    }

    private void handleStatementConvertRDFStar(Statement st) {
        Statements.convertRDFStarToReification(st, this::consumeStatement);
    }

    private void handleStatementEncodeRDFStar(Statement st) {
        Resource s = st.getSubject();
        Value o = st.getObject();
        if (s instanceof Triple || o instanceof Triple) {
            this.consumeStatement(new RDFStarEncodingStatement(st));
        } else {
            this.consumeStatement(st);
        }
    }
}

