/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.Closeable;
import java.io.IOException;
import java.util.IdentityHashMap;
import org.eclipse.rdf4j.common.concurrent.locks.StampedLongAdderLockManager;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;

class TxnManager {
    private final Mode mode;
    private final IdentityHashMap<Txn, Boolean> active = new IdentityHashMap();
    private final long[] pool;
    private final StampedLongAdderLockManager lockManager = new StampedLongAdderLockManager();
    private final long env;
    private volatile int poolIndex = -1;

    TxnManager(long env, Mode mode) {
        this.env = env;
        this.mode = mode;
        this.pool = mode == Mode.RESET ? new long[128] : null;
    }

    private long startReadTxn() throws IOException {
        long readTxn;
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)131072, (PointerBuffer)pp));
            readTxn = pp.get(0);
        }
        return readTxn;
    }

    Txn createTxn(long txn) {
        return new Txn(txn){

            @Override
            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Txn createReadTxn() throws IOException {
        Txn txnRef = new Txn(this.createReadTxnInternal());
        IdentityHashMap<Txn, Boolean> identityHashMap = this.active;
        synchronized (identityHashMap) {
            this.active.put(txnRef, Boolean.TRUE);
        }
        return txnRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createReadTxnInternal() throws IOException {
        long txn = 0L;
        if (this.mode == Mode.RESET) {
            long[] lArray = this.pool;
            synchronized (this.pool) {
                if (this.poolIndex >= 0) {
                    txn = this.pool[this.poolIndex--];
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (txn == 0L) {
                    txn = this.startReadTxn();
                } else {
                    LMDB.mdb_txn_renew((long)txn);
                }
            }
        } else {
            txn = this.startReadTxn();
        }
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T doWith(LmdbUtil.Transaction<T> transaction) throws IOException {
        T ret;
        long readStamp;
        try {
            readStamp = this.lockManager.readLock();
        }
        catch (InterruptedException e) {
            throw new SailException((Throwable)e);
        }
        try (MemoryStack stack = MemoryStack.stackPush();
             Txn txn = this.createReadTxn();){
            ret = transaction.exec(stack, txn.get());
        }
        finally {
            this.lockManager.unlockRead(readStamp);
        }
        return ret;
    }

    StampedLongAdderLockManager lockManager() {
        return this.lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() throws IOException {
        IdentityHashMap<Txn, Boolean> identityHashMap = this.active;
        synchronized (identityHashMap) {
            for (Txn txn : this.active.keySet()) {
                txn.setActive(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() throws IOException {
        IdentityHashMap<Txn, Boolean> identityHashMap = this.active;
        synchronized (identityHashMap) {
            for (Txn txn : this.active.keySet()) {
                txn.setActive(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() throws IOException {
        IdentityHashMap<Txn, Boolean> identityHashMap = this.active;
        synchronized (identityHashMap) {
            for (Txn txn : this.active.keySet()) {
                txn.reset();
            }
        }
    }

    static enum Mode {
        RESET,
        ABORT,
        NONE;

    }

    class Txn
    implements Closeable,
    AutoCloseable {
        private long txn;
        private long version;

        Txn(long txn) {
            this.txn = txn;
        }

        long get() {
            return this.txn;
        }

        StampedLongAdderLockManager lockManager() {
            return TxnManager.this.lockManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void free(long txn) {
            switch (TxnManager.this.mode.ordinal()) {
                case 0: {
                    long[] lArray = TxnManager.this.pool;
                    synchronized (TxnManager.this.pool) {
                        if (TxnManager.this.poolIndex < TxnManager.this.pool.length - 1) {
                            LMDB.mdb_txn_reset((long)txn);
                            TxnManager.this.pool[++TxnManager.this.poolIndex] = txn;
                        } else {
                            LMDB.mdb_txn_abort((long)txn);
                        }
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        break;
                    }
                }
                case 1: {
                    LMDB.mdb_txn_abort((long)txn);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            IdentityHashMap<Txn, Boolean> identityHashMap = TxnManager.this.active;
            synchronized (identityHashMap) {
                TxnManager.this.active.remove(this);
            }
            this.free(this.txn);
        }

        void reset() throws IOException {
            LMDB.mdb_txn_reset((long)this.txn);
            LmdbUtil.E(LMDB.mdb_txn_renew((long)this.txn));
            ++this.version;
        }

        void setActive(boolean active) throws IOException {
            if (active) {
                LmdbUtil.E(LMDB.mdb_txn_renew((long)this.txn));
                ++this.version;
            } else {
                LMDB.mdb_txn_reset((long)this.txn);
            }
        }

        long version() {
            return this.version;
        }
    }
}

