/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.config;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.sail.config.AbstractDelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.shacl.config.ShaclSailSchema;

public class ShaclSailConfig
extends AbstractDelegatingSailImplConfig {
    public static final boolean PARALLEL_VALIDATION_DEFAULT = true;
    public static final boolean LOG_VALIDATION_PLANS_DEFAULT = false;
    public static final boolean LOG_VALIDATION_VIOLATIONS_DEFAULT = false;
    public static final boolean VALIDATION_ENABLED_DEFAULT = true;
    public static final boolean CACHE_SELECT_NODES_DEFAULT = true;
    public static final boolean GLOBAL_LOG_VALIDATION_EXECUTION_DEFAULT = false;
    public static final boolean RDFS_SUB_CLASS_REASONING_DEFAULT = true;
    public static final boolean PERFORMANCE_LOGGING_DEFAULT = false;
    public static final boolean SERIALIZABLE_VALIDATION_DEFAULT = true;
    public static final boolean ECLIPSE_RDF4J_SHACL_EXTENSIONS_DEFAULT = false;
    public static final boolean DASH_DATA_SHAPES_DEFAULT = false;
    public static final long VALIDATION_RESULTS_LIMIT_TOTAL_DEFAULT = 1000000L;
    public static final long VALIDATION_RESULTS_LIMIT_PER_CONSTRAINT_DEFAULT = 1000L;
    public static final long TRANSACTIONAL_VALIDATION_LIMIT_DEFAULT = 500000L;
    public static final Set<IRI> SHAPES_GRAPHS_DEFAULT = Set.of(RDF4J.SHACL_SHAPE_GRAPH);
    private boolean parallelValidation = true;
    private boolean logValidationPlans = false;
    private boolean logValidationViolations = false;
    private boolean validationEnabled = true;
    private boolean cacheSelectNodes = true;
    private boolean globalLogValidationExecution = false;
    private boolean rdfsSubClassReasoning = true;
    private boolean performanceLogging = false;
    private boolean serializableValidation = true;
    private boolean eclipseRdf4jShaclExtensions = false;
    private boolean dashDataShapes = false;
    private long validationResultsLimitTotal = 1000000L;
    private long validationResultsLimitPerConstraint = 1000L;
    private long transactionalValidationLimit = 500000L;
    private Set<IRI> shapesGraphs = SHAPES_GRAPHS_DEFAULT;

    public ShaclSailConfig() {
        super("rdf4j:ShaclSail");
    }

    public ShaclSailConfig(SailImplConfig delegate) {
        super("rdf4j:ShaclSail", delegate);
    }

    public boolean isLogValidationPlans() {
        return this.logValidationPlans;
    }

    public void setLogValidationPlans(boolean logValidationPlans) {
        this.logValidationPlans = logValidationPlans;
    }

    public boolean isLogValidationViolations() {
        return this.logValidationViolations;
    }

    public void setLogValidationViolations(boolean logValidationViolations) {
        this.logValidationViolations = logValidationViolations;
    }

    public boolean isGlobalLogValidationExecution() {
        return this.globalLogValidationExecution;
    }

    public void setGlobalLogValidationExecution(boolean globalLogValidationExecution) {
        this.globalLogValidationExecution = globalLogValidationExecution;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public boolean isParallelValidation() {
        return this.parallelValidation;
    }

    public void setParallelValidation(boolean parallelValidation) {
        this.parallelValidation = parallelValidation;
    }

    public boolean isCacheSelectNodes() {
        return this.cacheSelectNodes;
    }

    public void setCacheSelectNodes(boolean cacheSelectNodes) {
        this.cacheSelectNodes = cacheSelectNodes;
    }

    public boolean isRdfsSubClassReasoning() {
        return this.rdfsSubClassReasoning;
    }

    public void setRdfsSubClassReasoning(boolean rdfsSubClassReasoning) {
        this.rdfsSubClassReasoning = rdfsSubClassReasoning;
    }

    public boolean isPerformanceLogging() {
        return this.performanceLogging;
    }

    public void setPerformanceLogging(boolean performanceLogging) {
        this.performanceLogging = performanceLogging;
    }

    public boolean isSerializableValidation() {
        return this.serializableValidation;
    }

    public void setSerializableValidation(boolean serializableValidation) {
        this.serializableValidation = serializableValidation;
    }

    @Experimental
    public boolean isEclipseRdf4jShaclExtensions() {
        return this.eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public void setEclipseRdf4jShaclExtensions(boolean eclipseRdf4jShaclExtensions) {
        this.eclipseRdf4jShaclExtensions = eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public boolean isDashDataShapes() {
        return this.dashDataShapes;
    }

    @Experimental
    public void setDashDataShapes(boolean dashDataShapes) {
        this.dashDataShapes = dashDataShapes;
    }

    public long getValidationResultsLimitTotal() {
        return this.validationResultsLimitTotal;
    }

    public long getValidationResultsLimitPerConstraint() {
        return this.validationResultsLimitPerConstraint;
    }

    public void setValidationResultsLimitTotal(long validationResultsLimitTotal) {
        this.validationResultsLimitTotal = validationResultsLimitTotal;
    }

    public void setValidationResultsLimitPerConstraint(long validationResultsLimitPerConstraint) {
        this.validationResultsLimitPerConstraint = validationResultsLimitPerConstraint;
    }

    public long getTransactionalValidationLimit() {
        return this.transactionalValidationLimit;
    }

    public void setTransactionalValidationLimit(long transactionalValidationLimit) {
        this.transactionalValidationLimit = transactionalValidationLimit;
    }

    public Set<IRI> getShapesGraphs() {
        return this.shapesGraphs;
    }

    public void setShapesGraphs(Set<IRI> shapesGraphs) {
        this.shapesGraphs = shapesGraphs;
    }

    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace(CONFIG.NS);
        m.add(implNode, CONFIG.Shacl.parallelValidation, (Value)BooleanLiteral.valueOf((boolean)this.isParallelValidation()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.logValidationPlans, (Value)BooleanLiteral.valueOf((boolean)this.isLogValidationPlans()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.logValidationViolations, (Value)BooleanLiteral.valueOf((boolean)this.isLogValidationViolations()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.validationEnabled, (Value)BooleanLiteral.valueOf((boolean)this.isValidationEnabled()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.cacheSelectNodes, (Value)BooleanLiteral.valueOf((boolean)this.isCacheSelectNodes()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.globalLogValidationExecution, (Value)BooleanLiteral.valueOf((boolean)this.isGlobalLogValidationExecution()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.rdfsSubClassReasoning, (Value)BooleanLiteral.valueOf((boolean)this.isRdfsSubClassReasoning()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.performanceLogging, (Value)BooleanLiteral.valueOf((boolean)this.isPerformanceLogging()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.serializableValidation, (Value)BooleanLiteral.valueOf((boolean)this.isSerializableValidation()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.eclipseRdf4jShaclExtensions, (Value)BooleanLiteral.valueOf((boolean)this.isEclipseRdf4jShaclExtensions()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.dashDataShapes, (Value)BooleanLiteral.valueOf((boolean)this.isDashDataShapes()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.validationResultsLimitTotal, (Value)Values.literal((long)this.getValidationResultsLimitTotal()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.validationResultsLimitPerConstraint, (Value)Values.literal((long)this.getValidationResultsLimitPerConstraint()), new Resource[0]);
        m.add(implNode, CONFIG.Shacl.transactionalValidationLimit, (Value)Values.literal((long)this.getTransactionalValidationLimit()), new Resource[0]);
        for (IRI shapesGraph : this.shapesGraphs) {
            m.add(implNode, CONFIG.Shacl.shapesGraph, (Value)shapesGraph, new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.parallelValidation, (IRI)ShaclSailSchema.PARALLEL_VALIDATION).ifPresent(l -> this.setParallelValidation(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.logValidationPlans, (IRI)ShaclSailSchema.LOG_VALIDATION_PLANS).ifPresent(l -> this.setLogValidationPlans(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.logValidationViolations, (IRI)ShaclSailSchema.LOG_VALIDATION_VIOLATIONS).ifPresent(l -> this.setLogValidationViolations(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.validationEnabled, (IRI)ShaclSailSchema.VALIDATION_ENABLED).ifPresent(l -> this.setValidationEnabled(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.cacheSelectNodes, (IRI)ShaclSailSchema.CACHE_SELECT_NODES).ifPresent(l -> this.setCacheSelectNodes(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.globalLogValidationExecution, (IRI)ShaclSailSchema.GLOBAL_LOG_VALIDATION_EXECUTION).ifPresent(l -> this.setGlobalLogValidationExecution(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.rdfsSubClassReasoning, (IRI)ShaclSailSchema.RDFS_SUB_CLASS_REASONING).ifPresent(l -> this.setRdfsSubClassReasoning(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.performanceLogging, (IRI)ShaclSailSchema.PERFORMANCE_LOGGING).ifPresent(l -> this.setPerformanceLogging(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.serializableValidation, (IRI)ShaclSailSchema.SERIALIZABLE_VALIDATION).ifPresent(l -> this.setSerializableValidation(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.eclipseRdf4jShaclExtensions, (IRI)ShaclSailSchema.ECLIPSE_RDF4J_SHACL_EXTENSIONS).ifPresent(l -> this.setEclipseRdf4jShaclExtensions(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.dashDataShapes, (IRI)ShaclSailSchema.DASH_DATA_SHAPES).ifPresent(l -> this.setDashDataShapes(l.booleanValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.validationResultsLimitTotal, (IRI)ShaclSailSchema.VALIDATION_RESULTS_LIMIT_TOTAL).ifPresent(l -> this.setValidationResultsLimitTotal(l.longValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.validationResultsLimitPerConstraint, (IRI)ShaclSailSchema.VALIDATION_RESULTS_LIMIT_PER_CONSTRAINT).ifPresent(l -> this.setValidationResultsLimitPerConstraint(l.longValue()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.transactionalValidationLimit, (IRI)ShaclSailSchema.TRANSACTIONAL_VALIDATION_LIMIT).ifPresent(l -> this.setTransactionalValidationLimit(l.longValue()));
            if (m.contains(implNode, CONFIG.Shacl.shapesGraph, null, new Resource[0]) || m.contains(implNode, ShaclSailSchema.SHAPES_GRAPH, null, new Resource[0])) {
                this.setShapesGraphs(Configurations.getPropertyValues((Model)m, (Resource)implNode, (IRI)CONFIG.Shacl.shapesGraph, (IRI)ShaclSailSchema.SHAPES_GRAPH).stream().peek(v -> {
                    if (!v.isIRI()) {
                        throw new IllegalArgumentException("Expected IRI but found " + v.getClass().getSimpleName() + "for value " + v.stringValue());
                    }
                }).map(o -> (IRI)o).collect(Collectors.toUnmodifiableSet()));
            }
        }
        catch (IllegalArgumentException e) {
            throw new SailConfigException("error parsing Sail configuration", (Throwable)e);
        }
    }
}

