/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks.diagnostics;

import java.lang.ref.Cleaner;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockMonitoring;
import org.slf4j.Logger;

@InternalUseOnly
public class LockCleaner<T extends Lock>
implements LockMonitoring<T> {
    private static final ConcurrentCleaner cleaner = new ConcurrentCleaner();
    private final Logger logger;
    private final Lock.ExtendedSupplier<T> supplier;
    private final String alias;
    private final boolean stacktrace;

    public LockCleaner(boolean stacktrace, String alias, Logger logger, Lock.ExtendedSupplier<T> supplier) {
        this.stacktrace = stacktrace;
        this.supplier = supplier;
        this.logger = logger;
        this.alias = alias;
    }

    @Override
    public Lock getLock() throws InterruptedException {
        return this.getLockInner(this.supplier.getLock());
    }

    @Override
    public Lock tryLock() {
        T lock = this.supplier.tryLock();
        if (lock != null) {
            return this.getLockInner(lock);
        }
        return null;
    }

    @Override
    public T unsafeInnerLock(Lock lock) {
        if (lock instanceof CleanableLock) {
            return ((CleanableLock)lock).state.lock;
        }
        throw new IllegalArgumentException("Supplied lock is not instanceof CleanableLock");
    }

    @Override
    public Lock register(T lock) {
        return this.getLockInner(lock);
    }

    @Override
    public void unregister(Lock lock) {
        assert (!lock.isActive());
        if (!(lock instanceof CleanableLock)) {
            throw new IllegalArgumentException("Supplied lock is not instanceof CleanableLock");
        }
        ((CleanableLock)lock).cleanable.clean();
    }

    private CleanableLock<T> getLockInner(T lock) {
        if (this.stacktrace) {
            return new CleanableLock<T>(cleaner, lock, this.alias, this.logger, Thread.currentThread(), new Throwable("\"" + this.alias + "\" lock acquired in " + Thread.currentThread().getName()));
        }
        return new CleanableLock<T>(cleaner, lock, this.alias, this.logger, null, null);
    }

    public static class CleanableLock<T extends Lock>
    implements Lock {
        private final Cleaner.Cleanable cleanable;
        private final State<T> state;

        public CleanableLock(ConcurrentCleaner cleaner, T lock, String alias, Logger logger, Thread thread, Throwable throwable) {
            this.state = new State<T>(lock, alias, logger, thread, throwable);
            this.cleanable = cleaner.register(this, this.state);
        }

        @Override
        public boolean isActive() {
            return this.state.lock.isActive();
        }

        @Override
        public void release() {
            this.state.lock.release();
            this.cleanable.clean();
        }

        static class State<T extends Lock>
        implements Runnable {
            private final T lock;
            private final String alias;
            private final Logger logger;
            private final Thread thread;
            private final Throwable stack;

            public State(T lock, String alias, Logger logger, Thread thread, Throwable stack) {
                this.lock = lock;
                this.alias = alias;
                this.logger = logger;
                this.thread = thread;
                this.stack = stack;
            }

            @Override
            public void run() {
                if (this.lock.isActive()) {
                    if (this.stack == null) {
                        this.logger.warn("\"{}\" lock abandoned; consider setting the {} system property", (Object)this.alias, (Object)"info.aduna.concurrent.locks.trackLocks");
                    } else {
                        this.logger.warn("\"{}\" lock abandoned; lock was acquired in {}", new Object[]{this.alias, this.thread.getName(), this.stack});
                    }
                    this.lock.release();
                }
            }
        }
    }
}

