/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.util;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.locationtech.spatial4j.distance.DistanceUtils;

public final class GeoUnits {
    private GeoUnits() {
    }

    public static final double toMiles(double distance, IRI units) {
        double miles;
        if (GEOF.UOM_METRE.equals(units)) {
            miles = 0.621371192 * distance / 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            miles = DistanceUtils.degrees2Dist((double)distance, (double)3958.7613145272735);
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            miles = DistanceUtils.radians2Dist((double)distance, (double)3958.7613145272735);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            miles = distance * Math.PI * 3958.7613145272735;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + String.valueOf(units));
        }
        return miles;
    }

    public static final double fromMiles(double miles, IRI units) {
        double dist;
        if (GEOF.UOM_METRE.equals(units)) {
            dist = 1.6093440006146922 * miles * 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            dist = DistanceUtils.dist2Degrees((double)miles, (double)3958.7613145272735);
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            dist = DistanceUtils.dist2Radians((double)miles, (double)3958.7613145272735);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            dist = miles / 12436.815463034354;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + String.valueOf(units));
        }
        return dist;
    }

    public static final double toKilometres(double distance, IRI units) {
        double kms;
        if (GEOF.UOM_METRE.equals(units)) {
            kms = distance / 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            kms = DistanceUtils.degrees2Dist((double)distance, (double)6371.0087714);
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            kms = DistanceUtils.radians2Dist((double)distance, (double)6371.0087714);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            kms = distance * Math.PI * 6371.0087714;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + String.valueOf(units));
        }
        return kms;
    }

    public static final double fromKilometres(double kms, IRI units) {
        double dist;
        if (GEOF.UOM_METRE.equals(units)) {
            dist = kms * 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            dist = DistanceUtils.dist2Degrees((double)kms, (double)6371.0087714);
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            dist = DistanceUtils.dist2Radians((double)kms, (double)6371.0087714);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            dist = kms / 20015.114352186374;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + String.valueOf(units));
        }
        return dist;
    }

    public static final double toDegrees(double distance, IRI units) {
        double degs;
        if (GEOF.UOM_METRE.equals(units)) {
            degs = DistanceUtils.dist2Degrees((double)(distance / 1000.0), (double)6371.0087714);
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            degs = distance;
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            degs = 57.29577951308232 * distance;
        } else if (GEOF.UOM_UNITY.equals(units)) {
            degs = distance * 180.0;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + String.valueOf(units));
        }
        return degs;
    }

    public static final double fromDegrees(double degs, IRI units) {
        double dist;
        if (GEOF.UOM_METRE.equals(units)) {
            dist = DistanceUtils.degrees2Dist((double)degs, (double)6371.0087714) * 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            dist = degs;
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            dist = Math.PI / 180 * degs;
        } else if (GEOF.UOM_UNITY.equals(units)) {
            dist = degs / 180.0;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + String.valueOf(units));
        }
        return dist;
    }
}

