/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.equinox.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.ProgressUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.equinox.EquinoxFrameworkInstance;
import org.eclipse.libra.framework.equinox.IEquinoxFrameworkInstance;
import org.eclipse.libra.framework.equinox.IEquinoxVersionHandler;
import org.eclipse.libra.framework.equinox.Messages;
import org.eclipse.libra.framework.equinox.internal.EquinoxConfigurationPublishHelper;
import org.eclipse.wst.server.core.IModule;

public class EquinoxFrameworkInstanceBehavior
extends OSGIFrameworkInstanceBehaviorDelegate {
    protected transient EquinoxConfigurationPublishHelper publishHelper = new EquinoxConfigurationPublishHelper(this);

    public IEquinoxVersionHandler getEquinoxVersionHandler() {
        return this.getEquinoxRuntimeInstance().getEquinoxVersionHandler();
    }

    public EquinoxFrameworkInstance getEquinoxRuntimeInstance() {
        return (EquinoxFrameworkInstance)this.getServer().loadAdapter(EquinoxFrameworkInstance.class, null);
    }

    public String getFrameworkClass() {
        return this.getEquinoxVersionHandler().getFrameworkClass();
    }

    public String[] getFrameworkProgramArguments(boolean starting) {
        return this.getEquinoxVersionHandler().getFrameworkProgramArguments(this.getBaseDirectory(), this.getFrameworkInstance().isDebug(), starting);
    }

    public String[] getExcludedFrameworkProgramArguments(boolean starting) {
        return this.getEquinoxVersionHandler().getExcludedFrameworkProgramArguments(this.getFrameworkInstance().isDebug(), starting);
    }

    public String[] getFrameworkVMArguments() {
        IPath deployPath;
        IPath installPath = this.getServer().getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        if (!(deployPath = this.getBaseDirectory()).isAbsolute()) {
            try {
                String deployLoc = new File(deployPath.toOSString()).getCanonicalPath();
                deployPath = new Path(deployLoc);
            }
            catch (IOException iOException) {}
        }
        String javaProfileID = ((IEquinoxFrameworkInstance)this.getFrameworkInstance()).getJavaPofile();
        int jmxPort = ((IEquinoxFrameworkInstance)this.getFrameworkInstance()).getJMXPort();
        boolean jmxEnabled = ((IEquinoxFrameworkInstance)this.getFrameworkInstance()).getJMXEnabled();
        return this.getEquinoxVersionHandler().getFrameworkVMArguments(installPath, jmxEnabled, jmxPort, javaProfileID, null, deployPath, false);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getRuntime() == null) {
            return;
        }
        IPath confDir = this.getBaseDirectory();
        IStatus status = this.getEquinoxVersionHandler().prepareDeployDirectory(confDir);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        monitor.beginTask(Messages.publishServerTask, 600);
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        IPath confDir = this.getBaseDirectory();
        try {
            FrameworkInstanceConfiguration equinoxConfiguration = this.getEquinoxRuntimeInstance().getEquinoxConfiguration();
            this.publishHelper.exportBundles(modules, equinoxConfiguration, confDir);
            String frameworkJarPath = "reference:file:" + this.getEquinoxRuntimeInstance().getFrameworkJarPath();
            this.getEquinoxVersionHandler().prepareFrameworkConfigurationFile(confDir, this.publishHelper.getServerModules(modules, "reference:file:", " "), frameworkJarPath, this.publishHelper.getTargetBundles(equinoxConfiguration));
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Publishing failed", (Throwable)e);
        }
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getServerState() != 4 && (deltaKind == 1 || deltaKind == 3)) {
            this.setServerRestartState(true);
        }
        Properties p = this.loadModulePublishLocations();
        this.setModulePublishState(moduleTree, 1);
        this.saveModulePublishLocations(p);
    }
}

