/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialogInternal;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget.ETypedElementSelectionControlManager;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget.IETypedElementSelectionControlManager;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ETypedElementSelectionDialog<T2, D>
extends SelectionStatusDialog
implements IETypedElementSelectionDialogInternal<D> {
    private static final int DEFAULT_WIDTH = 550;
    private static final int DEFAULT_HEIGHT = 550;
    private final boolean allowEmpty;
    private final IDialogCallbackWithPreCommit<List<ETypedElement>, T2, D> callback;
    private final Collection<? extends ETypedElement> availableElements;
    private final int selectionMaxSize;
    private final ICustomizationManager customManager;
    private IETypedElementSelectionControlManager manager;
    private final Collection<? extends EPackage> knownEPackage;

    public ETypedElementSelectionDialog(Collection<? extends ETypedElement> eTypedElements, int selectionMaxSize, boolean allowEmpty, IDialogCallbackWithPreCommit<List<ETypedElement>, T2, D> callback, Shell parentShell, ICustomizationManager customManager, Collection<? extends EPackage> knownEPackage) {
        super(parentShell);
        this.availableElements = eTypedElements;
        this.selectionMaxSize = selectionMaxSize;
        this.allowEmpty = allowEmpty;
        this.callback = callback;
        this.customManager = customManager;
        this.knownEPackage = knownEPackage;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.manager = new ETypedElementSelectionControlManager(composite, this.selectionMaxSize, this.allowEmpty, this.customManager, this.knownEPackage);
        this.manager.createContents();
        this.manager.setAvailableETypedElements(this.availableElements);
        this.manager.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ETypedElementSelectionDialog.this.okPressed();
            }
        });
        this.manager.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ETypedElementSelectionDialog.this.updateValidationStatus();
            }
        });
        return composite;
    }

    protected void updateValidationStatus() {
        this.updateStatus(this.manager.getValidationStatus());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.selectionMaxSize > 1) {
            shell.setText(Messages.ETypedElementSelectionDialog_dialogTitleMultiSelection);
        } else {
            shell.setText(Messages.ETypedElementSelectionDialog_dialogTitle);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(this.getClass().getName()) + ".settings";
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
            section.put("DIALOG_WIDTH", 550);
            section.put("DIALOG_HEIGHT", 550);
        }
        return section;
    }

    public boolean isErrorStatus() {
        IStatus validationStatus = this.manager.getValidationStatus();
        return validationStatus == null || validationStatus.getSeverity() >= 4;
    }

    protected void okPressed() {
        if (this.isErrorStatus()) {
            throw new IllegalStateException("The current selection is not valid");
        }
        super.okPressed();
    }

    @Override
    public D pressOk() {
        this.okPressed();
        return null;
    }

    @Override
    public void pressCancel() {
        this.setReturnCode(1);
        this.close();
    }

    public boolean close() {
        boolean result = super.close();
        this.invokeCallback();
        return result;
    }

    private void invokeCallback() {
        if (this.callback == null) {
            return;
        }
        if (this.getReturnCode() == 0) {
            this.callback.committed(this.getSelectedETypedElements(), null);
        }
    }

    @Override
    public List<ETypedElement> getSelectedETypedElements() {
        List<Object> currentlySelected = new ArrayList();
        if (this.manager.isDisposed()) {
            Object[] result = this.getResult();
            if (result == null) {
                throw new UnsupportedOperationException("No selection available because the dialog was canceled");
            }
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object current = objectArray[n2];
                currentlySelected.add((ETypedElement)current);
                ++n2;
            }
        } else {
            currentlySelected = this.manager.computeResult();
        }
        return Collections.unmodifiableList(currentlySelected);
    }

    @Override
    public ETypedElement getFirstSelectedETypedElement() {
        ETypedElement result = null;
        List<ETypedElement> typedElements = this.getSelectedETypedElements();
        if (typedElements != null && !typedElements.isEmpty()) {
            result = typedElements.get(0);
        }
        return result;
    }

    @Override
    public void setSelectedETypedElements(List<? extends ETypedElement> newSelection) {
        if (newSelection == null) {
            throw new IllegalArgumentException();
        }
        this.manager.setSelectedETypedElements(newSelection);
        this.updateValidationStatus();
    }

    public void setSelection(IStructuredSelection selection) {
        this.manager.setSelection(selection);
        this.updateValidationStatus();
    }

    protected void computeResult() {
        List<ETypedElement> currentSelection = this.manager.computeResult();
        this.setResult(currentSelection);
    }

    @Override
    public boolean isOkButtonEnabled() {
        return this.getOkButton().isEnabled();
    }
}

