/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rpmstubby.AbstractGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.model.PomModel;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StubbyPomGenerator
extends AbstractGenerator {
    private PomModel model;

    public StubbyPomGenerator(IFile pomFile) {
        this.parse(pomFile);
        this.specfileName = String.valueOf(this.model.getPackageName().toLowerCase()) + ".spec";
        this.projectName = pomFile.getProject().getName();
    }

    private void parse(IFile pomFile) {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
            Document docroot = docbuilder.parse(pomFile.getContents());
            this.model = new PomModel(docroot);
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            StubbyLog.logError(e);
        }
    }

    @Override
    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        String packageName = this.model.getPackageName();
        buffer.append("Name:           " + packageName.toLowerCase() + "\n");
        buffer.append("Version:        " + this.model.getVersion() + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n\n");
        buffer.append("Group:          Development/Libraries\n");
        buffer.append("License:        " + this.model.getLicense() + "\n");
        buffer.append("URL:            " + this.model.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n");
        buffer.append("BuildArch: noarch\n\n");
        this.generateRequires(buffer);
        buffer.append("\n%description\n" + this.model.getDescription() + "\n\n");
        StubbyPomGenerator.generateJavadocSubpackage(buffer);
        StubbyPomGenerator.generatePrepSection(buffer);
        StubbyPomGenerator.generateBuildSection(buffer);
        StubbyPomGenerator.generateInstallSection(buffer);
        StubbyPomGenerator.generateFilesSections(buffer);
        StubbyPomGenerator.generateChangelog(buffer);
        return buffer.toString();
    }

    private void generateRequires(StringBuilder buffer) {
        for (Map.Entry<String, String> entry : this.model.getDependencies().entrySet()) {
            buffer.append("BuildRequires: mvn(" + entry.getKey() + ":" + entry.getValue() + ")\n");
        }
        buffer.append("BuildRequires: maven-local\n");
    }

    private static void generateJavadocSubpackage(StringBuilder buffer) {
        buffer.append("%package javadoc\n");
        buffer.append("Group:          Documentation\n");
        buffer.append("Summary:        Javadoc for %{name}\n\n");
        buffer.append("%description javadoc\n");
        buffer.append("API documentation for %{name}.\n\n");
    }

    private static void generateInstallSection(StringBuilder buffer) {
        buffer.append("%install\n");
        buffer.append("%mvn_install\n\n");
    }

    private static void generateFilesSections(StringBuilder buffer) {
        buffer.append("%files -f .mfiles\n");
        buffer.append("%dir %{_javadir}/%{name}\n\n");
        buffer.append("%files javadoc -f .mfiles-javadoc\n\n");
    }

    private static void generatePrepSection(StringBuilder buffer) {
        buffer.append("\n%prep\n");
        buffer.append("%setup -q #You may need to update this according to your Source0\n\n");
    }

    private static void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        buffer.append("%mvn_build\n\n");
    }
}

