/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpmstubby;

import org.eclipse.core.resources.IFile;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyEggGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyGemGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyMakefilePLGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyPomGenerator;
import org.eclipse.linuxtools.rpmstubby.InputType;

public class Generator {
    private InputType type;

    public Generator(InputType type) {
        this.type = type;
    }

    public void generate(IFile file) {
        switch (this.type) {
            case ECLIPSE_FEATURE: {
                new StubbyGenerator(file).writeContent();
                break;
            }
            case MAVEN_POM: {
                new StubbyPomGenerator(file).writeContent();
                break;
            }
            case PYTHON_EGG: {
                new StubbyEggGenerator(file).writeContent();
                break;
            }
            case RUBY_GEM: {
                new StubbyGemGenerator(file).writeContent();
                break;
            }
            case PERL_MAKEFILE: {
                new StubbyMakefilePLGenerator(file).writeContent();
                break;
            }
        }
    }
}

