import { Hover, Position, MarkupKind } from 'vscode-languageserver-types';
import { MarkdownDocumentation } from './dockerMarkdown';
import { PlainTextDocumentation } from './dockerPlainText';
export declare class DockerHover {
    private markdown;
    private plainText;
    constructor(markdown: MarkdownDocumentation, plainText: PlainTextDocumentation);
    onHover(content: string, position: Position, markupKind: MarkupKind[]): Hover | null;
    /**
     * Analyzes the Dockerfile at the given position to determine if the user
     * is hovering over a keyword, a flag, or a directive.
     *
     * @param dockerfile the Dockerfile to check
     * @param position the place that the user is hovering over
     * @return the string key value for the keyword, flag, or directive that's
     *         being hovered over, or null if the user isn't hovering over
     *         such a word
     */
    private computeHoverKey;
    private getFlagsHover;
}
