/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IAnchorableFigure;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.geometry.RectangleUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.geometry.Segment;

public class FixEdgeAnchorAfterCreationCommand
extends AbstractTransactionalCommand {
    private static final String RECT_RIGHT_MIDDLE_ANCHOR = "(1.0,0.5)";
    private static final String RECT_BOTTOM_MIDDLE_ANCHOR = "(0.5,1.0)";
    protected CreateConnectionViewRequest request;

    public FixEdgeAnchorAfterCreationCommand(TransactionalEditingDomain editingDomain, CreateConnectionViewRequest request) {
        super(editingDomain, "Fix Edge Anchor after creation", null);
        this.request = request;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CreateConnectionViewRequest.ConnectionViewDescriptor connectionViewDescriptor = this.request.getConnectionViewDescriptor();
        Edge createdEdge = (Edge)connectionViewDescriptor.getAdapter(View.class);
        IAdaptable adaptable = connectionViewDescriptor.getElementAdapter();
        CreateRelationshipRequest createRelationShipRequest = (CreateRelationshipRequest)adaptable.getAdapter(CreateRelationshipRequest.class);
        Map requestParameters = createRelationShipRequest.getParameters();
        IFigure sourceFigure = (IFigure)requestParameters.get("EDGE_SOURCE_FIGURE");
        IFigure targetFigure = (IFigure)requestParameters.get("EDGE_TARGET_FIGURE");
        Point sourcePoint = (Point)requestParameters.get("EDGE_SOURCE_POINT");
        Point targetPoint = (Point)requestParameters.get("EDGE_TARGET_POINT");
        if (createdEdge != null && sourceFigure instanceof IAnchorableFigure && targetFigure instanceof IAnchorableFigure && sourcePoint != null && targetPoint != null) {
            String targetTerminal;
            String sourceTerminal;
            if (sourceFigure == targetFigure) {
                sourceTerminal = RECT_RIGHT_MIDDLE_ANCHOR.toString();
                targetTerminal = RECT_BOTTOM_MIDDLE_ANCHOR.toString();
            } else {
                Rectangle sourceBds = sourceFigure.getBounds().getCopy();
                Rectangle targetBds = targetFigure.getBounds().getCopy();
                sourceFigure.translateToAbsolute((Translatable)sourceBds);
                targetFigure.translateToAbsolute((Translatable)targetBds);
                Segment segment = new Segment(sourcePoint, targetPoint);
                PrecisionPoint realSourcePoint = RectangleUtils.getIntersectionPoint(sourceBds, segment);
                PrecisionPoint realTargetPoint = RectangleUtils.getIntersectionPoint(targetBds, segment);
                BaseSlidableAnchor anchorSource = (BaseSlidableAnchor)((IAnchorableFigure)sourceFigure).getSourceConnectionAnchorAt((Point)realSourcePoint);
                sourceTerminal = anchorSource.getTerminal();
                BaseSlidableAnchor anchorTarget = (BaseSlidableAnchor)((IAnchorableFigure)targetFigure).getTargetConnectionAnchorAt((Point)realTargetPoint);
                targetTerminal = anchorTarget.getTerminal();
            }
            IdentityAnchor sourceAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
            sourceAnchor.setId(sourceTerminal);
            createdEdge.setSourceAnchor((Anchor)sourceAnchor);
            IdentityAnchor targetAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
            targetAnchor.setId(targetTerminal);
            createdEdge.setTargetAnchor((Anchor)targetAnchor);
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newOKCommandResult();
    }

    protected void cleanup() {
        this.request = null;
        super.cleanup();
    }

    public boolean canExecute() {
        return super.canExecute() && this.request != null;
    }
}

