/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LabelTab
extends ExampleTab {
    private Label varSizeLabel;
    private Label fixedSizeLabel;
    private final Image image1;
    private final Image image2;
    private final String text1;
    private final String text2;
    private Image labelImage;
    private String labelText;

    public LabelTab(CTabFolder topFolder) {
        super(topFolder, "Label");
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.image1 = Graphics.getImage((String)"resources/button-image.gif", (ClassLoader)classLoader);
        this.image2 = Graphics.getImage((String)"resources/newfile_wiz.gif", (ClassLoader)classLoader);
        this.text1 = "Some Text";
        this.text2 = "Some Other Text";
        this.labelImage = null;
        this.labelText = "A Label with text";
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("SEPARATOR", 2);
        this.createStyleButton("HORIZONTAL", 256);
        this.createStyleButton("VERTICAL", 512);
        this.createStyleButton("SHADOW_IN", 4);
        this.createStyleButton("SHADOW_OUT", 8);
        this.createStyleButton("SHADOW_NONE", 32);
        this.createStyleButton("LEFT", 16384);
        this.createStyleButton("CENTER", 0x1000000);
        this.createStyleButton("RIGHT", 131072);
        this.createStyleButton("WRAP", 64);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createCursorCombo();
        this.createChangeTextControl(parent);
        this.createChangeToolTipControl(parent);
    }

    protected void createExampleControls(Composite parent) {
        int style = this.getStyle();
        RowLayout rowLayout = new RowLayout(512);
        parent.setLayout((Layout)rowLayout);
        this.fixedSizeLabel = new Label(parent, style);
        this.fixedSizeLabel.setText("Fixed size Label with some very long text\nand another line");
        this.fixedSizeLabel.setLayoutData((Object)new RowData(100, 100));
        new Label(parent, 0);
        this.varSizeLabel = new Label(parent, style);
        this.registerControl((Control)this.varSizeLabel);
        this.registerControl((Control)this.fixedSizeLabel);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new FillLayout());
        Button text1Button = new Button(buttons, 8);
        text1Button.setText("Text 1");
        text1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelTab.this.labelText = LabelTab.this.text1;
                LabelTab.this.labelImage = null;
                LabelTab.this.updateLabel(LabelTab.this.varSizeLabel);
            }
        });
        Button text2Button = new Button(buttons, 8);
        text2Button.setText("Text 2");
        text2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelTab.this.labelText = LabelTab.this.text2;
                LabelTab.this.labelImage = null;
                LabelTab.this.updateLabel(LabelTab.this.varSizeLabel);
            }
        });
        Button image1Button = new Button(buttons, 8);
        image1Button.setText("Image 1");
        image1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelTab.this.labelImage = LabelTab.this.image1;
                LabelTab.this.updateLabel(LabelTab.this.varSizeLabel);
            }
        });
        Button image2Button = new Button(buttons, 8);
        image2Button.setText("Image 2");
        image2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelTab.this.labelImage = LabelTab.this.image2;
                LabelTab.this.updateLabel(LabelTab.this.varSizeLabel);
            }
        });
        this.updateLabel(this.varSizeLabel);
    }

    private void createChangeTextControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Change text");
        final Text text = new Text(composite, 2048);
        Button button = new Button(composite, 8);
        button.setText("Change");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LabelTab.this.varSizeLabel.setText(text.getText());
                text.setText("");
                LabelTab.this.varSizeLabel.pack();
            }
        });
    }

    private void createChangeToolTipControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Change tooltip");
        final Text text = new Text(composite, 2048);
        Button button = new Button(composite, 8);
        button.setText("Change");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LabelTab.this.varSizeLabel.setToolTipText(text.getText());
            }
        });
    }

    private void updateLabel(Label label) {
        if (this.labelImage != null) {
            label.setImage(this.labelImage);
        } else {
            label.setText(this.labelText);
        }
        label.pack();
    }
}

