/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.presentation;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

class ActionBarButton
extends MouseAdapter
implements IPropertyChangeListener {
    private final Action action;
    private final Label label;

    ActionBarButton(Action action, Composite actionBar) {
        this.action = action;
        this.label = new Label(actionBar, 0);
        this.label.setText(action.getText());
        FontData fontData = this.label.getFont().getFontData()[0];
        this.label.setFont(Graphics.getFont((String)fontData.getName(), (int)(fontData.getHeight() + 2), (int)fontData.getStyle()));
        this.label.pack();
        action.addPropertyChangeListener((IPropertyChangeListener)this);
        this.adjustEnablement(action.isEnabled());
    }

    public void mouseUp(MouseEvent event) {
        this.run();
    }

    public void run() {
        this.action.run();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("enabled".equals(event.getProperty())) {
            this.adjustEnablement((Boolean)event.getNewValue());
        }
    }

    private void adjustEnablement(boolean booleanValue) {
        if (booleanValue) {
            this.label.addMouseListener((MouseListener)this);
            this.label.setForeground(Graphics.getColor((int)255, (int)255, (int)255));
        } else {
            this.label.removeMouseListener((MouseListener)this);
            this.label.setForeground(Graphics.getColor((int)192, (int)192, (int)192));
        }
    }
}

