/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.DefaultsDescriptor;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.OverrideDescriptor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;
import org.eclipse.jetty.xml.XmlParser;

public class StandardDescriptorProcessor
extends IterativeDescriptorProcessor {
    private static final Logger LOG = Log.getLogger(StandardDescriptorProcessor.class);
    public static final String STANDARD_PROCESSOR = "org.eclipse.jetty.standardDescriptorProcessor";

    public StandardDescriptorProcessor() {
        try {
            this.registerVisitor("context-param", this.getClass().getDeclaredMethod("visitContextParam", __signature));
            this.registerVisitor("display-name", this.getClass().getDeclaredMethod("visitDisplayName", __signature));
            this.registerVisitor("servlet", this.getClass().getDeclaredMethod("visitServlet", __signature));
            this.registerVisitor("servlet-mapping", this.getClass().getDeclaredMethod("visitServletMapping", __signature));
            this.registerVisitor("session-config", this.getClass().getDeclaredMethod("visitSessionConfig", __signature));
            this.registerVisitor("mime-mapping", this.getClass().getDeclaredMethod("visitMimeMapping", __signature));
            this.registerVisitor("welcome-file-list", this.getClass().getDeclaredMethod("visitWelcomeFileList", __signature));
            this.registerVisitor("locale-encoding-mapping-list", this.getClass().getDeclaredMethod("visitLocaleEncodingList", __signature));
            this.registerVisitor("error-page", this.getClass().getDeclaredMethod("visitErrorPage", __signature));
            this.registerVisitor("taglib", this.getClass().getDeclaredMethod("visitTagLib", __signature));
            this.registerVisitor("jsp-config", this.getClass().getDeclaredMethod("visitJspConfig", __signature));
            this.registerVisitor("security-constraint", this.getClass().getDeclaredMethod("visitSecurityConstraint", __signature));
            this.registerVisitor("login-config", this.getClass().getDeclaredMethod("visitLoginConfig", __signature));
            this.registerVisitor("security-role", this.getClass().getDeclaredMethod("visitSecurityRole", __signature));
            this.registerVisitor("filter", this.getClass().getDeclaredMethod("visitFilter", __signature));
            this.registerVisitor("filter-mapping", this.getClass().getDeclaredMethod("visitFilterMapping", __signature));
            this.registerVisitor("listener", this.getClass().getDeclaredMethod("visitListener", __signature));
            this.registerVisitor("distributable", this.getClass().getDeclaredMethod("visitDistributable", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start(WebAppContext context, Descriptor descriptor) {
    }

    @Override
    public void end(WebAppContext context, Descriptor descriptor) {
    }

    public void visitContextParam(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        Origin o = context.getMetaData().getOrigin("context-param." + name);
        switch (o) {
            case NotSet: {
                context.getInitParams().put(name, value);
                context.getMetaData().setOrigin("context-param." + name, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                context.getInitParams().put(name, value);
                context.getMetaData().setOrigin("context-param." + name, descriptor);
                break;
            }
            case WebFragment: {
                if (!(descriptor instanceof FragmentDescriptor) || ((String)context.getInitParams().get(name)).equals(value)) break;
                throw new IllegalStateException("Conflicting context-param " + name + "=" + value + " in " + descriptor.getResource());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContextParam: " + name + "=" + value, new Object[0]);
        }
    }

    protected void visitDisplayName(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        if (!(descriptor instanceof FragmentDescriptor)) {
            context.setDisplayName(node.toString(false, true));
            context.getMetaData().setOrigin("display-name", descriptor);
        }
    }

    protected void visitServlet(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node multipart;
        String enabled;
        String async;
        Origin o;
        String roleName;
        XmlParser.Node startup;
        String jsp_file;
        String id = node.getAttribute("id");
        String servlet_name = node.getString("servlet-name", false, true);
        ServletHolder holder = context.getServletHandler().getServlet(servlet_name);
        if (holder == null) {
            holder = context.getServletHandler().newServletHolder(Holder.Source.DESCRIPTOR);
            holder.setName(servlet_name);
            context.getServletHandler().addServlet(holder);
        }
        Iterator iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            Origin origin = context.getMetaData().getOrigin(servlet_name + ".servlet.init-param." + pname);
            switch (origin) {
                case NotSet: {
                    holder.setInitParameter(pname, pvalue);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.init-param." + pname, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setInitParameter(pname, pvalue);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.init-param." + pname, descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.getInitParameter(pname).equals(pvalue)) break;
                    throw new IllegalStateException("Mismatching init-param " + pname + "=" + pvalue + " in " + descriptor.getResource());
                }
            }
        }
        String servlet_class = node.getString("servlet-class", false, true);
        String jspServletName = null;
        String jspServletClass = null;
        boolean hasJSP = false;
        if (id != null && id.equals("jsp")) {
            jspServletName = servlet_name;
            jspServletClass = servlet_class;
            try {
                Loader.loadClass(this.getClass(), (String)servlet_class);
                hasJSP = true;
            }
            catch (ClassNotFoundException e) {
                LOG.info("NO JSP Support for {}, did not find {}", new Object[]{context.getContextPath(), servlet_class});
                servlet_class = "org.eclipse.jetty.servlet.NoJspServlet";
                jspServletClass = "org.eclipse.jetty.servlet.NoJspServlet";
            }
            if (holder.getInitParameter("scratchdir") == null) {
                File tmp = context.getTempDirectory();
                File scratch = new File(tmp, "jsp");
                if (!scratch.exists()) {
                    scratch.mkdir();
                }
                holder.setInitParameter("scratchdir", scratch.getAbsolutePath());
                if ("?".equals(holder.getInitParameter("classpath"))) {
                    String classpath = context.getClassPath();
                    LOG.debug("classpath=" + classpath, new Object[0]);
                    if (classpath != null) {
                        holder.setInitParameter("classpath", classpath);
                    }
                }
            }
            context.setAttribute("org.apache.catalina.jsp_classpath", context.getClassPath());
            holder.setInitParameter("com.sun.appserv.jsp.classpath", this.getSystemClassPath(context));
        }
        if (servlet_class != null) {
            ((WebDescriptor)descriptor).addClassName(servlet_class);
            Origin o2 = context.getMetaData().getOrigin(servlet_name + ".servlet.servlet-class");
            switch (o2) {
                case NotSet: {
                    holder.setClassName(servlet_class);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.servlet-class", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setClassName(servlet_class);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.servlet-class", descriptor);
                    break;
                }
                case WebFragment: {
                    if (servlet_class.equals(holder.getClassName())) break;
                    throw new IllegalStateException("Conflicting servlet-class " + servlet_class + " in " + descriptor.getResource());
                }
            }
        }
        if ((jsp_file = node.getString("jsp-file", false, true)) != null) {
            holder.setForcedPath(jsp_file);
            holder.setClassName(jspServletClass);
            holder.setInitParameter("com.sun.appserv.jsp.classpath", this.getSystemClassPath(context));
        }
        if ((startup = node.get("load-on-startup")) != null) {
            String s = startup.toString(false, true).toLowerCase();
            int order = 0;
            if (s.startsWith("t")) {
                LOG.warn("Deprecated boolean load-on-startup.  Please use integer", new Object[0]);
                order = 1;
            } else {
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Cannot parse load-on-startup " + s + ". Please use integer", new Object[0]);
                    LOG.ignore((Throwable)e);
                }
            }
            Origin o3 = context.getMetaData().getOrigin(servlet_name + ".servlet.load-on-startup");
            switch (o3) {
                case NotSet: {
                    holder.setInitOrder(order);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.load-on-startup", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setInitOrder(order);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.load-on-startup", descriptor);
                    break;
                }
                case WebFragment: {
                    if (order == holder.getInitOrder()) break;
                    throw new IllegalStateException("Conflicting load-on-startup value in " + descriptor.getResource());
                }
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("link role " + roleName + " to " + roleLink + " for " + this, new Object[0]);
                }
                o = context.getMetaData().getOrigin(servlet_name + ".servlet.role-name." + roleName);
                switch (o) {
                    case NotSet: {
                        holder.setUserRoleLink(roleName, roleLink);
                        context.getMetaData().setOrigin(servlet_name + ".servlet.role-name." + roleName, descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        holder.setUserRoleLink(roleName, roleLink);
                        context.getMetaData().setOrigin(servlet_name + ".servlet.role-name." + roleName, descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (holder.getUserRoleLink(roleName).equals(roleLink)) break;
                        throw new IllegalStateException("Conflicting role-link for role-name " + roleName + " for servlet " + servlet_name + " in " + descriptor.getResource());
                    }
                }
                continue;
            }
            LOG.warn("Ignored invalid security-role-ref element: servlet-name=" + holder.getName() + ", " + securityRef, new Object[0]);
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            Origin o4 = context.getMetaData().getOrigin(servlet_name + ".servlet.run-as");
            switch (o4) {
                case NotSet: {
                    holder.setRunAsRole(roleName);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.run-as", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setRunAsRole(roleName);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.run-as", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.getRunAsRole().equals(roleName)) break;
                    throw new IllegalStateException("Conflicting run-as role " + roleName + " for servlet " + servlet_name + " in " + descriptor.getResource());
                }
            }
        }
        if ((async = node.getString("async-supported", false, true)) != null) {
            boolean val = async.length() == 0 || Boolean.valueOf(async) != false;
            o = context.getMetaData().getOrigin(servlet_name + ".servlet.async-supported");
            switch (o) {
                case NotSet: {
                    holder.setAsyncSupported(val);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.async-supported", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setAsyncSupported(val);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.async-supported", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.isAsyncSupported() == val) break;
                    throw new IllegalStateException("Conflicting async-supported=" + async + " for servlet " + servlet_name + " in " + descriptor.getResource());
                }
            }
        }
        if ((enabled = node.getString("enabled", false, true)) != null) {
            boolean is_enabled = enabled.length() == 0 || Boolean.valueOf(enabled) != false;
            Origin o5 = context.getMetaData().getOrigin(servlet_name + ".servlet.enabled");
            switch (o5) {
                case NotSet: {
                    holder.setEnabled(is_enabled);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.enabled", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setEnabled(is_enabled);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.enabled", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.isEnabled() == is_enabled) break;
                    throw new IllegalStateException("Conflicting value of servlet enabled for servlet " + servlet_name + " in " + descriptor.getResource());
                }
            }
        }
        if ((multipart = node.get("multipart-config")) != null) {
            String location = multipart.getString("location", false, true);
            String maxFile = multipart.getString("max-file-size", false, true);
            String maxRequest = multipart.getString("max-request-size", false, true);
            String threshold = multipart.getString("file-size-threshold", false, true);
            MultipartConfigElement element = new MultipartConfigElement(location, maxFile == null || "".equals(maxFile) ? -1L : Long.parseLong(maxFile), maxRequest == null || "".equals(maxRequest) ? -1L : Long.parseLong(maxRequest), threshold == null || "".equals(threshold) ? 0 : Integer.parseInt(threshold));
            Origin o6 = context.getMetaData().getOrigin(servlet_name + ".servlet.multipart-config");
            switch (o6) {
                case NotSet: {
                    holder.getRegistration().setMultipartConfig(element);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.multipart-config", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.getRegistration().setMultipartConfig(element);
                    context.getMetaData().setOrigin(servlet_name + ".servlet.multipart-config", descriptor);
                    break;
                }
                case WebFragment: {
                    MultipartConfigElement cfg = ((ServletHolder.Registration)holder.getRegistration()).getMultipartConfig();
                    if (cfg.getMaxFileSize() != element.getMaxFileSize()) {
                        throw new IllegalStateException("Conflicting multipart-config max-file-size for servlet " + servlet_name + " in " + descriptor.getResource());
                    }
                    if (cfg.getMaxRequestSize() != element.getMaxRequestSize()) {
                        throw new IllegalStateException("Conflicting multipart-config max-request-size for servlet " + servlet_name + " in " + descriptor.getResource());
                    }
                    if (cfg.getFileSizeThreshold() != element.getFileSizeThreshold()) {
                        throw new IllegalStateException("Conflicting multipart-config file-size-threshold for servlet " + servlet_name + " in " + descriptor.getResource());
                    }
                    if ((cfg.getLocation() == null || element.getLocation() != null && element.getLocation().length() != 0) && (cfg.getLocation() != null || element.getLocation() == null && element.getLocation().length() <= 0)) break;
                    throw new IllegalStateException("Conflicting multipart-config location for servlet " + servlet_name + " in " + descriptor.getResource());
                }
            }
        }
    }

    protected void visitServletMapping(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String servlet_name = node.getString("servlet-name", false, true);
        Origin origin = context.getMetaData().getOrigin(servlet_name + ".servlet.mappings");
        switch (origin) {
            case NotSet: {
                context.getMetaData().setOrigin(servlet_name + ".servlet.mappings", descriptor);
                this.addServletMapping(servlet_name, node, context);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                this.addServletMapping(servlet_name, node, context);
                break;
            }
            case WebFragment: {
                this.addServletMapping(servlet_name, node, context);
            }
        }
    }

    protected void visitSessionConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            context.getSessionHandler().getSessionManager().setMaxInactiveInterval(timeout * 60);
        }
        Iterator iter = node.iterator("tracking-mode");
        HashSet<SessionTrackingMode> modes = new HashSet<SessionTrackingMode>();
        modes.addAll(context.getSessionHandler().getSessionManager().getEffectiveSessionTrackingModes());
        while (iter.hasNext()) {
            XmlParser.Node mNode = (XmlParser.Node)iter.next();
            String trackMode = mNode.toString(false, true);
            modes.add(SessionTrackingMode.valueOf((String)trackMode));
        }
        context.getSessionHandler().getSessionManager().setSessionTrackingModes(modes);
        XmlParser.Node cookieConfig = node.get("cookie-config");
        if (cookieConfig != null) {
            Origin o;
            String comment;
            String path;
            String domain;
            String name = cookieConfig.getString("name", false, true);
            if (name != null) {
                Origin o2 = context.getMetaData().getOrigin("cookie-config.name");
                switch (o2) {
                    case NotSet: {
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setName(name);
                        context.getMetaData().setOrigin("cookie-config.name", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setName(name);
                        context.getMetaData().setOrigin("cookie-config.name", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSessionHandler().getSessionManager().getSessionCookieConfig().getName().equals(name)) break;
                        throw new IllegalStateException("Conflicting cookie-config name " + name + " in " + descriptor.getResource());
                    }
                }
            }
            if ((domain = cookieConfig.getString("domain", false, true)) != null) {
                Origin o3 = context.getMetaData().getOrigin("cookie-config.domain");
                switch (o3) {
                    case NotSet: {
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setDomain(domain);
                        context.getMetaData().setOrigin("cookie-config.domain", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setDomain(domain);
                        context.getMetaData().setOrigin("cookie-config.domain", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSessionHandler().getSessionManager().getSessionCookieConfig().getDomain().equals(domain)) break;
                        throw new IllegalStateException("Conflicting cookie-config domain " + domain + " in " + descriptor.getResource());
                    }
                }
            }
            if ((path = cookieConfig.getString("path", false, true)) != null) {
                Origin o4 = context.getMetaData().getOrigin("cookie-config.path");
                switch (o4) {
                    case NotSet: {
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setPath(path);
                        context.getMetaData().setOrigin("cookie-config.path", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setPath(path);
                        context.getMetaData().setOrigin("cookie-config.path", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSessionHandler().getSessionManager().getSessionCookieConfig().getPath().equals(path)) break;
                        throw new IllegalStateException("Conflicting cookie-config path " + path + " in " + descriptor.getResource());
                    }
                }
            }
            if ((comment = cookieConfig.getString("comment", false, true)) != null) {
                Origin o5 = context.getMetaData().getOrigin("cookie-config.comment");
                switch (o5) {
                    case NotSet: {
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setComment(comment);
                        context.getMetaData().setOrigin("cookie-config.comment", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setComment(comment);
                        context.getMetaData().setOrigin("cookie-config.comment", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSessionHandler().getSessionManager().getSessionCookieConfig().getComment().equals(comment)) break;
                        throw new IllegalStateException("Conflicting cookie-config comment " + comment + " in " + descriptor.getResource());
                    }
                }
            }
            if ((tNode = cookieConfig.get("http-only")) != null) {
                boolean httpOnly = Boolean.parseBoolean(tNode.toString(false, true));
                o = context.getMetaData().getOrigin("cookie-config.http-only");
                switch (o) {
                    case NotSet: {
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setHttpOnly(httpOnly);
                        context.getMetaData().setOrigin("cookie-config.http-only", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setHttpOnly(httpOnly);
                        context.getMetaData().setOrigin("cookie-config.http-only", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSessionHandler().getSessionManager().getSessionCookieConfig().isHttpOnly() == httpOnly) break;
                        throw new IllegalStateException("Conflicting cookie-config http-only " + httpOnly + " in " + descriptor.getResource());
                    }
                }
            }
            if ((tNode = cookieConfig.get("secure")) != null) {
                boolean secure = Boolean.parseBoolean(tNode.toString(false, true));
                o = context.getMetaData().getOrigin("cookie-config.secure");
                switch (o) {
                    case NotSet: {
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setSecure(secure);
                        context.getMetaData().setOrigin("cookie-config.secure", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setSecure(secure);
                        context.getMetaData().setOrigin("cookie-config.secure", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSessionHandler().getSessionManager().getSessionCookieConfig().isSecure() == secure) break;
                        throw new IllegalStateException("Conflicting cookie-config secure " + secure + " in " + descriptor.getResource());
                    }
                }
            }
            if ((tNode = cookieConfig.get("max-age")) != null) {
                int maxAge = Integer.parseInt(tNode.toString(false, true));
                o = context.getMetaData().getOrigin("cookie-config.max-age");
                switch (o) {
                    case NotSet: {
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setMaxAge(maxAge);
                        context.getMetaData().setOrigin("cookie-config.max-age", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSessionHandler().getSessionManager().getSessionCookieConfig().setMaxAge(maxAge);
                        context.getMetaData().setOrigin("cookie-config.max-age", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSessionHandler().getSessionManager().getSessionCookieConfig().getMaxAge() == maxAge) break;
                        throw new IllegalStateException("Conflicting cookie-config max-age " + maxAge + " in " + descriptor.getResource());
                    }
                }
            }
        }
    }

    protected void visitMimeMapping(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        if (extension != null) {
            Origin o = context.getMetaData().getOrigin("extension." + extension);
            switch (o) {
                case NotSet: {
                    context.getMimeTypes().addMimeMapping(extension, mimeType);
                    context.getMetaData().setOrigin("extension." + extension, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    context.getMimeTypes().addMimeMapping(extension, mimeType);
                    context.getMetaData().setOrigin("extension." + extension, descriptor);
                    break;
                }
                case WebFragment: {
                    Buffer buffer = context.getMimeTypes().getMimeByExtension("." + extension);
                    context.getMimeTypes();
                    if (buffer.equals(MimeTypes.CACHE.lookup(mimeType))) break;
                    throw new IllegalStateException("Conflicting mime-type " + mimeType + " for extension " + extension + " in " + descriptor.getResource());
                }
            }
        }
    }

    protected void visitWelcomeFileList(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        Origin o = context.getMetaData().getOrigin("welcome-file-list");
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("welcome-file-list", descriptor);
                this.addWelcomeFiles(context, node);
                break;
            }
            case WebXml: {
                this.addWelcomeFiles(context, node);
                break;
            }
            case WebDefaults: {
                if (!(descriptor instanceof DefaultsDescriptor || descriptor instanceof OverrideDescriptor || descriptor instanceof FragmentDescriptor)) {
                    context.setWelcomeFiles(new String[0]);
                }
                this.addWelcomeFiles(context, node);
                break;
            }
            case WebOverride: {
                this.addWelcomeFiles(context, node);
                break;
            }
            case WebFragment: {
                this.addWelcomeFiles(context, node);
            }
        }
    }

    protected void visitLocaleEncodingList(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        Iterator iter = node.iterator("locale-encoding-mapping");
        while (iter.hasNext()) {
            XmlParser.Node mapping = (XmlParser.Node)iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            if (encoding == null) continue;
            Origin o = context.getMetaData().getOrigin("locale-encoding." + locale);
            switch (o) {
                case NotSet: {
                    context.addLocaleEncoding(locale, encoding);
                    context.getMetaData().setOrigin("locale-encoding." + locale, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    context.addLocaleEncoding(locale, encoding);
                    context.getMetaData().setOrigin("locale-encoding." + locale, descriptor);
                    break;
                }
                case WebFragment: {
                    if (encoding.equals(context.getLocaleEncoding(locale))) break;
                    throw new IllegalStateException("Conflicting loacle-encoding mapping for locale " + locale + " in " + descriptor.getResource());
                }
            }
        }
    }

    protected void visitErrorPage(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        int code = 0;
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        } else {
            code = Integer.valueOf(error);
        }
        String location = node.getString("location", false, true);
        ErrorPageErrorHandler handler = (ErrorPageErrorHandler)context.getErrorHandler();
        Origin o = context.getMetaData().getOrigin("error." + error);
        switch (o) {
            case NotSet: {
                if (code > 0) {
                    handler.addErrorPage(code, location);
                } else {
                    handler.addErrorPage(error, location);
                }
                context.getMetaData().setOrigin("error." + error, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                if (code > 0) {
                    handler.addErrorPage(code, location);
                } else {
                    handler.addErrorPage(error, location);
                }
                context.getMetaData().setOrigin("error." + error, descriptor);
                break;
            }
            case WebFragment: {
                if (((String)handler.getErrorPages().get(error)).equals(location)) break;
                throw new IllegalStateException("Conflicting error-code or exception-type " + error + " in " + descriptor.getResource());
            }
        }
    }

    protected void addWelcomeFiles(WebAppContext context, XmlParser.Node node) {
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String welcome = indexNode.toString(false, true);
            context.setWelcomeFiles((String[])LazyList.addToArray((Object[])context.getWelcomeFiles(), (Object)welcome, String.class));
        }
    }

    protected void addServletMapping(String servletName, XmlParser.Node node, WebAppContext context) {
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(servletName);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = this.normalizePattern(p);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        context.getServletHandler().addServletMapping(mapping);
    }

    protected void addFilterMapping(String filterName, XmlParser.Node node, WebAppContext context) {
        FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(filterName);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = this.normalizePattern(p);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        ArrayList<String> names = new ArrayList<String>();
        iter = node.iterator("servlet-name");
        while (iter.hasNext()) {
            String n = ((XmlParser.Node)iter.next()).toString(false, true);
            names.add(n);
        }
        mapping.setServletNames(names.toArray(new String[names.size()]));
        ArrayList<DispatcherType> dispatches = new ArrayList<DispatcherType>();
        iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = ((XmlParser.Node)iter.next()).toString(false, true);
            dispatches.add(FilterMapping.dispatch((String)d));
        }
        if (dispatches.size() > 0) {
            mapping.setDispatcherTypes(EnumSet.copyOf(dispatches));
        }
        context.getServletHandler().addFilterMapping(mapping);
    }

    protected void visitTagLib(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        context.setResourceAlias(uri, location);
        ServletContextHandler.JspConfig config = (ServletContextHandler.JspConfig)context.getServletContext().getJspConfigDescriptor();
        if (config == null) {
            config = new ServletContextHandler.JspConfig();
            context.getServletContext().setJspConfigDescriptor((JspConfigDescriptor)config);
        }
        ServletContextHandler.TagLib tl = new ServletContextHandler.TagLib();
        tl.setTaglibLocation(location);
        tl.setTaglibURI(uri);
        config.addTaglibDescriptor((TaglibDescriptor)tl);
    }

    protected void visitJspConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        ServletContextHandler.JspConfig config = (ServletContextHandler.JspConfig)context.getServletContext().getJspConfigDescriptor();
        if (config == null) {
            config = new ServletContextHandler.JspConfig();
            context.getServletContext().setJspConfigDescriptor((JspConfigDescriptor)config);
        }
        for (int i = 0; i < node.size(); ++i) {
            Object o = node.get(i);
            if (!(o instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)o).getTag())) continue;
            this.visitTagLib(context, descriptor, (XmlParser.Node)o);
        }
        Iterator iter = node.iterator("jsp-property-group");
        ArrayList<String> paths = new ArrayList<String>();
        while (iter.hasNext()) {
            ServletContextHandler.JspPropertyGroup jpg = new ServletContextHandler.JspPropertyGroup();
            config.addJspPropertyGroup((JspPropertyGroupDescriptor)jpg);
            XmlParser.Node group = (XmlParser.Node)iter.next();
            Iterator iter2 = group.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                url = this.normalizePattern(url);
                paths.add(url);
                jpg.addUrlPattern(url);
            }
            jpg.setElIgnored(group.getString("el-ignored", false, true));
            jpg.setPageEncoding(group.getString("page-encoding", false, true));
            jpg.setScriptingInvalid(group.getString("scripting-invalid", false, true));
            jpg.setIsXml(group.getString("is-xml", false, true));
            jpg.setDeferredSyntaxAllowedAsLiteral(group.getString("deferred-syntax-allowed-as-literal", false, true));
            jpg.setTrimDirectiveWhitespaces(group.getString("trim-directive-whitespaces", false, true));
            jpg.setDefaultContentType(group.getString("defaultContentType", false, true));
            jpg.setBuffer(group.getString("buffer", false, true));
            jpg.setErrorOnUndeclaredNamespace(group.getString("error-on-undeclared-namespace", false, true));
            Iterator preludes = group.iterator("include-prelude");
            while (preludes.hasNext()) {
                String prelude = ((XmlParser.Node)preludes.next()).toString(false, true);
                jpg.addIncludePrelude(prelude);
            }
            Iterator codas = group.iterator("include-coda");
            while (codas.hasNext()) {
                String coda = ((XmlParser.Node)codas.next()).toString(false, true);
                jpg.addIncludeCoda(coda);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(config.toString(), new Object[0]);
        }
        if (paths.size() > 0) {
            String jspName = "jsp";
            PathMap.Entry entry = context.getServletHandler().getHolderEntry("test.jsp");
            if (entry != null) {
                ServletHolder holder = (ServletHolder)entry.getValue();
                jspName = holder.getName();
            }
            if (jspName != null) {
                ServletMapping mapping = new ServletMapping();
                mapping.setServletName(jspName);
                mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
                context.getServletHandler().addServletMapping(mapping);
            }
        }
    }

    protected void visitSecurityConstraint(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        Constraint scBase = new Constraint();
        try {
            XmlParser.Node data;
            XmlParser.Node auths = node.get("auth-constraint");
            if (auths != null) {
                scBase.setAuthenticate(true);
                Iterator iter = auths.iterator("role-name");
                ArrayList<String> roles = new ArrayList<String>();
                while (iter.hasNext()) {
                    String role = ((XmlParser.Node)iter.next()).toString(false, true);
                    roles.add(role);
                }
                scBase.setRoles(roles.toArray(new String[roles.size()]));
            }
            if ((data = node.get("user-data-constraint")) != null) {
                String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
                if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                    scBase.setDataConstraint(0);
                } else if ("INTEGRAL".equals(guarantee)) {
                    scBase.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(guarantee)) {
                    scBase.setDataConstraint(2);
                } else {
                    LOG.warn("Unknown user-data-constraint:" + guarantee, new Object[0]);
                    scBase.setDataConstraint(2);
                }
            }
            Iterator iter = node.iterator("web-resource-collection");
            while (iter.hasNext()) {
                XmlParser.Node collection = (XmlParser.Node)iter.next();
                String name = collection.getString("web-resource-name", false, true);
                Constraint sc = (Constraint)scBase.clone();
                sc.setName(name);
                Iterator iter2 = collection.iterator("url-pattern");
                while (iter2.hasNext()) {
                    String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                    url = this.normalizePattern(url);
                    Iterator iter3 = collection.iterator("http-method");
                    if (iter3.hasNext()) {
                        while (iter3.hasNext()) {
                            String method = ((XmlParser.Node)iter3.next()).toString(false, true);
                            ConstraintMapping mapping = new ConstraintMapping();
                            mapping.setMethod(method);
                            mapping.setPathSpec(url);
                            mapping.setConstraint(sc);
                            ((ConstraintAware)context.getSecurityHandler()).addConstraintMapping(mapping);
                        }
                        continue;
                    }
                    ConstraintMapping mapping = new ConstraintMapping();
                    mapping.setPathSpec(url);
                    mapping.setConstraint(sc);
                    ((ConstraintAware)context.getSecurityHandler()).addConstraintMapping(mapping);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            LOG.warn((Throwable)e);
        }
    }

    protected void visitLoginConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        XmlParser.Node method = node.get("auth-method");
        if (method != null) {
            Origin o = context.getMetaData().getOrigin("auth-method");
            switch (o) {
                case NotSet: {
                    context.getSecurityHandler().setAuthMethod(method.toString(false, true));
                    context.getMetaData().setOrigin("auth-method", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    context.getSecurityHandler().setAuthMethod(method.toString(false, true));
                    context.getMetaData().setOrigin("auth-method", descriptor);
                    break;
                }
                case WebFragment: {
                    if (context.getSecurityHandler().getAuthMethod().equals(method.toString(false, true))) break;
                    throw new IllegalStateException("Conflicting auth-method value in " + descriptor.getResource());
                }
            }
            XmlParser.Node name = node.get("realm-name");
            String nameStr = name == null ? "default" : name.toString(false, true);
            o = context.getMetaData().getOrigin("realm-name");
            switch (o) {
                case NotSet: {
                    context.getSecurityHandler().setRealmName(nameStr);
                    context.getMetaData().setOrigin("realm-name", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    context.getSecurityHandler().setRealmName(nameStr);
                    context.getMetaData().setOrigin("realm-name", descriptor);
                    break;
                }
                case WebFragment: {
                    if (context.getSecurityHandler().getRealmName().equals(nameStr)) break;
                    throw new IllegalStateException("Conflicting realm-name value in " + descriptor.getResource());
                }
            }
            if ("FORM".equals(context.getSecurityHandler().getAuthMethod())) {
                XmlParser.Node formConfig = node.get("form-login-config");
                if (formConfig != null) {
                    String loginPageName = null;
                    XmlParser.Node loginPage = formConfig.get("form-login-page");
                    if (loginPage != null) {
                        loginPageName = loginPage.toString(false, true);
                    }
                    String errorPageName = null;
                    XmlParser.Node errorPage = formConfig.get("form-error-page");
                    if (errorPage != null) {
                        errorPageName = errorPage.toString(false, true);
                    }
                    o = context.getMetaData().getOrigin("form-login-page");
                    switch (o) {
                        case NotSet: {
                            context.getSecurityHandler().setInitParameter("org.eclipse.jetty.security.form_login_page", loginPageName);
                            context.getMetaData().setOrigin("form-login-page", descriptor);
                            break;
                        }
                        case WebXml: 
                        case WebDefaults: 
                        case WebOverride: {
                            if (descriptor instanceof FragmentDescriptor) break;
                            context.getSecurityHandler().setInitParameter("org.eclipse.jetty.security.form_login_page", loginPageName);
                            context.getMetaData().setOrigin("form-login-page", descriptor);
                            break;
                        }
                        case WebFragment: {
                            if (context.getSecurityHandler().getInitParameter("org.eclipse.jetty.security.form_login_page").equals(loginPageName)) break;
                            throw new IllegalStateException("Conflicting form-login-page value in " + descriptor.getResource());
                        }
                    }
                    o = context.getMetaData().getOrigin("form-error-page");
                    switch (o) {
                        case NotSet: {
                            context.getSecurityHandler().setInitParameter("org.eclipse.jetty.security.form_error_page", errorPageName);
                            context.getMetaData().setOrigin("form-error-page", descriptor);
                            break;
                        }
                        case WebXml: 
                        case WebDefaults: 
                        case WebOverride: {
                            if (descriptor instanceof FragmentDescriptor) break;
                            context.getSecurityHandler().setInitParameter("org.eclipse.jetty.security.form_error_page", errorPageName);
                            context.getMetaData().setOrigin("form-error-page", descriptor);
                            break;
                        }
                        case WebFragment: {
                            if (context.getSecurityHandler().getInitParameter("org.eclipse.jetty.security.form_error_page").equals(errorPageName)) break;
                            throw new IllegalStateException("Conflicting form-error-page value in " + descriptor.getResource());
                        }
                    }
                } else {
                    throw new IllegalStateException("!form-login-config");
                }
            }
        }
    }

    protected void visitSecurityRole(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node roleNode = node.get("role-name");
        String role = roleNode.toString(false, true);
        ((ConstraintAware)context.getSecurityHandler()).addRole(role);
    }

    protected void visitFilter(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String filter_class;
        String name = node.getString("filter-name", false, true);
        FilterHolder holder = context.getServletHandler().getFilter(name);
        if (holder == null) {
            holder = context.getServletHandler().newFilterHolder(Holder.Source.DESCRIPTOR);
            holder.setName(name);
            context.getServletHandler().addFilter(holder);
        }
        if ((filter_class = node.getString("filter-class", false, true)) != null) {
            ((WebDescriptor)descriptor).addClassName(filter_class);
            Origin o = context.getMetaData().getOrigin(name + ".filter.filter-class");
            switch (o) {
                case NotSet: {
                    holder.setClassName(filter_class);
                    context.getMetaData().setOrigin(name + ".filter.filter-class", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setClassName(filter_class);
                    context.getMetaData().setOrigin(name + ".filter.filter-class", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.getClassName().equals(filter_class)) break;
                    throw new IllegalStateException("Conflicting filter-class for filter " + name + " in " + descriptor.getResource());
                }
            }
        }
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            Origin origin = context.getMetaData().getOrigin(name + ".filter.init-param." + pname);
            switch (origin) {
                case NotSet: {
                    holder.setInitParameter(pname, pvalue);
                    context.getMetaData().setOrigin(name + ".filter.init-param." + pname, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setInitParameter(pname, pvalue);
                    context.getMetaData().setOrigin(name + ".filter.init-param." + pname, descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.getInitParameter(pname).equals(pvalue)) break;
                    throw new IllegalStateException("Mismatching init-param " + pname + "=" + pvalue + " in " + descriptor.getResource());
                }
            }
        }
        String async = node.getString("async-supported", false, true);
        if (async != null) {
            holder.setAsyncSupported(async.length() == 0 || Boolean.valueOf(async) != false);
        }
        if (async != null) {
            boolean val = async.length() == 0 || Boolean.valueOf(async) != false;
            Origin o = context.getMetaData().getOrigin(name + ".filter.async-supported");
            switch (o) {
                case NotSet: {
                    holder.setAsyncSupported(val);
                    context.getMetaData().setOrigin(name + ".filter.async-supported", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setAsyncSupported(val);
                    context.getMetaData().setOrigin(name + ".filter.async-supported", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.isAsyncSupported() == val) break;
                    throw new IllegalStateException("Conflicting async-supported=" + async + " for filter " + name + " in " + descriptor.getResource());
                }
            }
        }
    }

    protected void visitFilterMapping(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String filter_name = node.getString("filter-name", false, true);
        Origin origin = context.getMetaData().getOrigin(filter_name + ".filter.mappings");
        switch (origin) {
            case NotSet: {
                context.getMetaData().setOrigin(filter_name + ".filter.mappings", descriptor);
                this.addFilterMapping(filter_name, node, context);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                this.addFilterMapping(filter_name, node, context);
                break;
            }
            case WebFragment: {
                this.addFilterMapping(filter_name, node, context);
            }
        }
    }

    protected void visitListener(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        EventListener listener = null;
        try {
            if (className != null && className.length() > 0) {
                EventListener[] listeners = context.getEventListeners();
                if (listeners != null) {
                    for (EventListener l : listeners) {
                        if (!l.getClass().getName().equals(className)) continue;
                        return;
                    }
                }
                ((WebDescriptor)descriptor).addClassName(className);
                Class listenerClass = context.loadClass(className);
                listener = this.newListenerInstance(context, listenerClass);
                if (!(listener instanceof EventListener)) {
                    LOG.warn("Not an EventListener: " + listener, new Object[0]);
                    return;
                }
                context.addEventListener(listener);
                context.getMetaData().setOrigin(className + ".listener", descriptor);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not instantiate listener " + className, (Throwable)e);
            return;
        }
    }

    protected void visitDistributable(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        ((WebDescriptor)descriptor).setDistributable(true);
    }

    protected EventListener newListenerInstance(WebAppContext context, Class<? extends EventListener> clazz) throws ServletException, InstantiationException, IllegalAccessException {
        try {
            return context.getServletContext().createListener(clazz);
        }
        catch (ServletException se) {
            Throwable cause = se.getRootCause();
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw se;
        }
    }

    protected String normalizePattern(String p) {
        if (p != null && p.length() > 0 && !p.startsWith("/") && !p.startsWith("*")) {
            return "/" + p;
        }
        return p;
    }

    protected String getSystemClassPath(WebAppContext context) {
        ClassLoader loader = context.getClassLoader();
        if (loader.getParent() != null) {
            loader = loader.getParent();
        }
        StringBuilder classpath = new StringBuilder();
        while (loader != null && loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    try {
                        Resource resource = context.newResource(urls[i]);
                        File file = resource.getFile();
                        if (file == null || !file.exists()) continue;
                        if (classpath.length() > 0) {
                            classpath.append(File.pathSeparatorChar);
                        }
                        classpath.append(file.getAbsolutePath());
                        continue;
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
            loader = loader.getParent();
        }
        return classpath.toString();
    }
}

