/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ParameterAnnotationEntry;

public abstract class ParameterAnnotations
extends Attribute {
    private static final long serialVersionUID = -8831779739803248091L;
    private int num_parameters;
    private ParameterAnnotationEntry[] parameter_annotation_table;

    ParameterAnnotations(byte parameter_annotation_type, int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(parameter_annotation_type, name_index, length, (ParameterAnnotationEntry[])null, constant_pool);
        this.num_parameters = file.readUnsignedByte();
        this.parameter_annotation_table = new ParameterAnnotationEntry[this.num_parameters];
        int i = 0;
        while (i < this.num_parameters) {
            this.parameter_annotation_table[i] = new ParameterAnnotationEntry(file, constant_pool);
            ++i;
        }
    }

    public ParameterAnnotations(byte parameter_annotation_type, int name_index, int length, ParameterAnnotationEntry[] parameter_annotation_table, ConstantPool constant_pool) {
        super(parameter_annotation_type, name_index, length, constant_pool);
        this.setParameterAnnotationTable(parameter_annotation_table);
    }

    public final void setParameterAnnotationTable(ParameterAnnotationEntry[] parameter_annotation_table) {
        this.parameter_annotation_table = parameter_annotation_table;
        this.num_parameters = parameter_annotation_table == null ? 0 : parameter_annotation_table.length;
    }
}

