/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;

public class FocusedDLTKProposalProcessor {
    private static final int THRESHOLD_INTEREST = 10000;
    private static final int THRESHOLD_IMPLICIT_INTEREST = 20000;
    private static final int RELEVANCE_IMPLICIT_INTEREST_JAVA = 600;
    private static final int RELEVANCE_IMPLICIT_INTEREST_MISC = 300;
    private static final String IDENTIFIER_THIS = "this";
    public static final String LABEL_SEPARATOR = " -------------------------------------------- ";
    public static final FocusedProposalSeparator PROPOSAL_SEPARATOR = new FocusedProposalSeparator();
    private final List<IScriptCompletionProposalComputer> monitoredProposalComputers = new ArrayList<IScriptCompletionProposalComputer>();
    private final List<IScriptCompletionProposalComputer> alreadyComputedProposals = new ArrayList<IScriptCompletionProposalComputer>();
    private final List<IScriptCompletionProposalComputer> alreadyContainSeparator = new ArrayList<IScriptCompletionProposalComputer>();
    private final List<IScriptCompletionProposalComputer> containsSingleInterestingProposal = new ArrayList<IScriptCompletionProposalComputer>();
    private static FocusedDLTKProposalProcessor INSTANCE = new FocusedDLTKProposalProcessor();

    private FocusedDLTKProposalProcessor() {
    }

    public static FocusedDLTKProposalProcessor getDefault() {
        return INSTANCE;
    }

    public void addMonitoredComputer(IScriptCompletionProposalComputer proposalComputer) {
        this.monitoredProposalComputers.add(proposalComputer);
    }

    public List projectInterestModel(IScriptCompletionProposalComputer proposalComputer, List proposals) {
        try {
            if (!ContextCore.getContextManager().isContextActive()) {
                return proposals;
            }
            boolean hasInterestingProposals = false;
            for (Object object : proposals) {
                if (!(object instanceof AbstractScriptCompletionProposal)) continue;
                boolean foundInteresting = this.boostRelevanceWithInterest((AbstractScriptCompletionProposal)object);
                if (hasInterestingProposals || !foundInteresting) continue;
                hasInterestingProposals = true;
            }
            if (this.containsSingleInterestingProposal.size() > 0 && proposals.size() > 0) {
                proposals.add(PROPOSAL_SEPARATOR);
            } else if (hasInterestingProposals && this.alreadyContainSeparator.isEmpty()) {
                if (proposals.size() == 1) {
                    this.containsSingleInterestingProposal.add(proposalComputer);
                } else {
                    proposals.add(PROPOSAL_SEPARATOR);
                    this.alreadyContainSeparator.add(proposalComputer);
                }
            }
            this.alreadyComputedProposals.add(proposalComputer);
            if (this.alreadyComputedProposals.size() == this.monitoredProposalComputers.size()) {
                this.alreadyComputedProposals.clear();
                this.alreadyContainSeparator.clear();
                this.containsSingleInterestingProposal.clear();
            }
            return proposals;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Failed to project interest onto propsals", t));
            return proposals;
        }
    }

    private boolean boostRelevanceWithInterest(AbstractScriptCompletionProposal proposal) {
        boolean hasInteresting = false;
        IModelElement javaElement = proposal.getModelElement();
        if (javaElement != null) {
            IInteractionElement interactionElement = ContextCore.getContextManager().getElement(javaElement.getHandleIdentifier());
            float interest = interactionElement.getInterest().getValue();
            if (interest > ContextCore.getCommonContextScaling().getInteresting()) {
                proposal.setRelevance(10000 + (int)(interest * 10.0f));
                hasInteresting = true;
            } else if (proposal.getRelevance() > 600) {
                proposal.setRelevance(20000 + proposal.getRelevance());
            }
        } else if (this.isImplicitlyInteresting(proposal)) {
            proposal.setRelevance(20000 + proposal.getRelevance());
            hasInteresting = true;
        }
        return hasInteresting;
    }

    public boolean isImplicitlyInteresting(AbstractScriptCompletionProposal proposal) {
        return proposal.getRelevance() > 300 && !IDENTIFIER_THIS.equals(proposal.getDisplayString());
    }

    static class FocusedProposalSeparator
    extends ScriptCompletionProposal {
        public FocusedProposalSeparator() {
            super("", 0, 0, CommonImages.getImage((ImageDescriptor)CommonImages.SEPARATOR_LIST), FocusedDLTKProposalProcessor.LABEL_SEPARATOR, 10000);
        }

        protected boolean isSmartTrigger(char trigger) {
            return false;
        }
    }
}

