/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesSourceModule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RemoveSourceAssociation
implements IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        for (ISourceModule element : this.selection) {
            try {
                element.delete(false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ModelException e) {
                DLTKCore.error((String)"Failed to remove source association", (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            action.setEnabled(this.checkEnablement(this.selection));
        }
    }

    private boolean checkEnablement(IStructuredSelection selection2) {
        for (TclSourcesSourceModule module : this.selection) {
            String originalName = module.getOriginalName();
            if (originalName.contains("$")) continue;
            return false;
        }
        return true;
    }
}

