/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;

public class MarkerResolutionProposal
implements IScriptCompletionProposal {
    private IMarkerResolution fResolution;
    private IMarker fMarker;

    public MarkerResolutionProposal(IMarkerResolution resolution, IMarker marker) {
        this.fResolution = resolution;
        this.fMarker = marker;
    }

    public void apply(IDocument document) {
        this.fResolution.run(this.fMarker);
    }

    public String getAdditionalProposalInfo() {
        if (this.fResolution instanceof IMarkerResolution2) {
            return ((IMarkerResolution2)this.fResolution).getDescription();
        }
        if (this.fResolution instanceof IScriptCompletionProposal) {
            return ((IScriptCompletionProposal)this.fResolution).getAdditionalProposalInfo();
        }
        try {
            String problemDesc = (String)this.fMarker.getAttribute("message");
            return problemDesc;
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
            return null;
        }
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fResolution.getLabel();
    }

    public Image getImage() {
        if (this.fResolution instanceof IMarkerResolution2) {
            return ((IMarkerResolution2)this.fResolution).getImage();
        }
        if (this.fResolution instanceof IScriptCompletionProposal) {
            return ((IScriptCompletionProposal)this.fResolution).getImage();
        }
        return DLTKPluginImages.get("org.eclipse.dltk.ui.correction_change.png");
    }

    @Override
    public int getRelevance() {
        if (this.fResolution instanceof IScriptCompletionProposal) {
            return ((IScriptCompletionProposal)this.fResolution).getRelevance();
        }
        return 10;
    }

    public Point getSelection(IDocument document) {
        if (this.fResolution instanceof IScriptCompletionProposal) {
            return ((IScriptCompletionProposal)this.fResolution).getSelection(document);
        }
        return null;
    }
}

