/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.IHotCodeReplaceProvider;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.tcl.internal.debug.TclDebugPlugin;

public class TclHotCodeReplaceProvider
implements IHotCodeReplaceProvider {
    public void performCodeReplace(IScriptDebugTarget target, IResource[] resources) throws DebugException {
        IScriptThread[] threads = (IScriptThread[])target.getThreads();
        if (threads.length > 0) {
            IDbgpExtendedCommands extCmds = threads[0].getDbgpSession().getExtendedCommands();
            int i = 0;
            while (i < resources.length) {
                String code = this.getResourceReplacementCode(resources[i]);
                if (code != null) {
                    try {
                        extCmds.evaluate(code);
                    }
                    catch (DbgpException e) {
                        TclDebugPlugin.log(e);
                    }
                }
                ++i;
            }
        }
    }

    private String getResourceReplacementCode(IResource resource) throws DebugException {
        StringBuffer sb;
        block9: {
            ArrayList procList;
            block8: {
                ISourceModule module = (ISourceModule)DLTKCore.create((IFile)((IFile)resource));
                if (module == null) {
                    return null;
                }
                procList = new ArrayList();
                module.accept(element -> {
                    if (element.getElementType() == 9) {
                        procList.add((IMethod)element);
                        return false;
                    }
                    return true;
                });
                if (!procList.isEmpty()) break block8;
                return null;
            }
            try {
                char[] input = Util.getResourceContentsAsCharArray((IFile)((IFile)resource));
                sb = new StringBuffer();
                for (IMethod method : procList) {
                    String[] types = this.collectNamespaces(method);
                    if (types == null) continue;
                    int j = 0;
                    while (j < types.length) {
                        sb.append("namespace eval " + types[j] + " {\n");
                        ++j;
                    }
                    sb.append("proc ");
                    sb.append(method.getElementName());
                    ISourceRange nameRange = method.getNameRange();
                    int nameEnd = nameRange.getLength() + nameRange.getOffset();
                    ISourceRange sourceRange = method.getSourceRange();
                    sb.append(input, nameEnd, sourceRange.getOffset() + sourceRange.getLength() - nameEnd);
                    sb.append("\n");
                    int j2 = 0;
                    while (j2 < types.length) {
                        sb.append("}\n");
                        ++j2;
                    }
                }
                if (sb.length() != 0) break block9;
                return null;
            }
            catch (ModelException e) {
                TclDebugPlugin.log(e);
                return null;
            }
        }
        return sb.toString();
    }

    private String[] collectNamespaces(IMethod method) {
        ArrayList<String> types = new ArrayList<String>();
        IModelElement parent = method.getParent();
        while (parent.getElementType() == 7) {
            types.add(parent.getElementName());
            parent = parent.getParent();
        }
        if (parent.getElementType() != 5) {
            return null;
        }
        if (types.isEmpty()) {
            return CharOperation.NO_STRINGS;
        }
        Collections.reverse(types);
        return types.toArray(new String[types.size()]);
    }
}

