/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.python.parser.ast.expressions.CallHolder;
import org.eclipse.dltk.python.parser.ast.expressions.IndexHolder;
import org.eclipse.dltk.utils.CorePrinter;

public class ExtendedVariableReference
extends Reference {
    private List fExpressions = new ArrayList();

    public ExtendedVariableReference(Expression expr) {
        if (expr != null) {
            this.addExpression(expr);
            this.setStart(expr.sourceStart());
            this.setEnd(expr.sourceEnd());
        }
    }

    public int getKind() {
        return 1071;
    }

    public void addExpression(Expression expr) {
        if (expr != null) {
            this.fExpressions.add(expr);
            if (expr.sourceEnd() >= this.sourceEnd()) {
                this.setEnd(expr.sourceEnd());
            }
        }
    }

    public void setExpresssions(List exprs) {
        this.fExpressions = exprs;
    }

    public List getExpressions() {
        return this.fExpressions;
    }

    public boolean isCall(int index) {
        Expression afterIndexExpression;
        List expressions = this.getExpressions();
        if (expressions == null) {
            return false;
        }
        return index < expressions.size() - 1 && (afterIndexExpression = (Expression)expressions.get(index + 1)) instanceof CallHolder;
    }

    public boolean isIndex(int index) {
        Expression afterIndexExpression;
        List expressions = this.getExpressions();
        if (expressions == null) {
            return false;
        }
        return index < expressions.size() - 1 && (afterIndexExpression = (Expression)expressions.get(index + 1)) instanceof IndexHolder;
    }

    public boolean isDot(int index) {
        Expression afterIndexExpression;
        List expressions = this.getExpressions();
        if (expressions == null) {
            return false;
        }
        return index < expressions.size() - 1 && !((afterIndexExpression = (Expression)expressions.get(index + 1)) instanceof CallHolder) && !(afterIndexExpression instanceof IndexHolder);
    }

    public String getStringRepresentation() {
        StringBuffer b = new StringBuffer();
        for (Expression e : this.fExpressions) {
            switch (e.getKind()) {
                case 1071: {
                    Reference s = (Reference)e;
                    b.append(s.getStringRepresentation());
                    b.append('.');
                    break;
                }
                case 1049: {
                    b.append("[]");
                    break;
                }
                case 1067: {
                    b.append("()");
                    break;
                }
                case 1069: {
                    b.append("{}");
                }
            }
        }
        return b.toString();
    }

    public Expression getExpression(int i) {
        if (this.fExpressions != null) {
            return (Expression)this.fExpressions.get(i);
        }
        return null;
    }

    public int getExpressionCount() {
        if (this.fExpressions != null) {
            return this.fExpressions.size();
        }
        return 0;
    }

    public boolean isLast(int index) {
        if (this.fExpressions != null) {
            return this.fExpressions.size() - 1 == index;
        }
        return false;
    }

    public void printNode(CorePrinter output) {
        List expressions = this.getExpressions();
        boolean bFirst = true;
        if (expressions != null) {
            for (Expression expr : expressions) {
                if (bFirst) {
                    bFirst = false;
                } else if (!(expr instanceof CallHolder) && !(expr instanceof IndexHolder)) {
                    output.formatPrintLn(".");
                }
                expr.printNode(output);
            }
        }
    }
}

