/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.debug.ui.console;

import com.ibm.icu.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.python.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PythonFileHyperlink
implements IHyperlink {
    private TextConsole fConsole;

    public PythonFileHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        try {
            Object sourceElement;
            int lineNumber;
            String fileName;
            try {
                String linkText = this.getLinkText();
                fileName = this.getFileName(linkText);
                lineNumber = this.getLineNumber(linkText);
            }
            catch (CoreException e1) {
                ErrorDialog.openError((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.PythonFileHyperlink_Error, (String)ConsoleMessages.PythonFileHyperlink_Error, (IStatus)e1.getStatus());
                return;
            }
            if (lineNumber > 0) {
                --lineNumber;
            }
            if ((sourceElement = this.getSourceModule(fileName)) != null) {
                IEditorPart part = EditorUtility.openInEditor((Object)sourceElement);
                IEditorPart editorPart = EditorUtility.openInEditor((Object)sourceElement);
                if (editorPart instanceof ITextEditor && lineNumber >= 0) {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    IEditorInput input = part.getEditorInput();
                    provider.connect((Object)input);
                    IDocument document = provider.getDocument((Object)input);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    provider.disconnect((Object)input);
                }
                return;
            }
            MessageDialog.openInformation((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.PythonFileHyperlink_Information_1, (String)MessageFormat.format((String)ConsoleMessages.PythonFileHyperlink_Source_not_found_for__0__2, (Object[])new Object[]{fileName}));
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.errorDialog((String)ConsoleMessages.PythonFileHyperlink_An_exception_occurred_while_following_link__3, (Throwable)e);
            return;
        }
    }

    protected Object getSourceModule(String fileName) throws CoreException {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        return f;
    }

    protected String getFileName(String linkText) throws CoreException {
        Pattern p = Pattern.compile("File\\s*\"(.*)\"");
        Matcher m = p.matcher(linkText);
        if (m.find()) {
            String name = m.group(1);
            return name;
        }
        Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.PythonFileHyperlink_Unable_to_parse_type_name_from_hyperlink__5, null);
        throw new CoreException((IStatus)status);
    }

    protected int getLineNumber(String linkText) throws CoreException {
        Pattern p = Pattern.compile("line (\\d*)");
        Matcher m = p.matcher(linkText);
        if (m.find()) {
            String lineText = m.group(1);
            try {
                return Integer.parseInt(lineText);
            }
            catch (NumberFormatException e) {
                Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.PythonFileHyperlink_Unable_to_parse_line_number_from_hyperlink__6, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.PythonFileHyperlink_Unable_to_parse_line_number_from_hyperlink__7, null);
        throw new CoreException((IStatus)status);
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws CoreException {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            return line.trim();
        }
        catch (BadLocationException e) {
            Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.PythonFileHyperlink_Unable_to_retrieve_hyperlink_text__8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

