/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui;

import java.util.Hashtable;
import org.eclipse.help.ui.IEngineDescriptor;
import org.eclipse.help.ui.ISearchScopePage;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class RootScopePage
extends PreferencePage
implements ISearchScopePage {
    private IEngineDescriptor ed;
    private String scopeSetName;
    private Button masterButton;
    private Text labelText;
    private Text descText;
    private final Hashtable<Control, Boolean> disabledStates = new Hashtable();
    private Label spacer;
    private Composite contentContainer;

    @Override
    public void init(IEngineDescriptor ed, String scopeSetName) {
        this.ed = ed;
        this.scopeSetName = scopeSetName;
    }

    protected final Control createContents(Composite parent) {
        int ccol;
        GridData gd;
        this.initializeDefaults(this.getPreferenceStore());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.searchScope");
        this.contentContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.contentContainer.setLayout((Layout)layout);
        if (this.isInPreferenceDialog()) {
            this.masterButton = new Button(this.contentContainer, 32);
            this.masterButton.setText(Messages.RootScopePage_masterButton);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.masterButton.setLayoutData((Object)gd);
            this.spacer = new Label(this.contentContainer, 0);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.spacer.setLayoutData((Object)gd);
            boolean masterValue = this.getPreferenceStore().getBoolean(ScopeSet.getMasterKey(this.ed.getId()));
            this.masterButton.setSelection(masterValue);
            this.masterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RootScopePage.this.masterValueChanged(RootScopePage.this.masterButton.getSelection());
                }
            });
            Label label = new Label(this.contentContainer, 0);
            label.setText(Messages.RootScopePage_name);
            this.labelText = new Text(this.contentContainer, 2048);
            gd = new GridData(768);
            gd.widthHint = 200;
            this.labelText.setLayoutData((Object)gd);
            this.labelText.setEditable(this.ed.isUserDefined());
            label = new Label(this.contentContainer, 0);
            label.setText(Messages.RootScopePage_desc);
            gd = new GridData(2);
            label.setLayoutData((Object)gd);
            this.descText = new Text(this.contentContainer, 2114);
            gd = new GridData(768);
            this.descText.setEditable(this.ed.isUserDefined());
            gd.widthHint = 200;
            gd.heightHint = 48;
            this.descText.setLayoutData((Object)gd);
        }
        if ((ccol = this.createScopeContents(this.contentContainer)) > layout.numColumns && this.isInPreferenceDialog()) {
            layout.numColumns = ccol;
            gd = (GridData)this.masterButton.getLayoutData();
            gd.horizontalSpan = layout.numColumns;
            gd = (GridData)this.spacer.getLayoutData();
            gd.horizontalSpan = layout.numColumns;
            gd = (GridData)this.labelText.getLayoutData();
            gd.horizontalSpan = layout.numColumns - 1;
            gd = (GridData)this.descText.getLayoutData();
            gd.horizontalSpan = layout.numColumns - 1;
        }
        this.updateControls(true);
        return this.contentContainer;
    }

    protected void masterValueChanged(boolean value) {
        this.updateEnableState(value);
    }

    private void updateEnableState(boolean enabled) {
        Control[] children = this.contentContainer.getChildren();
        boolean first = this.disabledStates.isEmpty();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != this.masterButton) {
                if (!enabled) {
                    this.disabledStates.put(child, child.isEnabled());
                    child.setEnabled(false);
                } else {
                    Boolean savedState = this.disabledStates.get(child);
                    if (!first) {
                        child.setEnabled(savedState != null ? savedState : true);
                    }
                }
            }
            ++i;
        }
    }

    protected String getScopeSetName() {
        return this.scopeSetName;
    }

    protected IEngineDescriptor getEngineDescriptor() {
        return this.ed;
    }

    protected boolean isEngineEnabled() {
        if (!this.isInPreferenceDialog()) {
            return true;
        }
        return this.masterButton.getSelection();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue(ScopeSet.getMasterKey(this.ed.getId()), this.isEngineEnabled());
        if (this.labelText != null) {
            this.ed.setLabel(this.labelText.getText());
            this.ed.setDescription(this.descText.getText());
        }
        return true;
    }

    protected void performDefaults() {
        this.getPreferenceStore().setToDefault(ScopeSet.getMasterKey(this.ed.getId()));
        this.updateControls(false);
        super.performDefaults();
    }

    private void updateControls(boolean first) {
        if (this.isInPreferenceDialog()) {
            boolean cvalue;
            boolean value = this.getPreferenceStore().getBoolean(ScopeSet.getMasterKey(this.ed.getId()));
            if (value != (cvalue = this.masterButton.getSelection())) {
                this.masterButton.setSelection(value);
                this.masterValueChanged(value);
            } else if (first) {
                this.masterValueChanged(value);
            }
            this.labelText.setText(this.ed.getLabel());
            this.descText.setText(this.ed.getDescription());
        }
    }

    private boolean isInPreferenceDialog() {
        return this.getContainer() != null;
    }

    protected void initializeDefaults(IPreferenceStore store) {
        Boolean value = (Boolean)this.ed.getParameters().get("__enabled__");
        store.setDefault(ScopeSet.getMasterKey(this.ed.getId()), value.booleanValue());
    }

    protected abstract int createScopeContents(Composite var1);
}

