/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.debug.ui.launchConfigurations.AbstractVMInstallPage;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryContentProvider;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryLabelProvider;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryStandin;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.ExecutionEnvironmentDescription;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class VMLibraryBlock
extends AbstractVMInstallPage
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "VMLibraryBlock";
    protected boolean fInCallback = false;
    protected VMStandin fVmInstall;
    protected LibraryContentProvider fLibraryContentProvider;
    protected TreeViewer fLibraryViewer;
    private Button fUpButton;
    private Button fDownButton;
    private Button fRemoveButton;
    private Button fAddButton;
    private Button fJavadocButton;
    private Button fSourceButton;
    protected Button fDefaultButton;
    private final IStatus[] fLibStatus = new IStatus[]{Status.OK_STATUS};
    private Button fAnnotationsButton;

    VMLibraryBlock() {
        super(JREMessages.VMLibraryBlock_2);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)font, (int)2, (int)1, (int)1808, (int)0, (int)0);
        this.fLibraryViewer = new TreeViewer(comp);
        GridData gd = new GridData(1808);
        gd.heightHint = 6;
        this.fLibraryViewer.getControl().setLayoutData((Object)gd);
        this.fLibraryContentProvider = new LibraryContentProvider();
        this.fLibraryViewer.setContentProvider((IContentProvider)this.fLibraryContentProvider);
        this.fLibraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.fLibraryViewer.setInput((Object)this);
        this.fLibraryViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = SWTFactory.createComposite((Composite)comp, (Font)font, (int)1, (int)1, (int)258, (int)0, (int)0);
        this.fAddButton = SWTFactory.createPushButton((Composite)pathButtonComp, (String)JREMessages.VMLibraryBlock_7, (String)JREMessages.VMLibraryBlock_16, null);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fJavadocButton = SWTFactory.createPushButton((Composite)pathButtonComp, (String)JREMessages.VMLibraryBlock_3, (String)JREMessages.VMLibraryBlock_17, null);
        this.fJavadocButton.setEnabled(false);
        this.fJavadocButton.addSelectionListener((SelectionListener)this);
        this.fSourceButton = SWTFactory.createPushButton((Composite)pathButtonComp, (String)JREMessages.VMLibraryBlock_11, (String)JREMessages.VMLibraryBlock_18, null);
        this.fSourceButton.setEnabled(false);
        this.fSourceButton.addSelectionListener((SelectionListener)this);
        this.fAnnotationsButton = SWTFactory.createPushButton((Composite)pathButtonComp, (String)JREMessages.VMExternalAnnsBlock_3, (String)JREMessages.VMExternalAnnsBlock_4, null);
        this.fAnnotationsButton.setEnabled(false);
        this.fAnnotationsButton.addSelectionListener((SelectionListener)this);
        this.fLibraryViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getViewer().getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof LibraryContentProvider.SubElement) {
                    VMLibraryBlock.this.edit(sel, ((LibraryContentProvider.SubElement)obj).getType());
                }
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton((Composite)pathButtonComp, (String)JREMessages.VMLibraryBlock_6, (String)JREMessages.VMLibraryBlock_12, null);
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fUpButton = SWTFactory.createPushButton((Composite)pathButtonComp, (String)JREMessages.VMLibraryBlock_4, (String)JREMessages.VMLibraryBlock_13, null);
        this.fUpButton.setEnabled(false);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        this.fDownButton = SWTFactory.createPushButton((Composite)pathButtonComp, (String)JREMessages.VMLibraryBlock_5, (String)JREMessages.VMLibraryBlock_14, null);
        this.fDownButton.setEnabled(false);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        this.fDefaultButton = SWTFactory.createPushButton((Composite)pathButtonComp, (String)JREMessages.VMLibraryBlock_9, (String)JREMessages.VMLibraryBlock_15, null);
        this.fDefaultButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)comp);
    }

    private void restoreDefaultLibraries() {
        LibraryLocation[] libs = null;
        File installLocation = null;
        if (this.fVmInstall != null) {
            if ("org.eclipse.jdt.launching.EEVMType".equals(this.fVmInstall.getVMInstallType().getId())) {
                File definitionFile = null;
                String path = this.fVmInstall.getAttribute("ATTR_DEFINITION_FILE");
                if (path != null) {
                    definitionFile = new File(path);
                }
                if (definitionFile != null) {
                    try {
                        ExecutionEnvironmentDescription desc = new ExecutionEnvironmentDescription(definitionFile);
                        libs = desc.getLibraryLocations();
                    }
                    catch (CoreException e) {
                        libs = new LibraryLocation[]{};
                    }
                } else {
                    libs = new LibraryLocation[]{};
                }
            } else {
                installLocation = this.fVmInstall.getInstallLocation();
                libs = installLocation == null ? new LibraryLocation[]{} : this.fVmInstall.getVMInstallType().getDefaultLibraryLocations(installLocation);
            }
        }
        this.fLibraryContentProvider.setLibraries(libs);
        this.update();
    }

    private void update() {
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        if (this.fLibraryContentProvider.getLibraries().length == 0) {
            status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, JREMessages.VMLibraryBlock_19, null);
        }
        LibraryStandin[] standins = this.fLibraryContentProvider.getStandins();
        int i = 0;
        while (i < standins.length) {
            IStatus st = standins[i].validate();
            if (!st.isOK()) {
                status = st;
                break;
            }
            ++i;
        }
        this.fLibStatus[0] = status;
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        }
        if (this.getContainer().getCurrentPage() != this) {
            this.getContainer().updateMessage();
            this.getContainer().updateButtons();
        }
    }

    protected boolean isDefaultLocations(IVMInstall vm) {
        LibraryLocation[] def;
        LibraryLocation[] libraryLocations = this.fLibraryContentProvider.getLibraries();
        if (vm == null || libraryLocations == null) {
            return true;
        }
        File installLocation = vm.getInstallLocation();
        if (installLocation != null && (def = vm.getVMInstallType().getDefaultLibraryLocations(installLocation)).length == libraryLocations.length) {
            int i = 0;
            while (i < def.length) {
                if (!def[i].equals((Object)libraryLocations[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        boolean completed = true;
        Object source = e.getSource();
        if (source == this.fUpButton) {
            this.fLibraryContentProvider.up((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDownButton) {
            this.fLibraryContentProvider.down((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fRemoveButton) {
            this.fLibraryContentProvider.remove((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fAddButton) {
            completed = this.add((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fJavadocButton) {
            this.edit((IStructuredSelection)this.fLibraryViewer.getSelection(), 1);
        } else if (source == this.fSourceButton) {
            this.edit((IStructuredSelection)this.fLibraryViewer.getSelection(), 2);
        } else if (source == this.fAnnotationsButton) {
            this.edit((IStructuredSelection)this.fLibraryViewer.getSelection(), 3);
        } else if (source == this.fDefaultButton) {
            this.restoreDefaultLibraries();
        }
        if (completed) {
            this.update();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean add(IStructuredSelection selection) {
        IDialogSettings dialogSettings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get(LAST_PATH_SETTING);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.fLibraryViewer.getControl().getShell(), 0x10000002);
        dialog.setText(JREMessages.VMLibraryBlock_10);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip", "*.*"});
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return false;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        LibraryLocation[] libs = new LibraryLocation[nChosen];
        int i = 0;
        while (i < nChosen) {
            libs[i] = new LibraryLocation(filterPath.append(fileNames[i]).makeAbsolute(), (IPath)Path.EMPTY, (IPath)Path.EMPTY);
            ++i;
        }
        dialogSettings.put(LAST_PATH_SETTING, filterPath.toOSString());
        this.fLibraryContentProvider.add(libs, selection);
        return true;
    }

    private void edit(IStructuredSelection selection, int type) {
        Object obj = selection.getFirstElement();
        LibraryStandin standin = null;
        if (obj instanceof LibraryStandin) {
            standin = (LibraryStandin)obj;
        } else if (obj instanceof LibraryContentProvider.SubElement) {
            LibraryContentProvider.SubElement sub = (LibraryContentProvider.SubElement)obj;
            standin = sub.getParent();
        }
        if (standin != null) {
            LibraryLocation library = standin.toLibraryLocation();
            switch (type) {
                case 1: {
                    URL[] urls = BuildPathDialogAccess.configureJavadocLocation((Shell)this.fLibraryViewer.getControl().getShell(), (String)library.getSystemLibraryPath().toOSString(), (URL)library.getJavadocLocation());
                    if (urls == null) break;
                    this.fLibraryContentProvider.setJavadoc(urls[0], selection);
                    break;
                }
                case 2: {
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)library.getSystemLibraryPath());
                    entry.setSourceAttachmentPath(library.getSystemLibrarySourcePath());
                    entry.setSourceAttachmentRootPath(library.getPackageRootPath());
                    IClasspathEntry classpathEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)this.fLibraryViewer.getControl().getShell(), (IClasspathEntry)entry.getClasspathEntry());
                    if (classpathEntry == null) break;
                    this.fLibraryContentProvider.setSourcePath(classpathEntry.getSourceAttachmentPath(), classpathEntry.getSourceAttachmentRootPath(), selection);
                    break;
                }
                case 3: {
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)library.getSystemLibraryPath());
                    entry.setExternalAnnotationsPath(library.getExternalAnnotationsPath());
                    IClasspathAttribute[] extraAttributes = entry.getClasspathEntry().getExtraAttributes();
                    String annotationPathString = VMLibraryBlock.findClasspathAttribute(extraAttributes, "annotationpath");
                    Path annotationPath = annotationPathString == null ? null : new Path(annotationPathString);
                    IPath newPath = BuildPathDialogAccess.configureExternalAnnotationsAttachment((Shell)this.fLibraryViewer.getControl().getShell(), (IPath)annotationPath);
                    if (newPath == null) {
                        return;
                    }
                    this.fLibraryContentProvider.setAnnotationsPath(newPath.segmentCount() == 0 ? null : newPath, selection);
                    break;
                }
            }
        }
    }

    private static String findClasspathAttribute(IClasspathAttribute[] attributes, String name) {
        int i = attributes.length;
        while (--i >= 0) {
            if (!name.equals(attributes[i].getName())) continue;
            return attributes[i].getValue();
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fLibraryViewer.getSelection();
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        boolean enableUp = true;
        boolean enableDown = true;
        boolean allSource = true;
        boolean allJavadoc = true;
        boolean allAnnotations = true;
        boolean allRoots = true;
        Object[] libraries = this.fLibraryContentProvider.getElements(null);
        if (selection.isEmpty() || libraries.length == 0) {
            enableUp = false;
            enableDown = false;
        } else {
            Object first = libraries[0];
            Object last = libraries[libraries.length - 1];
            for (Object element : selection) {
                Object lib;
                if (element instanceof LibraryContentProvider.SubElement) {
                    allRoots = false;
                    LibraryContentProvider.SubElement subElement = (LibraryContentProvider.SubElement)element;
                    lib = subElement.getParent().toLibraryLocation();
                    switch (subElement.getType()) {
                        case 1: {
                            allSource = false;
                            allAnnotations = false;
                            break;
                        }
                        case 2: {
                            allAnnotations = false;
                            allJavadoc = false;
                            break;
                        }
                        case 3: {
                            allJavadoc = false;
                            allSource = false;
                        }
                    }
                } else {
                    lib = element;
                    allSource = false;
                    allJavadoc = false;
                    allAnnotations = false;
                }
                if (lib == first) {
                    enableUp = false;
                }
                if (lib != last) continue;
                enableDown = false;
            }
        }
        this.fUpButton.setEnabled(enableUp);
        this.fDownButton.setEnabled(enableDown);
        this.fJavadocButton.setEnabled(!selection.isEmpty() && (allJavadoc || allRoots));
        this.fSourceButton.setEnabled(!selection.isEmpty() && (allSource || allRoots));
        this.fAnnotationsButton.setEnabled(!selection.isEmpty() && (allAnnotations || allRoots));
    }

    @Override
    public boolean finish() {
        if (this.fVmInstall != null) {
            if (this.isDefaultLocations((IVMInstall)this.fVmInstall)) {
                this.fVmInstall.setLibraryLocations(null);
            } else {
                LibraryLocation[] libs = this.fLibraryContentProvider.getLibraries();
                this.fVmInstall.setLibraryLocations(libs);
            }
        }
        return true;
    }

    @Override
    public VMStandin getSelection() {
        return this.fVmInstall;
    }

    @Override
    public void setSelection(VMStandin vm) {
        super.setSelection(vm);
        LibraryLocation[] libraryLocations = null;
        libraryLocations = vm == null ? new LibraryLocation[]{} : JavaRuntime.getLibraryLocations((IVMInstall)vm);
        this.fVmInstall = vm;
        this.fLibraryContentProvider.setLibraries(libraryLocations);
    }

    @Override
    protected IStatus[] getVMStatus() {
        return this.fLibStatus;
    }
}

